/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import com.ibm.icu.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.statushandlers.IStatusDialogConstants;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.statushandlers.AbstractStatusAreaProvider;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.WorkbenchStatusDialogManager;

public class DefaultDetailsArea
extends AbstractStatusAreaProvider {
    private WorkbenchStatusDialogManager workbenchStatusDialog;
    protected static final int MASK = 15;
    private static final Object NESTING_INDENT = "  ";
    private org.eclipse.swt.widgets.List list;
    static /* synthetic */ Class class$0;

    public DefaultDetailsArea(WorkbenchStatusDialogManager wsd) {
        this.workbenchStatusDialog = wsd;
    }

    public Control createSupportArea(Composite parent, StatusAdapter statusAdapter) {
        Composite area = this.createArea(parent);
        this.setStatusAdapter(statusAdapter);
        return area;
    }

    protected Composite createArea(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.list = new org.eclipse.swt.widgets.List(parent, 2818);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 250;
        gd.heightHint = 100;
        this.list.setLayoutData((Object)gd);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBindingService binding = (IBindingService)iWorkbench.getService(clazz);
        final TriggerSequence[] ts = binding.getActiveBindingsFor(ActionFactory.COPY.getCommandId());
        this.list.addKeyListener(new KeyListener(){
            ArrayList keyList = new ArrayList();

            public void keyPressed(KeyEvent e) {
                boolean ctrlDown;
                int character = e.character;
                boolean bl = ctrlDown = (e.stateMask & 0x40000) != 0;
                if (ctrlDown && e.character != e.keyCode && e.character < ' ' && (e.keyCode & 0x1000000) == 0) {
                    character = (char)(character + 64);
                }
                if ((e.keyCode & ~SWT.MODIFIER_MASK) == 0) {
                    return;
                }
                KeyStroke ks = KeyStroke.getInstance((int)e.stateMask, (int)(character != 0 ? character : e.keyCode));
                this.keyList.add(ks);
                KeySequence sequence = KeySequence.getInstance((List)this.keyList);
                boolean partialMatch = false;
                int i = 0;
                while (i < ts.length) {
                    if (ts[i].equals((Object)sequence)) {
                        DefaultDetailsArea.this.copyToClipboard();
                        this.keyList.clear();
                        break;
                    }
                    if (ts[i].startsWith((TriggerSequence)sequence, false)) {
                        partialMatch = true;
                    }
                    int j = 0;
                    while (j < ts[i].getTriggers().length) {
                        if (ts[i].getTriggers()[j].equals((Object)ks)) {
                            partialMatch = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!partialMatch) {
                    this.keyList.clear();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.createDNDSource();
        this.createCopyAction(parent);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void setStatusAdapter(StatusAdapter adapter) {
        Long timestamp;
        this.list.removeAll();
        this.populateList(this.list, adapter.getStatus(), 0);
        if (this.workbenchStatusDialog.getStatusAdapters().size() == 1 && (timestamp = (Long)adapter.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY)) != null) {
            String date = DateFormat.getDateTimeInstance((int)1, (int)1).format(new Date(timestamp));
            this.list.add(NLS.bind((String)ProgressMessages.JobInfo_Error, (Object[])new Object[]{"", date}));
        }
    }

    private void createDNDSource() {
        DragSource ds = new DragSource((Control)this.list, 1);
        ds.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        ds.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = DefaultDetailsArea.this.prepareCopyString();
                }
            }

            public void dragStart(DragSourceEvent event) {
                DefaultDetailsArea.this.list.selectAll();
            }
        });
    }

    private void createCopyAction(Composite parent) {
        Menu menu = new Menu((Decorations)parent.getShell(), 8);
        MenuItem copyAction = new MenuItem(menu, 8);
        copyAction.setText(JFaceResources.getString((String)"copy"));
        copyAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDetailsArea.this.copyToClipboard();
                super.widgetSelected(e);
            }
        });
        this.list.setMenu(menu);
    }

    private String prepareCopyString() {
        if (this.list == null || this.list.isDisposed()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String newLine = System.getProperty("line.separator");
        String[] selection = this.list.getSelection();
        int i = 0;
        while (i < selection.length) {
            sb.append(selection[i]);
            sb.append(newLine);
            ++i;
        }
        return sb.toString();
    }

    private void populateList(org.eclipse.swt.widgets.List list, IStatus status, int nesting) {
        if (!(status.matches(15) || this.isDialogHandlingOKStatuses() && status.isOK())) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING_INDENT);
            ++i;
        }
        buffer.append(status.getMessage());
        list.add(buffer.toString());
        Throwable t = status.getException();
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            this.populateList(list, ce.getStatus(), nesting + 1);
        } else if (t != null) {
            buffer = new StringBuffer();
            int i2 = 0;
            while (i2 < nesting) {
                buffer.append(NESTING_INDENT);
                ++i2;
            }
            String message = t.getLocalizedMessage();
            if (message == null) {
                message = t.toString();
            }
            buffer.append(message);
            list.add(buffer.toString());
        }
        IStatus[] children = status.getChildren();
        int i3 = 0;
        while (i3 < children.length) {
            this.populateList(list, children[i3], nesting + 1);
            ++i3;
        }
    }

    public org.eclipse.swt.widgets.List getList() {
        return this.list;
    }

    private void copyToClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.list.getDisplay());
            clipboard.setContents(new Object[]{this.prepareCopyString()}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    private boolean isDialogHandlingOKStatuses() {
        return (Boolean)this.workbenchStatusDialog.getProperty(IStatusDialogConstants.HANDLE_OK_STATUSES);
    }
}

