/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.util.Registry;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryImpl<T>
implements Registry<T>,
BundleContextAware,
DisposableBean {
    protected Log LOG = LogFactory.getLog(this.getClass());
    private ConcurrentMap<T, Map<String, ?>> registry = new ConcurrentHashMap();
    protected BundleContext bundleContext;

    @Override
    public void register(T key, Map<String, ?> properties) throws SwordfishException {
        Assert.notNull(key, (String)"key should not be null");
        this.LOG.debug((Object)("Registering " + key.toString()));
        if (properties == null) {
            properties = new HashMap();
        }
        if (this.registry.putIfAbsent(key, properties) == null) {
            try {
                this.doRegister(key, properties);
            }
            catch (Exception e) {
                this.LOG.info((Object)("Unable to register key " + key + " with properties " + properties + ". Reason: " + e));
                this.registry.remove(key);
                throw new SwordfishException("Unable to register key " + key + " with properties " + properties + ". Reason: " + e, (Throwable)e);
            }
        }
    }

    @Override
    public void unregister(T key, Map<String, ?> properties) throws SwordfishException {
        Assert.notNull(key, (String)"key should not be null");
        if (key != null && this.registry.containsKey(key)) {
            try {
                this.doUnregister(key, properties);
                this.registry.remove(key);
            }
            catch (Exception e) {
                this.LOG.info((Object)("Unable to unregister key " + key + ". Reason: " + e));
                throw new SwordfishException("Unable to unregister key " + key + ". Reason: " + e, (Throwable)e);
            }
        }
    }

    protected void doRegister(T key, Map<String, ?> properties) throws Exception {
    }

    protected void doUnregister(T key, Map<String, ?> properties) throws Exception {
    }

    @Override
    public Set<T> getKeySet() {
        HashSet defensiveSet = new HashSet(this.registry.keySet());
        return defensiveSet;
    }

    @Override
    public Map<String, ?> getProperties(T key) {
        return (Map)this.registry.get(key);
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void destroy() throws Exception {
        this.registry.clear();
        this.doDestroy();
    }

    protected void doDestroy() throws Exception {
    }
}

