/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.internal.p2.publisher.eclipse.GeneratorBundleInfo;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IBundleShapeAdvice;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundlesAction
extends AbstractPublisherAction {
    protected static final String ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR = "org.eclipse.equinox.simpleconfigurator";
    protected static final String ORG_ECLIPSE_UPDATE_CONFIGURATOR = "org.eclipse.update.configurator";
    public static final String TYPE_ECLIPSE_BUNDLE = "bundle";
    public static final String TYPE_ECLIPSE_SOURCE = "source";
    public static final String OSGI_BUNDLE_CLASSIFIER = "osgi.bundle";
    private static final String CAPABILITY_NS_OSGI_BUNDLE = "osgi.bundle";
    private static final String CAPABILITY_NS_OSGI_FRAGMENT = "osgi.fragment";
    public static final IProvidedCapability BUNDLE_CAPABILITY = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", (Version)new Version(1, 0, 0));
    public static final IProvidedCapability SOURCE_BUNDLE_CAPABILITY = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"source", (Version)new Version(1, 0, 0));
    static final String DEFAULT_BUNDLE_LOCALIZATION = "plugin";
    private static final String[] BUNDLE_IU_PROPERTY_MAP = new String[]{"Bundle-Name", "org.eclipse.equinox.p2.name", "Bundle-Description", "org.eclipse.equinox.p2.description", "Bundle-Vendor", "org.eclipse.equinox.p2.provider", "Bundle-ContactAddress", "org.eclipse.equinox.p2.contact", "Bundle-DocURL", "org.eclipse.equinox.p2.doc.url", "Bundle-UpdateLocation", "org.eclipse.equinox.p2.bundle.localization", "Bundle-Localization", "org.eclipse.equinox.p2.bundle.localization"};
    public static final int BUNDLE_LOCALIZATION_INDEX = PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES.length - 1;
    public static final String DIR = "dir";
    public static final String JAR = "jar";
    private static final String FEATURE_FILENAME_DESCRIPTOR = "feature.xml";
    private static final String PLUGIN_FILENAME_DESCRIPTOR = "plugin.xml";
    private static final String FRAGMENT_FILENAME_DESCRIPTOR = "fragment.xml";
    public static String BUNDLE_SHAPE = "Eclipse-BundleShape";
    private File[] locations;
    private BundleDescription[] bundles;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static IArtifactKey createBundleArtifactKey(String bsn, String version) {
        return new ArtifactKey("osgi.bundle", bsn, new Version(version));
    }

    public static IInstallableUnit createBundleConfigurationUnit(String hostId, Version cuVersion, boolean isBundleFragment, GeneratorBundleInfo configInfo, String configurationFlavor, String filter) {
        if (configInfo == null) {
            return null;
        }
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = String.valueOf(configurationFlavor) + hostId;
        cu.setId(configUnitId);
        cu.setVersion(cuVersion);
        Version hostVersion = Version.parseVersion((String)configInfo.getVersion());
        cu.setHost(new IRequiredCapability[]{MetadataFactory.createRequiredCapability((String)"osgi.bundle", (String)hostId, (org.eclipse.equinox.internal.provisional.p2.core.VersionRange)new org.eclipse.equinox.internal.provisional.p2.core.VersionRange(hostVersion, true, PublisherHelper.versionMax, true), null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)TYPE_ECLIPSE_BUNDLE, (org.eclipse.equinox.internal.provisional.p2.core.VersionRange)new org.eclipse.equinox.internal.provisional.p2.core.VersionRange(new Version(1, 0, 0), true, new Version(2, 0, 0), false), null, (boolean)false, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{PublisherHelper.createSelfCapability(configUnitId, cuVersion), MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.flavor", (String)configurationFlavor, (Version)new Version(1, 0, 0))});
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "installBundle(bundle:${artifact})");
        touchpointData.put("uninstall", "uninstallBundle(bundle:${artifact})");
        touchpointData.put("configure", BundlesAction.createConfigScript(configInfo, isBundleFragment));
        touchpointData.put("unconfigure", BundlesAction.createUnconfigScript(configInfo, isBundleFragment));
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        cu.setFilter(filter);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    public static IInstallableUnit createBundleIU(BundleDescription bd, IArtifactKey key, IPublisherInfo info) {
        Map manifest = (Map)bd.getUserObject();
        Map manifestLocalizations = null;
        if (manifest != null && bd.getLocation() != null) {
            manifestLocalizations = BundlesAction.getManifestLocalizations(manifest, new File(bd.getLocation()));
        }
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(bd.isSingleton());
        iu.setId(bd.getSymbolicName());
        iu.setVersion(Version.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion()));
        iu.setFilter(bd.getPlatformFilter());
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)bd.getSymbolicName(), (org.eclipse.equinox.internal.provisional.p2.core.VersionRange)BundlesAction.computeUpdateRange(bd.getVersion()), (int)0, null));
        iu.setArtifacts(new IArtifactKey[]{key});
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
        boolean isFragment = bd.getHost() != null;
        BundleSpecification[] requiredBundles = bd.getRequiredBundles();
        ArrayList<IRequiredCapability> reqsDeps = new ArrayList<IRequiredCapability>();
        if (isFragment) {
            reqsDeps.add(MetadataFactory.createRequiredCapability((String)"osgi.bundle", (String)bd.getHost().getName(), (org.eclipse.equinox.internal.provisional.p2.core.VersionRange)org.eclipse.equinox.internal.provisional.p2.core.VersionRange.fromOSGiVersionRange((VersionRange)bd.getHost().getVersionRange()), null, (boolean)false, (boolean)false));
        }
        int j = 0;
        while (j < requiredBundles.length) {
            reqsDeps.add(MetadataFactory.createRequiredCapability((String)"osgi.bundle", (String)requiredBundles[j].getName(), (org.eclipse.equinox.internal.provisional.p2.core.VersionRange)org.eclipse.equinox.internal.provisional.p2.core.VersionRange.fromOSGiVersionRange((VersionRange)requiredBundles[j].getVersionRange()), null, (boolean)requiredBundles[j].isOptional(), (boolean)false));
            ++j;
        }
        ImportPackageSpecification[] osgiImports = bd.getImportPackages();
        int i = 0;
        while (i < osgiImports.length) {
            ImportPackageSpecification importSpec = osgiImports[i];
            String importPackageName = importSpec.getName();
            if (importPackageName.indexOf(42) == -1) {
                org.eclipse.equinox.internal.provisional.p2.core.VersionRange versionRange = org.eclipse.equinox.internal.provisional.p2.core.VersionRange.fromOSGiVersionRange((VersionRange)importSpec.getVersionRange());
                reqsDeps.add(MetadataFactory.createRequiredCapability((String)"java.package", (String)importPackageName, (org.eclipse.equinox.internal.provisional.p2.core.VersionRange)versionRange, null, (boolean)BundlesAction.isOptional(importSpec), (boolean)false));
            }
            ++i;
        }
        iu.setRequiredCapabilities(reqsDeps.toArray(new IRequiredCapability[reqsDeps.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(PublisherHelper.createSelfCapability(bd.getSymbolicName(), Version.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion())));
        providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"osgi.bundle", (String)bd.getSymbolicName(), (Version)Version.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion())));
        ExportPackageDescription[] exports = bd.getExportPackages();
        int i2 = 0;
        while (i2 < exports.length) {
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"java.package", (String)exports[i2].getName(), (Version)Version.fromOSGiVersion((org.osgi.framework.Version)exports[i2].getVersion())));
            ++i2;
        }
        if (manifest != null && manifest.containsKey("Eclipse-SourceBundle")) {
            providedCapabilities.add(SOURCE_BUNDLE_CAPABILITY);
        } else {
            providedCapabilities.add(BUNDLE_CAPABILITY);
        }
        if (isFragment) {
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_OSGI_FRAGMENT, (String)bd.getHost().getName(), (Version)Version.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion())));
        }
        if (manifestLocalizations != null) {
            Iterator iter = manifestLocalizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)manifestLocalizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability(bd.getSymbolicName(), locale));
            }
        }
        iu.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        BundlesAction.processCapabilityAdvice(iu, info);
        if (manifest != null) {
            i = 0;
            while (i < BUNDLE_IU_PROPERTY_MAP.length) {
                String value;
                if (manifest.containsKey(BUNDLE_IU_PROPERTY_MAP[i]) && (value = (String)manifest.get(BUNDLE_IU_PROPERTY_MAP[i])) != null && value.length() > 0) {
                    iu.setProperty(BUNDLE_IU_PROPERTY_MAP[i + 1], value);
                }
                i += 2;
            }
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("manifest", BundlesAction.toManifestString(manifest));
        if (BundlesAction.isDir(bd, info)) {
            touchpointData.put("zipped", "true");
        }
        BundlesAction.processTouchpointAdvice(iu, touchpointData, info);
        BundlesAction.processInstallableUnitPropertiesAdvice(iu, info);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    static org.eclipse.equinox.internal.provisional.p2.core.VersionRange computeUpdateRange(org.osgi.framework.Version base) {
        org.eclipse.equinox.internal.provisional.p2.core.VersionRange updateRange = null;
        updateRange = !base.equals((Object)org.osgi.framework.Version.emptyVersion) ? new org.eclipse.equinox.internal.provisional.p2.core.VersionRange(Version.emptyVersion, true, Version.fromOSGiVersion((org.osgi.framework.Version)base), false) : new org.eclipse.equinox.internal.provisional.p2.core.VersionRange("0.0.0");
        return updateRange;
    }

    private IInstallableUnitFragment createHostLocalizationFragment(IInstallableUnit bundleIU, BundleDescription bd, String hostId, String[] hostBundleManifestValues) {
        Map hostLocalizations = BundlesAction.getHostLocalizations(new File(bd.getLocation()), hostBundleManifestValues);
        if (hostLocalizations != null) {
            return BundlesAction.createLocalizationFragmentOfHost(bd, hostId, hostBundleManifestValues, hostLocalizations);
        }
        return null;
    }

    private static IInstallableUnitFragment createLocalizationFragmentOfHost(BundleDescription bd, String hostId, String[] hostManifestValues, Map hostLocalizations) {
        MetadataFactory.InstallableUnitFragmentDescription fragment = new MetadataFactory.InstallableUnitFragmentDescription();
        String fragmentId = BundlesAction.makeHostLocalizationFragmentId(bd.getSymbolicName());
        fragment.setId(fragmentId);
        fragment.setVersion(Version.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion()));
        HostSpecification hostSpec = bd.getHost();
        IRequiredCapability[] hostReqs = new IRequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)hostSpec.getName(), (org.eclipse.equinox.internal.provisional.p2.core.VersionRange)org.eclipse.equinox.internal.provisional.p2.core.VersionRange.fromOSGiVersionRange((VersionRange)hostSpec.getVersionRange()), null, (boolean)false, (boolean)false, (boolean)false)};
        fragment.setHost(hostReqs);
        fragment.setSingleton(true);
        fragment.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>(hostLocalizations.keySet().size());
        Iterator iter = hostLocalizations.keySet().iterator();
        while (iter.hasNext()) {
            Locale locale = (Locale)iter.next();
            Properties translatedStrings = (Properties)hostLocalizations.get(locale);
            Enumeration<?> propertyKeys = translatedStrings.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String nextKey = (String)propertyKeys.nextElement();
                fragment.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
            }
            providedCapabilities.add(PublisherHelper.makeTranslationCapability(hostId, locale));
        }
        fragment.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        return MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)fragment);
    }

    private static String makeHostLocalizationFragmentId(String id) {
        return String.valueOf(id) + ".translated_host_properties";
    }

    private static String createConfigScript(GeneratorBundleInfo configInfo, boolean isBundleFragment) {
        if (configInfo == null) {
            return "";
        }
        String configScript = "";
        if (!isBundleFragment && configInfo.getStartLevel() != -1) {
            configScript = String.valueOf(configScript) + "setStartLevel(startLevel:" + configInfo.getStartLevel() + ");";
        }
        if (!isBundleFragment && configInfo.isMarkedAsStarted()) {
            configScript = String.valueOf(configScript) + "markStarted(started: true);";
        }
        if (configInfo.getSpecialConfigCommands() != null) {
            configScript = String.valueOf(configScript) + configInfo.getSpecialConfigCommands();
        }
        return configScript;
    }

    private static String createDefaultBundleConfigScript(GeneratorBundleInfo configInfo) {
        return BundlesAction.createConfigScript(configInfo, false);
    }

    public static IInstallableUnit createDefaultBundleConfigurationUnit(GeneratorBundleInfo configInfo, GeneratorBundleInfo unconfigInfo, String configurationFlavor) {
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = PublisherHelper.createDefaultConfigUnitId("osgi.bundle", configurationFlavor);
        cu.setId(configUnitId);
        Version configUnitVersion = new Version(1, 0, 0);
        cu.setVersion(configUnitVersion);
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{PublisherHelper.createSelfCapability(configUnitId, configUnitVersion), MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.flavor", (String)configurationFlavor, (Version)new Version(1, 0, 0))});
        IRequiredCapability[] reqs = new IRequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)TYPE_ECLIPSE_BUNDLE, (org.eclipse.equinox.internal.provisional.p2.core.VersionRange)org.eclipse.equinox.internal.provisional.p2.core.VersionRange.emptyRange, null, (boolean)false, (boolean)true, (boolean)false)};
        cu.setHost(reqs);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "installBundle(bundle:${artifact})");
        touchpointData.put("uninstall", "uninstallBundle(bundle:${artifact})");
        touchpointData.put("configure", BundlesAction.createDefaultBundleConfigScript(configInfo));
        touchpointData.put("unconfigure", BundlesAction.createDefaultBundleUnconfigScript(unconfigInfo));
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    private static String createDefaultBundleUnconfigScript(GeneratorBundleInfo unconfigInfo) {
        return BundlesAction.createUnconfigScript(unconfigInfo, false);
    }

    private static String createUnconfigScript(GeneratorBundleInfo unconfigInfo, boolean isBundleFragment) {
        if (unconfigInfo == null) {
            return "";
        }
        String unconfigScript = "";
        if (!isBundleFragment && unconfigInfo.getStartLevel() != -1) {
            unconfigScript = String.valueOf(unconfigScript) + "setStartLevel(startLevel:-1);";
        }
        if (!isBundleFragment && unconfigInfo.isMarkedAsStarted()) {
            unconfigScript = String.valueOf(unconfigScript) + "markStarted(started: false);";
        }
        if (unconfigInfo.getSpecialUnconfigCommands() != null) {
            unconfigScript = String.valueOf(unconfigScript) + unconfigInfo.getSpecialUnconfigCommands();
        }
        return unconfigScript;
    }

    private static boolean isOptional(ImportPackageSpecification importedPackage) {
        return importedPackage.getDirective("resolution").equals("dynamic") || importedPackage.getDirective("resolution").equals("optional");
    }

    private static String toManifestString(Map p) {
        if (p == null) {
            return null;
        }
        Set properties = p.entrySet();
        StringBuffer result = new StringBuffer();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Map.Entry aProperty = (Map.Entry)iterator.next();
            if (aProperty.getKey().equals(BUNDLE_SHAPE)) continue;
            result.append(aProperty.getKey()).append(": ").append(aProperty.getValue()).append('\n');
        }
        return result.toString();
    }

    private static Map getManifestLocalizations(Map manifest, File bundleLocation) {
        Locale defaultLocale = null;
        String[] bundleManifestValues = BundlesAction.getManifestCachedValues(manifest);
        String bundleLocalization = bundleManifestValues[BUNDLE_LOCALIZATION_INDEX];
        Map localizations = JAR.equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile() ? LocalizationHelper.getJarPropertyLocalizations(bundleLocation, bundleLocalization, defaultLocale, bundleManifestValues) : LocalizationHelper.getDirPropertyLocalizations(bundleLocation, bundleLocalization, defaultLocale, bundleManifestValues);
        return localizations;
    }

    public static String[] getExternalizedStrings(IInstallableUnit iu) {
        String[] result = new String[PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES.length];
        int j = 0;
        int i = 1;
        while (i < BUNDLE_IU_PROPERTY_MAP.length - 1) {
            if (iu.getProperty(BUNDLE_IU_PROPERTY_MAP[i]) != null && iu.getProperty(BUNDLE_IU_PROPERTY_MAP[i]).length() > 0 && iu.getProperty(BUNDLE_IU_PROPERTY_MAP[i]).charAt(0) == '%') {
                result[j++] = iu.getProperty(BUNDLE_IU_PROPERTY_MAP[i]).substring(1);
            } else {
                ++j;
            }
            i += 2;
        }
        result[BundlesAction.BUNDLE_LOCALIZATION_INDEX] = iu.getProperty("org.eclipse.equinox.p2.bundle.localization");
        return result;
    }

    public static String[] getManifestCachedValues(Map manifest) {
        String[] cachedValues = new String[PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES.length];
        int j = 0;
        while (j < PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES.length) {
            String value = (String)manifest.get(PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES[j]);
            if (PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES[j].equals("Bundle-Localization")) {
                if (value == null) {
                    value = DEFAULT_BUNDLE_LOCALIZATION;
                }
                cachedValues[j] = value;
            } else if (value != null && value.length() > 1 && value.charAt(0) == '%') {
                cachedValues[j] = value.substring(1);
            }
            ++j;
        }
        return cachedValues;
    }

    public static Map getHostLocalizations(File bundleLocation, String[] hostBundleManifestValues) {
        Locale defaultLocale = null;
        String hostBundleLocalization = hostBundleManifestValues[BUNDLE_LOCALIZATION_INDEX];
        if (hostBundleLocalization == null) {
            return null;
        }
        Map localizations = JAR.equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile() ? LocalizationHelper.getJarPropertyLocalizations(bundleLocation, hostBundleLocalization, defaultLocale, hostBundleManifestValues) : LocalizationHelper.getDirPropertyLocalizations(bundleLocation, hostBundleLocalization, defaultLocale, hostBundleManifestValues);
        return localizations;
    }

    private static PluginConverter acquirePluginConverter() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.pluginconversion.PluginConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (PluginConverter)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    private static Dictionary convertPluginManifest(File bundleLocation, boolean logConversionException) {
        PluginConverter converter;
        block6: {
            try {
                converter = BundlesAction.acquirePluginConverter();
                if (converter != null) break block6;
                String message = NLS.bind((String)Messages.exception_noPluginConverter, (Object)bundleLocation);
                LogHelper.log((IStatus)new Status(4, Activator.ID, message));
                return null;
            }
            catch (PluginConversionException convertException) {
                if (bundleLocation.getName().equals(FEATURE_FILENAME_DESCRIPTOR)) {
                    return null;
                }
                if (!new File(bundleLocation, PLUGIN_FILENAME_DESCRIPTOR).exists() && !new File(bundleLocation, FRAGMENT_FILENAME_DESCRIPTOR).exists()) {
                    return null;
                }
                if (logConversionException) {
                    Status status = new Status(2, Activator.ID, 0, NLS.bind((String)Messages.exception_errorConverting, (Object)bundleLocation.getAbsolutePath()), (Throwable)convertException);
                    LogHelper.log((IStatus)status);
                }
                return null;
            }
        }
        return converter.convertManifest(bundleLocation, false, null, true, null);
    }

    public static BundleDescription createBundleDescription(Dictionary enhancedManifest, File bundleLocation) {
        try {
            BundleDescription descriptor = StateObjectFactory.defaultFactory.createBundleDescription(null, enhancedManifest, bundleLocation == null ? null : bundleLocation.getAbsolutePath(), 1L);
            descriptor.setUserObject((Object)enhancedManifest);
            return descriptor;
        }
        catch (BundleException e) {
            String message = NLS.bind((String)Messages.exception_stateAddition, (Object)(bundleLocation == null ? null : bundleLocation.getAbsoluteFile()));
            Status status = new Status(2, Activator.ID, message, (Throwable)e);
            LogHelper.log((IStatus)status);
            return null;
        }
    }

    public static BundleDescription createBundleDescription(File bundleLocation) {
        Dictionary manifest = BundlesAction.loadManifest(bundleLocation);
        if (manifest == null) {
            return null;
        }
        return BundlesAction.createBundleDescription(manifest, bundleLocation);
    }

    public static Dictionary loadManifest(File bundleLocation) {
        Dictionary manifest = BundlesAction.basicLoadManifest(bundleLocation);
        if (manifest == null) {
            return null;
        }
        if (manifest.get(BUNDLE_SHAPE) == null) {
            manifest.put(BUNDLE_SHAPE, bundleLocation.isDirectory() ? DIR : JAR);
        }
        return manifest;
    }

    public static Dictionary basicLoadManifest(File bundleLocation) {
        InputStream manifestStream = null;
        ZipFile jarFile = null;
        try {
            if (JAR.equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File manifestFile = new File(bundleLocation, "META-INF/MANIFEST.MF");
                if (manifestFile.exists()) {
                    manifestStream = new BufferedInputStream(new FileInputStream(manifestFile));
                }
            }
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_errorLoadingManifest, (Object)bundleLocation);
            LogHelper.log((IStatus)new Status(2, Activator.ID, message, (Throwable)e));
        }
        Dictionary manifest = null;
        if (manifestStream != null) {
            try {
                Map manifestMap = ManifestElement.parseBundleManifest(manifestStream, null);
                manifest = new Hashtable(manifestMap);
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.exception_errorReadingManifest, (Object)bundleLocation, (Object)e.getMessage());
                LogHelper.log((IStatus)new Status(4, Activator.ID, message, (Throwable)e));
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
            catch (BundleException e) {
                try {
                    String message = NLS.bind((String)Messages.exception_errorReadingManifest, (Object)bundleLocation, (Object)e.getMessage());
                    LogHelper.log((IStatus)new Status(4, Activator.ID, message, (Throwable)e));
                }
                catch (Throwable throwable) {
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        } else {
            manifest = BundlesAction.convertPluginManifest(bundleLocation, true);
        }
        if (manifest == null) {
            return null;
        }
        if (((Dictionary)manifest).get("Bundle-SymbolicName") == null) {
            manifest = BundlesAction.convertPluginManifest(bundleLocation, true);
        }
        return manifest;
    }

    public BundlesAction(File[] locations) {
        this.locations = locations;
    }

    public BundlesAction(BundleDescription[] bundles) {
        this.bundles = bundles;
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        if (this.bundles == null && this.locations == null) {
            throw new IllegalStateException(Messages.exception_noBundlesOrLocations);
        }
        this.setPublisherInfo(publisherInfo);
        try {
            if (this.bundles == null) {
                this.bundles = this.getBundleDescriptions(this.expandLocations(this.locations), monitor);
            }
            this.generateBundleIUs(this.bundles, results, monitor);
            this.bundles = null;
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File base, File[] inclusions, IPublisherInfo info) {
        IArtifactRepository destination = info.getArtifactRepository();
        if (descriptor == null || destination == null) {
            return;
        }
        this.publishArtifact(descriptor, inclusions, null, info, this.createRootPrefixComputer(base));
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File jarFile, IPublisherInfo info) {
        File packFile;
        if (jarFile == null || info == null) {
            return;
        }
        IArtifactRepository destination = info.getArtifactRepository();
        if (destination == null || destination.contains(descriptor)) {
            return;
        }
        super.publishArtifact(descriptor, jarFile, info);
        boolean reuse = "true".equals(destination.getProperties().get("publishPackFilesAsSiblings"));
        if (reuse && (info.getArtifactOptions() & 2) > 0 && (packFile = new Path(jarFile.getAbsolutePath()).addFileExtension("pack.gz").toFile()).exists()) {
            IArtifactDescriptor ad200 = this.createPack200ArtifactDescriptor(descriptor.getArtifactKey(), packFile, descriptor.getProperty("artifact.size"));
            this.publishArtifact(ad200, packFile, info);
        }
    }

    private File[] expandLocations(File[] list) {
        ArrayList result = new ArrayList();
        this.expandLocations(list, result);
        return result.toArray(new File[result.size()]);
    }

    private void expandLocations(File[] list, ArrayList result) {
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            File location = list[i];
            if (location.isDirectory()) {
                if (new File(location, "META-INF/MANIFEST.MF").exists()) {
                    result.add(location);
                } else if (new File(location, PLUGIN_FILENAME_DESCRIPTOR).exists() || new File(location, FRAGMENT_FILENAME_DESCRIPTOR).exists()) {
                    result.add(location);
                } else {
                    this.expandLocations(location.listFiles(), result);
                }
            } else {
                result.add(location);
            }
            ++i;
        }
    }

    protected void generateBundleIUs(BundleDescription[] bundleDescriptions, IPublisherResult result, IProgressMonitor monitor) {
        int i = 0;
        while (i < bundleDescriptions.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            BundleDescription bd = bundleDescriptions[i];
            if (bd != null && bd.getSymbolicName() != null && bd.getVersion() != null) {
                IInstallableUnit bundleIU = this.queryForIU(result, bundleDescriptions[i].getSymbolicName(), Version.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion()));
                IArtifactKey key = BundlesAction.createBundleArtifactKey(bd.getSymbolicName(), bd.getVersion().toString());
                if (bundleIU == null) {
                    this.createAdviceFileAdvice(bundleDescriptions[i], this.info);
                    bundleIU = BundlesAction.createBundleIU(bd, key, this.info);
                }
                File location = new File(bd.getLocation());
                IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor(key, location);
                BundlesAction.processArtifactPropertiesAdvice(bundleIU, (ArtifactDescriptor)ad, this.info);
                File bundleLocation = new File(bd.getLocation());
                if (bundleLocation.isDirectory()) {
                    this.publishArtifact(ad, bundleLocation, bundleLocation.listFiles(), this.info);
                } else {
                    this.publishArtifact(ad, bundleLocation, this.info);
                }
                IInstallableUnit fragment = null;
                if (this.isFragment(bd)) {
                    String hostId = bd.getHost().getName();
                    org.eclipse.equinox.internal.provisional.p2.core.VersionRange hostVersionRange = org.eclipse.equinox.internal.provisional.p2.core.VersionRange.fromOSGiVersionRange((VersionRange)bd.getHost().getVersionRange());
                    IInstallableUnit[] hosts = this.queryForIUs(result, hostId, hostVersionRange);
                    int j = 0;
                    while (j < hosts.length) {
                        String fragmentId = BundlesAction.makeHostLocalizationFragmentId(bd.getSymbolicName());
                        fragment = this.queryForIU(result, fragmentId, Version.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion()));
                        if (fragment == null) {
                            String[] externalizedStrings = BundlesAction.getExternalizedStrings(hosts[j]);
                            fragment = this.createHostLocalizationFragment(bundleIU, bd, hostId, externalizedStrings);
                        }
                        ++j;
                    }
                }
                result.addIU(bundleIU, "root");
                if (fragment != null) {
                    result.addIU(fragment, "non_root");
                }
                MetadataFactory.InstallableUnitDescription[] others = BundlesAction.processAdditionalInstallableUnitsAdvice(bundleIU, this.info);
                int iuIndex = 0;
                while (others != null && iuIndex < others.length) {
                    result.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)others[iuIndex]), "root");
                    ++iuIndex;
                }
            }
            ++i;
        }
    }

    private void createAdviceFileAdvice(BundleDescription bundleDescription, IPublisherInfo info) {
        String location = bundleDescription.getLocation();
        if (location == null) {
            return;
        }
        AdviceFileAdvice advice = new AdviceFileAdvice(bundleDescription.getSymbolicName(), Version.fromOSGiVersion((org.osgi.framework.Version)bundleDescription.getVersion()), (IPath)new Path(location), AdviceFileAdvice.BUNDLE_ADVICE_FILE);
        if (advice.containsAdvice()) {
            info.addAdvice(advice);
        }
    }

    private static boolean isDir(BundleDescription bundle, IPublisherInfo info) {
        String shape;
        Collection advice;
        String string = bundle.getSymbolicName();
        Version version = Version.fromOSGiVersion((org.osgi.framework.Version)bundle.getVersion());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.IBundleShapeAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((advice = info.getAdvice(null, true, string, version, clazz)) != null && !advice.isEmpty() && (shape = ((IBundleShapeAdvice)advice.iterator().next()).getShape()) != null) {
            return shape.equals(DIR);
        }
        Map manifest = (Map)bundle.getUserObject();
        String format = (String)manifest.get(BUNDLE_SHAPE);
        return DIR.equals(format);
    }

    private boolean isFragment(BundleDescription bd) {
        return bd.getHost() != null;
    }

    protected BundleDescription[] getBundleDescriptions(File[] bundleLocations, IProgressMonitor monitor) {
        if (bundleLocations == null) {
            return new BundleDescription[0];
        }
        boolean addSimpleConfigurator = false;
        boolean scIn = false;
        int i = 0;
        while (i < bundleLocations.length) {
            if (!addSimpleConfigurator) {
                boolean bl = addSimpleConfigurator = bundleLocations[i].toString().indexOf(ORG_ECLIPSE_UPDATE_CONFIGURATOR) > 0;
            }
            if (!scIn) {
                boolean bl = scIn = bundleLocations[i].toString().indexOf(ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR) > 0;
                if (scIn) break;
            }
            ++i;
        }
        if (scIn) {
            addSimpleConfigurator = false;
        }
        BundleDescription[] result = new BundleDescription[bundleLocations.length + (addSimpleConfigurator ? 1 : 0)];
        int i2 = 0;
        while (i2 < bundleLocations.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            result[i2] = BundlesAction.createBundleDescription(bundleLocations[i2]);
            ++i2;
        }
        if (addSimpleConfigurator) {
            try {
                Bundle simpleConfigBundle = BundlesAction.getBundle(ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR);
                if (simpleConfigBundle == null) {
                    LogHelper.log((IStatus)new Status(1, Activator.ID, Messages.message_noSimpleconfigurator));
                } else {
                    File location = FileLocator.getBundleFile((Bundle)simpleConfigBundle);
                    result[result.length - 1] = BundlesAction.createBundleDescription(location);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static Bundle getBundle(String symbolicName) {
        PackageAdmin packageAdmin;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((packageAdmin = (PackageAdmin)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return null;
        }
        Bundle[] matchingBundles = packageAdmin.getBundles(symbolicName, null);
        if (matchingBundles == null) {
            return null;
        }
        int i = 0;
        while (i < matchingBundles.length) {
            if ((matchingBundles[i].getState() & 3) == 0) {
                return matchingBundles[i];
            }
            ++i;
        }
        return null;
    }
}

