/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class CompositeElementImageDescriptor
extends CompositeImageDescriptor {
    private final ImageData base;
    private ImageData kind;
    protected Point size;
    public static final int OFFSET_DECORATION = 6;
    static final int WIDTH_ICON = 16;
    private int offset = 0;

    public CompositeElementImageDescriptor(ImageDescriptor icon, ImageDescriptor overlayKind, boolean wide) {
        this.base = this.getImageData(icon);
        if (overlayKind != null) {
            this.kind = this.getImageData(overlayKind);
        }
        int width = 16;
        if (wide) {
            width += 6;
            this.offset = 6;
        }
        this.size = new Point(width, this.base.height);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.base, this.offset, 1);
        if (this.kind != null) {
            this.drawImage(this.kind, this.offset + 5, 6);
        }
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
        }
        return data;
    }

    protected Point getSize() {
        return new Point(this.size.x, this.size.y);
    }
}

