/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.core.api;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.mtj.internal.jmunit.core.api.AbstractTestWriter;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseWriter
extends AbstractTestWriter {
    private Hashtable<String, Integer> overrides = new Hashtable();
    private String test;

    public TestCaseWriter(IType iType, String string) throws JavaModelException {
        super(iType);
        this.test = string;
    }

    public void writeCode(IMethod[] iMethodArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, IProgressMonitor iProgressMonitor) throws JavaModelException {
        this.delimiter = this.type.getTypeRoot().findRecommendedLineSeparator();
        this.writeConstructor(iMethodArray.length, iProgressMonitor);
        List<String> list = this.writeTestMethods(iMethodArray, bl3, bl4, bl5, iProgressMonitor);
        if (bl) {
            this.writeSetup(iProgressMonitor);
        }
        if (bl2) {
            this.writeTearDown(iProgressMonitor);
        }
        this.writeTestMethod(list, iProgressMonitor);
    }

    private IMethod writeConstructor(int n, IProgressMonitor iProgressMonitor) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{"The default constructor. It just transmits the necessary informations to", "the superclass.", "", "@param totalOfTests the total of test methods present in the class.", "@param name this testcase's name."};
        this.writeMethodComment(stringBuffer, stringArray, this.delimiter);
        String string = NLS.bind((String)"public {0}()", (Object)this.type.getElementName());
        String[] stringArray2 = new String[]{NLS.bind((String)"super({0}, \"{1}\");", (Object[])new String[]{String.valueOf(n), this.test})};
        this.writeMethodDeclaration(stringBuffer, string, stringArray2, this.delimiter);
        return this.type.createMethod(stringBuffer.toString(), null, false, iProgressMonitor);
    }

    private IMethod writeSetup(IProgressMonitor iProgressMonitor) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{"A empty method used by the framework to initialize the tests. If there's", "5 test methods, the setUp is called 5 times, one for each method. The", "setUp occurs before the method's execution, so the developer can use it", "to any necessary initialization. It's necessary to override it, however.", "", "@throws Throwable anything that the initialization can throw."};
        this.writeMethodComment(stringBuffer, stringArray, this.delimiter);
        String string = "public void setUp() throws Throwable";
        this.writeMethodDeclaration(stringBuffer, string, null, this.delimiter);
        return this.type.createMethod(stringBuffer.toString(), null, false, iProgressMonitor);
    }

    private IMethod writeTearDown(IProgressMonitor iProgressMonitor) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{"A empty mehod used by the framework to release resources used by the", "tests. If there's 5 test methods, the tearDown is called 5 times, one for", "each method. The tearDown occurs after the method's execution, so the", "developer can use it to close something used in the test, like a", "nputStream or the RMS. It's necessary to override it, however."};
        this.writeMethodComment(stringBuffer, stringArray, this.delimiter);
        String string = "public void tearDown()";
        this.writeMethodDeclaration(stringBuffer, string, null, this.delimiter);
        return this.type.createMethod(stringBuffer.toString(), null, false, iProgressMonitor);
    }

    private IMethod writeTestMethod(List<String> list, IProgressMonitor iProgressMonitor) throws JavaModelException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{"This method stores all the test methods invocation. The developer must", "implement this method with a switch-case. The cases must start from 0 and", "increase in steps of one until the number declared as the total of tests", "in the constructor, exclusive. For example, if the total is 3, the cases", "must be 0, 1 and 2. In each case, there must be a test method invocation.", "", "@param testNumber the test to be executed.", "@throws Throwable anything that the executed test can throw."};
        this.writeMethodComment(stringBuffer, stringArray, this.delimiter);
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        linkedList.add("switch(testNumber) {");
        for (String string2 : list) {
            linkedList.add(NLS.bind((String)"case {0} :", (Object)String.valueOf(n++)));
            linkedList.add(NLS.bind((String)"{0}();", (Object)string2));
            linkedList.add("break;");
        }
        linkedList.add("}");
        string2 = "public void test(int testNumber) throws Throwable";
        this.writeMethodDeclaration(stringBuffer, string2, linkedList.toArray(new String[linkedList.size()]), this.delimiter);
        return this.type.createMethod(stringBuffer.toString(), null, false, iProgressMonitor);
    }

    private List<String> writeTestMethods(IMethod[] iMethodArray, boolean bl, boolean bl2, boolean bl3, IProgressMonitor iProgressMonitor) throws JavaModelException {
        LinkedList<String> linkedList = new LinkedList<String>();
        IMethod[] iMethodArray2 = iMethodArray;
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod iMethod = iMethodArray2[n2];
            String string = this.resolveMethodName(iMethod.getElementName());
            this.writeTestMethod(iMethod, string, bl, bl2, bl3, iProgressMonitor);
            linkedList.add(string);
            ++n2;
        }
        return linkedList;
    }

    private IMethod writeTestMethod(IMethod iMethod, String string, boolean bl, boolean bl2, boolean bl3, IProgressMonitor iProgressMonitor) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            this.writeMethodComment(stringBuffer, iMethod);
        }
        String string2 = NLS.bind((String)"public {0} void {1}()", (Object[])new String[]{bl3 ? "final" : "", string});
        String[] stringArray = null;
        stringArray = bl2 ? new String[]{"fail(\"Not Yet Implemented.\"); // TODO"} : new String[]{"fail(\"Not Yet Implemented.\");"};
        this.writeMethodDeclaration(stringBuffer, string2, stringArray, this.delimiter);
        return this.type.createMethod(stringBuffer.toString(), null, false, iProgressMonitor);
    }

    private void writeMethodComment(StringBuffer stringBuffer, IMethod iMethod) throws JavaModelException {
        String[] stringArray = new String[]{NLS.bind((String)"Test for method: {0}.", (Object)Signature.toString((String)iMethod.getSignature(), (String)iMethod.getElementName(), (String[])iMethod.getParameterNames(), (boolean)true, (boolean)true)), "", NLS.bind((String)"@see {0}#{1}", (Object[])new String[]{iMethod.getDeclaringType().getFullyQualifiedName(), Signature.toString((String)iMethod.getSignature(), (String)iMethod.getElementName(), (String[])iMethod.getParameterNames(), (boolean)true, (boolean)false)})};
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].replace("/", ".");
            ++n;
        }
        this.writeMethodComment(stringBuffer, stringArray, this.delimiter);
    }

    private String resolveMethodName(String string) {
        boolean bl = false;
        int n = 1;
        for (String string2 : this.overrides.keySet()) {
            if (!string2.equals(string)) continue;
            this.overrides.put(string2, n += this.overrides.get(string2).intValue());
            bl = true;
        }
        if (!bl) {
            this.overrides.put(string, n);
        }
        return NLS.bind((String)"{0}{1}Test", (Object[])new String[]{string, String.valueOf(n)});
    }
}

