/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.commands;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.wikitext.core.parser.util.MarkupToDocbook;
import org.eclipse.mylyn.wikitext.ui.commands.AbstractMarkupResourceHandler;
import org.eclipse.mylyn.wikitext.ui.commands.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConvertMarkupToDocbook
extends AbstractMarkupResourceHandler {
    protected void handleFile(IFile file, String name) {
        final IFile newFile = file.getParent().getFile((IPath)new Path(String.valueOf(name) + ".xml"));
        if (newFile.exists() && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConvertMarkupToDocbook_overwrite, (String)NLS.bind((String)Messages.ConvertMarkupToDocbook_fileExistsOverwrite, (Object[])new Object[]{newFile.getFullPath()}))) {
            return;
        }
        MarkupToDocbook markupToDocbook = new MarkupToDocbook();
        markupToDocbook.setMarkupLanguage(this.markupLanguage);
        markupToDocbook.setBookTitle(name);
        try {
            StringWriter w = new StringWriter();
            InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(file.getContents()), file.getCharset());
            try {
                int i;
                while ((i = ((Reader)r).read()) != -1) {
                    w.write((char)i);
                }
            }
            finally {
                ((Reader)r).close();
            }
            final String docbook = markupToDocbook.parse(w.toString());
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if (newFile.exists()) {
                            newFile.setContents((InputStream)new ByteArrayInputStream(docbook.getBytes("utf-8")), false, true, monitor);
                        } else {
                            newFile.create((InputStream)new ByteArrayInputStream(docbook.getBytes("utf-8")), false, monitor);
                        }
                        newFile.setCharset("utf-8", monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            StringWriter message = new StringWriter();
            PrintWriter out = new PrintWriter(message);
            out.println(String.valueOf(Messages.ConvertMarkupToDocbook_cannotConvert) + e.getMessage());
            out.println(Messages.ConvertMarkupToDocbook_detailsFollow);
            e.printStackTrace(out);
            out.close();
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConvertMarkupToDocbook_cannotCompleteOperation, (String)message.toString());
        }
    }
}

