/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.adapters.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDSchemaAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IActionProvider;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObjectListener;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ITreeElement;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDElementAction;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDSchemaAdapter
extends XSDBaseAdapter
implements IActionProvider,
IModel,
IADTObjectListener {
    protected List types = null;
    protected List children;
    protected List allChildren;
    protected CategoryAdapter fDirectivesCategory;
    protected CategoryAdapter fElementsCategory;
    protected CategoryAdapter fAttributesCategory;
    protected CategoryAdapter fTypesCategory;
    protected CategoryAdapter fGroupsCategory;

    protected void createCategoryAdapters(XSDSchema xsdSchema) {
        List directivesList = this.getDirectives(xsdSchema);
        List elementsList = this.getGlobalElements(xsdSchema);
        List attributesList = this.getAttributeList(xsdSchema);
        List groups = this.getGroups(xsdSchema);
        List types = this.getComplexTypes(xsdSchema);
        types.addAll(this.getSimpleTypes(xsdSchema));
        this.fDirectivesCategory = new CategoryAdapter(Messages._UI_GRAPH_DIRECTIVES, XSDEditorPlugin.getDefault().getIconImage("obj16/directivesheader"), directivesList, xsdSchema, 6);
        this.fDirectivesCategory.setAllChildren(directivesList);
        this.registerListener(this.fDirectivesCategory);
        this.fElementsCategory = new CategoryAdapter(Messages._UI_GRAPH_ELEMENTS, XSDEditorPlugin.getDefault().getIconImage("obj16/elementsheader"), elementsList, xsdSchema, 2);
        this.fElementsCategory.setAllChildren(this.getGlobalElements(xsdSchema, true));
        this.registerListener(this.fElementsCategory);
        this.fAttributesCategory = new CategoryAdapter(Messages._UI_GRAPH_ATTRIBUTES, XSDEditorPlugin.getDefault().getIconImage("obj16/attributesheader"), attributesList, xsdSchema, 1);
        this.fAttributesCategory.setAllChildren(this.getAttributeList(xsdSchema, true));
        this.registerListener(this.fAttributesCategory);
        this.fTypesCategory = new CategoryAdapter(Messages._UI_GRAPH_TYPES, XSDEditorPlugin.getDefault().getIconImage("obj16/typesheader"), types, xsdSchema, 3);
        this.fTypesCategory.setAllChildren(this.getTypes(xsdSchema, true));
        this.registerListener(this.fTypesCategory);
        this.fGroupsCategory = new CategoryAdapter(Messages._UI_GRAPH_GROUPS, XSDEditorPlugin.getDefault().getIconImage("obj16/groupsheader"), groups, xsdSchema, 5);
        this.fGroupsCategory.setAllChildren(this.getGroups(xsdSchema, true));
        this.registerListener(this.fGroupsCategory);
    }

    public List getTypes() {
        if (this.types == null) {
            this.types = new ArrayList();
            XSDSchema schema = (XSDSchema)this.target;
            ArrayList<XSDConcreteComponent> concreteComponentList = new ArrayList<XSDConcreteComponent>();
            Iterator i = schema.getContents().iterator();
            while (i.hasNext()) {
                XSDConcreteComponent component = (XSDConcreteComponent)i.next();
                if (!(component instanceof XSDTypeDefinition)) continue;
                concreteComponentList.add(component);
            }
            this.populateAdapterList(concreteComponentList, this.types);
        }
        return this.types;
    }

    protected boolean isSameNamespace(String ns1, String ns2) {
        if (ns1 == null) {
            ns1 = "";
        }
        if (ns2 == null) {
            ns2 = "";
        }
        return ns1.equals(ns2);
    }

    public ITreeElement[] getChildren() {
        XSDSchema xsdSchema = (XSDSchema)this.getTarget();
        this.children = new ArrayList();
        if (this.fDirectivesCategory != null) {
            List directivesList = this.getDirectives(xsdSchema);
            List elementsList = this.getGlobalElements(xsdSchema);
            List attributesList = this.getAttributeList(xsdSchema);
            List groups = this.getGroups(xsdSchema);
            List types = this.getComplexTypes(xsdSchema);
            types.addAll(this.getSimpleTypes(xsdSchema));
            this.fDirectivesCategory.setChildren(directivesList);
            this.fDirectivesCategory.setAllChildren(directivesList);
            this.fElementsCategory.setChildren(elementsList);
            this.fElementsCategory.setAllChildren(this.getGlobalElements(xsdSchema, true));
            this.fAttributesCategory.setChildren(attributesList);
            this.fAttributesCategory.setAllChildren(this.getAttributeList(xsdSchema, true));
            this.fTypesCategory.setChildren(types);
            this.fTypesCategory.setAllChildren(this.getTypes(xsdSchema, true));
            this.fGroupsCategory.setChildren(groups);
            this.fGroupsCategory.setAllChildren(this.getGroups(xsdSchema, true));
        } else {
            this.createCategoryAdapters(xsdSchema);
        }
        this.children.add(this.fDirectivesCategory);
        this.children.add(this.fElementsCategory);
        this.children.add(this.fAttributesCategory);
        this.children.add(this.fTypesCategory);
        this.children.add(this.fGroupsCategory);
        return this.children.toArray(new ITreeElement[0]);
    }

    public void notifyChanged(Notification msg) {
        class CategoryNotification
        extends NotificationImpl {
            protected Object category;
            final /* synthetic */ XSDSchemaAdapter this$0;
            private final /* synthetic */ Notification val$msg;

            public CategoryNotification(XSDSchemaAdapter xSDSchemaAdapter, Object category, Notification notification) {
                this.this$0 = xSDSchemaAdapter;
                this.val$msg = notification;
                super(notification.getEventType(), notification.getOldValue(), notification.getNewValue(), notification.getPosition());
                this.category = category;
            }

            public Object getNotifier() {
                return this.category;
            }

            public Object getFeature() {
                return this.val$msg.getFeature();
            }
        }
        XSDSchema xsdSchema;
        CategoryAdapter adapter;
        if (this.children == null) {
            this.getChildren();
        }
        Object newValue = msg.getNewValue();
        Object oldValue = msg.getOldValue();
        boolean updateDirectivesCategory = false;
        if (oldValue instanceof XSDSchemaDirective) {
            updateDirectivesCategory = true;
        } else if (oldValue instanceof Collection) {
            Iterator iterator = ((Collection)oldValue).iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof XSDSchemaDirective)) continue;
                updateDirectivesCategory = true;
                break;
            }
        }
        if (newValue instanceof XSDInclude || newValue instanceof XSDImport || newValue instanceof XSDRedefine || msg.getFeature() == XSDPackage.eINSTANCE.getXSDSchema_Contents() && updateDirectivesCategory || msg.getFeature() == XSDPackage.eINSTANCE.getXSDSchema_IncorporatedVersions()) {
            adapter = this.getCategory(6);
            Assert.isTrue((adapter != null ? 1 : 0) != 0);
            xsdSchema = adapter.getXSDSchema();
            adapter.setChildren(this.getDirectives(xsdSchema));
            adapter.setAllChildren(this.getDirectives(xsdSchema));
            this.notifyListeners((Object)new CategoryNotification(this, adapter, msg), adapter.getText());
            return;
        }
        if (msg.getFeature() == XSDPackage.eINSTANCE.getXSDSchema_ElementDeclarations()) {
            adapter = this.getCategory(2);
            Assert.isTrue((adapter != null ? 1 : 0) != 0);
            xsdSchema = adapter.getXSDSchema();
            adapter.setChildren(this.getGlobalElements(xsdSchema));
            adapter.setAllChildren(this.getGlobalElements(xsdSchema, true));
            this.notifyListeners((Object)new CategoryNotification(this, adapter, msg), adapter.getText());
            return;
        }
        if (msg.getFeature() == XSDPackage.eINSTANCE.getXSDSchema_AttributeDeclarations() || msg.getFeature() == XSDPackage.eINSTANCE.getXSDSchema_AttributeGroupDefinitions()) {
            adapter = this.getCategory(1);
            Assert.isTrue((adapter != null ? 1 : 0) != 0);
            xsdSchema = adapter.getXSDSchema();
            adapter.setChildren(this.getAttributeList(xsdSchema));
            adapter.setAllChildren(this.getAttributeList(xsdSchema, true));
            this.notifyListeners((Object)new CategoryNotification(this, adapter, msg), adapter.getText());
            return;
        }
        if (msg.getFeature() == XSDPackage.eINSTANCE.getXSDSchema_TypeDefinitions()) {
            adapter = this.getCategory(3);
            Assert.isTrue((adapter != null ? 1 : 0) != 0);
            xsdSchema = adapter.getXSDSchema();
            List types = this.getComplexTypes(xsdSchema);
            types.addAll(this.getSimpleTypes(xsdSchema));
            adapter.setChildren(types);
            adapter.setAllChildren(this.getTypes(xsdSchema, true));
            this.notifyListeners((Object)new CategoryNotification(this, adapter, msg), adapter.getText());
            return;
        }
        if (msg.getFeature() == XSDPackage.eINSTANCE.getXSDSchema_ModelGroupDefinitions()) {
            adapter = this.getCategory(5);
            Assert.isTrue((adapter != null ? 1 : 0) != 0);
            xsdSchema = adapter.getXSDSchema();
            adapter.setChildren(this.getGroups(xsdSchema));
            adapter.setAllChildren(this.getGroups(xsdSchema, true));
            this.notifyListeners((Object)new CategoryNotification(this, adapter, msg), adapter.getText());
            return;
        }
        if (msg.getFeature() == XSDPackage.eINSTANCE.getXSDSchema_Annotations()) {
            return;
        }
        if (msg.getFeature() == XSDPackage.eINSTANCE.getXSDSchema_SchemaLocation()) {
            this.notifyListeners(msg, null);
            return;
        }
        this.types = null;
        this.getTypes();
        super.notifyChanged(msg);
    }

    public void updateCategories() {
        this.getChildren();
    }

    public CategoryAdapter getCategory(int category) {
        if (this.children == null) {
            this.updateCategories();
        }
        int length = this.children.size();
        CategoryAdapter adapter = null;
        int i = 0;
        while (i < length) {
            adapter = (CategoryAdapter)this.children.get(i);
            if (adapter.getGroupType() == category) break;
            ++i;
        }
        return adapter;
    }

    public List getDirectives(XSDSchema schema) {
        ArrayList list = new ArrayList();
        Iterator i = schema.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof XSDSchemaDirective)) continue;
            list.add(o);
        }
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(list, adapterList);
        return adapterList;
    }

    public List getGlobalElements(XSDSchema schema, boolean showFromIncludes) {
        EList elements = schema.getElementDeclarations();
        ArrayList<XSDElementDeclaration> list = new ArrayList<XSDElementDeclaration>();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            XSDElementDeclaration elem = (XSDElementDeclaration)i.next();
            if (!this.isSameNamespace(elem.getTargetNamespace(), schema.getTargetNamespace()) || elem.getRootContainer() != schema && !showFromIncludes) continue;
            list.add(elem);
        }
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(list, adapterList);
        return adapterList;
    }

    public List getGlobalElements(XSDSchema schema) {
        return this.getGlobalElements(schema, false);
    }

    public List getComplexTypes(XSDSchema schema, boolean showFromIncludes) {
        EList allTypes = schema.getTypeDefinitions();
        ArrayList<XSDComplexTypeDefinition> list = new ArrayList<XSDComplexTypeDefinition>();
        Iterator i = allTypes.iterator();
        while (i.hasNext()) {
            XSDComplexTypeDefinition ct;
            XSDTypeDefinition td = (XSDTypeDefinition)i.next();
            if (!(td instanceof XSDComplexTypeDefinition) || !this.isSameNamespace((ct = (XSDComplexTypeDefinition)td).getTargetNamespace(), schema.getTargetNamespace()) || ct.getRootContainer() != schema && !showFromIncludes) continue;
            list.add(ct);
        }
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(list, adapterList);
        return adapterList;
    }

    public List getComplexTypes(XSDSchema schema) {
        return this.getComplexTypes(schema, false);
    }

    public List getTypes(XSDSchema schema, boolean showFromIncludes) {
        List list = this.getComplexTypes(schema, showFromIncludes);
        list.addAll(this.getSimpleTypes(schema, showFromIncludes));
        return list;
    }

    public List getAttributeGroupList(XSDSchema xsdSchema, boolean showFromIncludes) {
        ArrayList<XSDAttributeGroupDefinition> attributeGroupList = new ArrayList<XSDAttributeGroupDefinition>();
        Iterator i = xsdSchema.getAttributeGroupDefinitions().iterator();
        while (i.hasNext()) {
            XSDAttributeGroupDefinition attrGroup = (XSDAttributeGroupDefinition)i.next();
            if (!this.isSameNamespace(attrGroup.getTargetNamespace(), xsdSchema.getTargetNamespace()) || attrGroup.getRootContainer() != xsdSchema && !showFromIncludes) continue;
            attributeGroupList.add(attrGroup);
        }
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(attributeGroupList, adapterList);
        return adapterList;
    }

    public List getAttributeGroupList(XSDSchema xsdSchema) {
        return this.getAttributeGroupList(xsdSchema, false);
    }

    public List getAttributeList(XSDSchema xsdSchema, boolean showFromIncludes) {
        ArrayList<XSDAttributeDeclaration> attributesList = new ArrayList<XSDAttributeDeclaration>();
        Iterator iter = xsdSchema.getAttributeDeclarations().iterator();
        while (iter.hasNext()) {
            XSDAttributeDeclaration attr;
            Object o = iter.next();
            if (!(o instanceof XSDAttributeDeclaration) || (attr = (XSDAttributeDeclaration)o) == null) continue;
            if (attr.getTargetNamespace() != null) {
                if (attr.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema-instance") || !this.isSameNamespace(attr.getTargetNamespace(), xsdSchema.getTargetNamespace()) || attr.getRootContainer() != xsdSchema && !showFromIncludes) continue;
                attributesList.add(attr);
                continue;
            }
            if (!this.isSameNamespace(attr.getTargetNamespace(), xsdSchema.getTargetNamespace()) || attr.getRootContainer() != xsdSchema && !showFromIncludes) continue;
            attributesList.add(attr);
        }
        attributesList.addAll(this.getAttributeGroupList(xsdSchema, showFromIncludes));
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(attributesList, adapterList);
        return adapterList;
    }

    public List getAttributeList(XSDSchema xsdSchema) {
        return this.getAttributeList(xsdSchema, false);
    }

    public List getSimpleTypes(XSDSchema schema, boolean showFromIncludes) {
        EList allTypes = schema.getTypeDefinitions();
        ArrayList<XSDSimpleTypeDefinition> list = new ArrayList<XSDSimpleTypeDefinition>();
        Iterator i = allTypes.iterator();
        while (i.hasNext()) {
            XSDSimpleTypeDefinition st;
            XSDTypeDefinition td = (XSDTypeDefinition)i.next();
            if (!(td instanceof XSDSimpleTypeDefinition) || !this.isSameNamespace((st = (XSDSimpleTypeDefinition)td).getTargetNamespace(), schema.getTargetNamespace()) || st.getRootContainer() != schema && !showFromIncludes) continue;
            list.add(st);
        }
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(list, adapterList);
        return adapterList;
    }

    public List getSimpleTypes(XSDSchema schema) {
        return this.getSimpleTypes(schema, false);
    }

    public List getGroups(XSDSchema schema, boolean showFromIncludes) {
        EList groups = schema.getModelGroupDefinitions();
        ArrayList<XSDModelGroupDefinition> list = new ArrayList<XSDModelGroupDefinition>();
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            XSDModelGroupDefinition group = (XSDModelGroupDefinition)i.next();
            if (!this.isSameNamespace(group.getTargetNamespace(), schema.getTargetNamespace()) || group.getRootContainer() != schema && !showFromIncludes) continue;
            list.add(group);
        }
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(list, adapterList);
        return adapterList;
    }

    public List getGroups(XSDSchema schema) {
        return this.getGroups(schema, false);
    }

    public String[] getActions(Object object) {
        ArrayList<String> actionIDs = new ArrayList<String>();
        actionIDs.add(AddXSDElementAction.ID);
        actionIDs.add("org.eclipse.wst.xsd.ui.internal.editor.AddXSDComplexTypeDefinitionAction");
        actionIDs.add("org.eclipse.jface.action.Separator");
        actionIDs.add("org.eclipse.wst.xsd.ui.internal.adt.actions.ShowPropertiesViewAction");
        return actionIDs.toArray(new String[0]);
    }

    public void propertyChanged(Object object, String property) {
        this.notifyListeners(object, property);
    }

    public Image getImage() {
        return XSDEditorPlugin.getXSDImage("icons/XSDFile.gif");
    }
}

