/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.site.SiteFeatureAdapter;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FeatureDetailsSection
extends PDESection
implements IFormPart,
IPartSelectionListener {
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_URL = "url";
    private ISiteFeature fCurrentSiteFeature;
    private Button fPatchCheckBox;
    private FormEntry fUrlText;

    public FeatureDetailsSection(PDEFormPage page, Composite parent) {
        this(page, parent, PDEUIMessages.FeatureDetailsSection_title, PDEUIMessages.FeatureDetailsSection_desc, 0);
    }

    public FeatureDetailsSection(PDEFormPage page, Composite parent, String title, String desc, int toggleStyle) {
        super(page, parent, 0x80 | toggleStyle);
        this.getSection().setText(title);
        this.getSection().setDescription(desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    private void applyIsPatch(boolean patch) throws CoreException {
        if (this.fCurrentSiteFeature == null) {
            return;
        }
        this.fCurrentSiteFeature.setIsPatch(patch);
    }

    private void applyValue(String property, String value) throws CoreException {
        if (this.fCurrentSiteFeature == null) {
            return;
        }
        if (property.equals(PROPERTY_URL)) {
            this.fCurrentSiteFeature.setURL(value);
        } else if (property.equals(PROPERTY_TYPE)) {
            this.fCurrentSiteFeature.setType(value);
        }
    }

    public void cancelEdit() {
        this.fUrlText.cancelEdit();
        super.cancelEdit();
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private void clearField(String property) {
        if (property.equals(PROPERTY_URL)) {
            this.fUrlText.setValue(null, true);
        }
    }

    private void clearFields() {
        this.fUrlText.setValue(null, true);
        this.fPatchCheckBox.setSelection(false);
    }

    public void commit(boolean onSave) {
        try {
            this.applyIsPatch(this.fPatchCheckBox.getSelection());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        this.fUrlText = new FormEntry(container, toolkit, PDEUIMessages.FeatureDetailsSection_url, null, false);
        this.fUrlText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    if (text.getValue().length() <= 0) {
                        FeatureDetailsSection.this.setValue(FeatureDetailsSection.PROPERTY_URL);
                        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.FeatureDetailsSection_requiredURL_title, (String)PDEUIMessages.FeatureDetailsSection_requiredURL);
                    } else {
                        FeatureDetailsSection.this.applyValue(FeatureDetailsSection.PROPERTY_URL, text.getValue());
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.limitTextWidth(this.fUrlText);
        this.fUrlText.getText().setEnabled(false);
        this.createPatchButton(toolkit, container);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
    }

    private void createPatchButton(FormToolkit toolkit, Composite container) {
        this.fPatchCheckBox = toolkit.createButton(container, PDEUIMessages.FeatureDetailsSection_patch, 32);
        this.fPatchCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    FeatureDetailsSection.this.applyIsPatch(FeatureDetailsSection.this.fPatchCheckBox.getSelection());
                }
                catch (CoreException ce) {
                    PDEPlugin.logException(ce);
                }
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fPatchCheckBox.setLayoutData((Object)gd);
        this.fPatchCheckBox.setEnabled(this.isEditable());
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void limitTextWidth(FormEntry entry) {
        GridData gd = (GridData)entry.getText().getLayoutData();
        gd.widthHint = 30;
    }

    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    public void refresh() {
        if (this.fCurrentSiteFeature == null) {
            this.clearFields();
            super.refresh();
            return;
        }
        this.setValue(PROPERTY_URL);
        this.setValue(PROPERTY_TYPE);
        this.fPatchCheckBox.setSelection(this.fCurrentSiteFeature.isPatch());
        super.refresh();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object o;
        this.fCurrentSiteFeature = selection instanceof IStructuredSelection && !selection.isEmpty() ? ((o = ((IStructuredSelection)selection).getFirstElement()) instanceof SiteFeatureAdapter ? ((SiteFeatureAdapter)o).feature : null) : null;
        this.refresh();
    }

    public void setFocus() {
        if (this.fUrlText != null) {
            this.fUrlText.getText().setFocus();
        }
    }

    private void setValue(String property) {
        if (this.fCurrentSiteFeature == null) {
            this.clearField(property);
        } else if (property.equals(PROPERTY_URL)) {
            this.fUrlText.setValue(this.fCurrentSiteFeature.getURL(), true);
        }
    }
}

