/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.EditDirectoryContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class PreviewContainerPage
extends WizardPage {
    private ITargetDefinition fTarget;
    private EditDirectoryContainerPage fPage1;
    protected TableViewer fPreviewTable;
    protected Object fInput;

    protected PreviewContainerPage(ITargetDefinition definition, EditDirectoryContainerPage page1) {
        super("ContainerPreviewPage");
        this.setTitle(Messages.PreviewContainerPage_1);
        this.setMessage(Messages.PreviewContainerPage_2);
        this.fTarget = definition;
        this.fPage1 = page1;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1808);
        SWTFactory.createLabel(composite, Messages.PreviewContainerPage_3, 1);
        this.fPreviewTable = new TableViewer(composite);
        this.fPreviewTable.setLabelProvider((IBaseLabelProvider)new StyledBundleLabelProvider(true, false));
        this.fPreviewTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fPreviewTable.getControl().setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.location_preview_wizard");
    }

    protected void setInput(final IBundleContainer container) {
        if (container == null) {
            this.fInput = null;
            this.fPreviewTable.setInput(null);
            return;
        }
        if (container.isResolved()) {
            this.fInput = container.getAllBundles();
            this.fPreviewTable.setInput(this.fInput);
            return;
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IStatus result = container.resolve(PreviewContainerPage.this.fTarget, monitor);
                    PreviewContainerPage.this.fInput = monitor.isCanceled() ? new Object[]{Messages.PreviewContainerPage_0} : (!result.isOK() && !result.isMultiStatus() ? new Object[]{result} : container.getAllBundles());
                }
            });
            this.fPreviewTable.setInput(this.fInput);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
            this.setErrorMessage(e.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setInput(this.fPage1.getBundleContainer());
        }
    }
}

