/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.ui.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.ui.wizards.feature.CreateFeatureProjectOperation;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.swt.widgets.Shell;

public class CreateFeatureProjectFromLaunchOperation
extends CreateFeatureProjectOperation {
    private ILaunchConfiguration fLaunchConfig;

    public CreateFeatureProjectFromLaunchOperation(IProject project, IPath location, FeatureData featureData, ILaunchConfiguration launchConfig, Shell shell) {
        super(project, location, featureData, null, shell);
        this.fLaunchConfig = launchConfig;
    }

    protected void configureFeature(IFeature feature, WorkspaceFeatureModel model) throws CoreException {
        this.fPlugins = this.getPlugins();
        super.configureFeature(feature, model);
    }

    private IPluginBase[] getPlugins() {
        IPluginModelBase[] models = null;
        try {
            ILaunchConfigurationType type = this.fLaunchConfig.getType();
            String id = type.getIdentifier();
            if (id.equals("org.eclipse.pde.ui.RuntimeWorkbench")) {
                models = BundleLauncherHelper.getMergedBundles(this.fLaunchConfig, false);
            } else if (id.equals("org.eclipse.pde.ui.EquinoxLauncher")) {
                models = BundleLauncherHelper.getMergedBundles(this.fLaunchConfig, true);
            }
        }
        catch (CoreException coreException) {}
        IPluginBase[] result = new IPluginBase[models == null ? 0 : models.length];
        int i = 0;
        while (i < result.length) {
            result[i] = models[i].getPluginBase(true);
            ++i;
        }
        return result;
    }
}

