/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.CssUtil;
import org.eclipse.help.internal.webapp.data.EnabledTopicUtils;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.xhtml.DynamicXHTMLProcessor;

public class PrintData
extends RequestData {
    private static final Pattern PATTERN_HEADING = Pattern.compile("<body.*?>[\\s]*?([\\w])", 42);
    private static final Pattern PATTERN_LINK = Pattern.compile("(src|href)=\"(.*?\")", 42);
    private static final Pattern PATTERN_END_HEAD = Pattern.compile("</head.*?>", 42);

    public PrintData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
    }

    public String getTitle() {
        return this.getTopic().getLabel();
    }

    public String getTocHref() {
        return this.getToc().getHref();
    }

    public String getTopicHref() {
        return this.getTopic().getHref();
    }

    public void generateToc(Writer out) throws IOException {
        out.write("<div id=\"toc\">");
        out.write("<h1>");
        out.write(this.getTitle());
        out.write("</h1>");
        out.write("<h2>");
        out.write(ServletResources.getString("TocHeading", this.request));
        out.write("</h2>");
        out.write("<div id=\"toc_content\">");
        ITopic topic = this.getTopic();
        ITopic[] subtopics = EnabledTopicUtils.getEnabled(topic.getSubtopics());
        int i = 0;
        while (i < subtopics.length) {
            this.generateToc(subtopics[i], String.valueOf(i + 1), out);
            ++i;
        }
        out.write("</div>");
        out.write("</div>");
    }

    private void generateToc(ITopic topic, String sectionId, Writer out) throws IOException {
        out.write("<div class=\"toc_" + (sectionId.length() > 2 ? "sub" : "") + "entry\">");
        out.write(String.valueOf(sectionId) + ". " + "<a href=\"#section" + sectionId + "\">" + topic.getLabel() + "</a>");
        ITopic[] subtopics = EnabledTopicUtils.getEnabled(topic.getSubtopics());
        int i = 0;
        while (i < subtopics.length) {
            String subsectionId = String.valueOf(sectionId) + "." + (i + 1);
            this.generateToc(subtopics[i], subsectionId, out);
            ++i;
        }
        out.write("</div>");
    }

    public void generateContent(Writer out) throws IOException {
        this.generateContent(this.getTopic(), null, out, new HashSet());
    }

    private void generateContent(ITopic topic, String sectionId, Writer out, Set generated) throws IOException {
        String href = topic.getHref();
        if (href != null) {
            href = PrintData.removeAnchor(href);
            String pathHref = href.substring(0, href.lastIndexOf(47) + 1);
            String baseHref = "../topic" + pathHref;
            if (!generated.contains(href)) {
                generated.add(href);
                String content = this.getContent(href, this.locale);
                if (sectionId != null) {
                    content = this.injectHeading(content, sectionId);
                }
                content = this.normalizeHrefs(content, baseHref);
                content = this.injectCss(content);
                out.write(content);
            }
        }
        ITopic[] subtopics = EnabledTopicUtils.getEnabled(topic.getSubtopics());
        int i = 0;
        while (i < subtopics.length) {
            String subsectionId = String.valueOf(sectionId != null ? String.valueOf(sectionId) + "." : "") + (i + 1);
            this.generateContent(subtopics[i], subsectionId, out, generated);
            ++i;
        }
    }

    private String injectHeading(String content, String sectionId) {
        Matcher matcher = PATTERN_HEADING.matcher(content);
        if (matcher.find()) {
            String heading = "<a id=\"section" + sectionId + "\">" + sectionId + ". </a>";
            return String.valueOf(content.substring(0, matcher.start(1))) + heading + content.substring(matcher.start(1));
        }
        return content;
    }

    private String injectCss(String content) {
        Matcher matcher = PATTERN_END_HEAD.matcher(content);
        if (matcher.find()) {
            String css = this.getCssIncludes();
            return String.valueOf(content.substring(0, matcher.start(0))) + css + content.substring(matcher.start(0));
        }
        return content;
    }

    private String normalizeHrefs(String content, String baseHref) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = PATTERN_LINK.matcher(content);
        int prev = 0;
        while (matcher.find()) {
            buf.append(content.substring(prev, matcher.start(2)));
            buf.append(baseHref);
            buf.append(matcher.group(2));
            prev = matcher.end();
        }
        buf.append(content.substring(prev));
        return buf.toString();
    }

    private String getContent(String href, String locale) {
        StringBuffer buf;
        block14: {
            InputStream in = HelpSystem.getHelpContent((String)href, (String)locale);
            buf = new StringBuffer();
            if (in != null) {
                try {
                    try {
                        int num;
                        String charset = HTMLDocParser.getCharsetFromHTML((InputStream)in);
                        if (charset == null) {
                            charset = "UTF-8";
                        }
                        InputStream rawInput = HelpSystem.getHelpContent((String)href, (String)locale);
                        boolean filter = BaseHelpSystem.getMode() != 1;
                        in = DynamicXHTMLProcessor.process((String)href, (InputStream)rawInput, (String)locale, (boolean)filter);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
                        char[] cbuf = new char[4096];
                        while ((num = reader.read(cbuf)) > 0) {
                            buf.append(cbuf, 0, num);
                        }
                    }
                    catch (Exception e) {
                        String msg = "Error retrieving print preview content for " + href;
                        HelpWebappPlugin.logError(msg, e);
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return buf.toString();
    }

    private IToc getToc() {
        String tocParam = this.request.getParameter("toc");
        if (tocParam != null && tocParam.length() > 0) {
            return HelpPlugin.getTocManager().getToc(tocParam, this.getLocale());
        }
        String topicParam = this.request.getParameter("topic");
        if (topicParam != null && topicParam.length() > 0) {
            if (topicParam.startsWith("/../nav/")) {
                String navPath = topicParam.substring(8);
                StringTokenizer tok = new StringTokenizer(navPath, "_");
                int index = Integer.parseInt(tok.nextToken());
                return HelpPlugin.getTocManager().getTocs(this.getLocale())[index];
            }
            Toc[] tocs = HelpPlugin.getTocManager().getTocs(this.getLocale());
            int i = 0;
            while (i < tocs.length) {
                if (tocs[i].getTopic(topicParam) != null) {
                    return tocs[i];
                }
                ++i;
            }
        }
        return null;
    }

    private ITopic getTopic() {
        String topicParam = this.request.getParameter("topic");
        String anchorParam = this.request.getParameter("anchor");
        if (anchorParam != null) {
            topicParam = String.valueOf(topicParam) + '#' + anchorParam;
        }
        if (topicParam != null && topicParam.length() > 0) {
            if (topicParam.startsWith("/../nav/")) {
                String navPath = topicParam.substring(8);
                StringTokenizer tok = new StringTokenizer(navPath, "_");
                int index = Integer.parseInt(tok.nextToken());
                ITopic topic = HelpPlugin.getTocManager().getTocs(this.getLocale())[index].getTopic(null);
                while (tok.hasMoreTokens()) {
                    index = Integer.parseInt(tok.nextToken());
                    topic = topic.getSubtopics()[index];
                }
                return topic;
            }
            Toc[] tocs = HelpPlugin.getTocManager().getTocs(this.getLocale());
            int i = 0;
            while (i < tocs.length) {
                ITopic topic = tocs[i].getTopic(topicParam);
                if (topic != null) {
                    return topic;
                }
                topic = tocs[i].getTopic(null);
                if (topicParam.equals(topic.getHref())) {
                    return topic;
                }
                ++i;
            }
            return null;
        }
        return this.getToc().getTopic(null);
    }

    private static String removeAnchor(String href) {
        int index = href.indexOf(35);
        if (index != -1) {
            return href.substring(0, index);
        }
        return href;
    }

    private String getCssIncludes() {
        ArrayList css = new ArrayList();
        CssUtil.addCssFiles("topic_css", css);
        return CssUtil.createCssIncludes(css);
    }
}

