/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceWriter {
    private StringBuffer buf;
    private Locale locale;

    public PreferenceWriter(StringBuffer buf, Locale locale) {
        this.buf = buf;
        this.locale = locale;
    }

    public void writePreferences() {
        this.writePreference("org.eclipse.help");
        this.writePreference("org.eclipse.help.base");
    }

    private void writePreference(String plugin) {
        try {
            InstanceScope instanceScope = new InstanceScope();
            IEclipsePreferences prefs = instanceScope.getNode(plugin);
            HashSet<String> keySet = new HashSet<String>();
            keySet.addAll(Arrays.asList(prefs.keys()));
            DefaultScope defaultScope = new DefaultScope();
            prefs = defaultScope.getNode(plugin);
            keySet.addAll(Arrays.asList(prefs.keys()));
            Object[] allKeys = keySet.toArray(new String[keySet.size()]);
            if (allKeys.length > 0) {
                Arrays.sort(allKeys);
                this.buf.append("<h3>");
                this.buf.append(plugin);
                this.buf.append("</h3>");
                this.buf.append("<table>");
                int i = 0;
                while (i < allKeys.length) {
                    this.buf.append("<tr>");
                    Object key = allKeys[i];
                    this.buf.append("<td>");
                    this.buf.append(UrlUtil.htmlEncode((String)key));
                    this.buf.append("</td><td>");
                    String value = Platform.getPreferencesService().getString(plugin, (String)key, "", null);
                    this.buf.append(UrlUtil.htmlEncode(value));
                    this.buf.append("</td></tr>");
                    ++i;
                }
                this.buf.append("</table>");
            }
        }
        catch (BackingStoreException backingStoreException) {
            this.buf.append(WebappResources.getString("badPreferences", this.locale));
        }
    }
}

