/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUiUtil {
    static final String SEPARATOR_CODEASSIST = "\u0000";
    public static final String ASSIST_MYLYN_ALL = "org.eclipse.mylyn.java.ui.javaAllProposalCategory";
    public static final String ASSIST_JDT_ALL = "org.eclipse.jdt.ui.javaAllProposalCategory";
    public static final String ASSIST_JDT_TYPE = "org.eclipse.jdt.ui.javaTypeProposalCategory";
    public static final String ASSIST_JDT_NOTYPE = "org.eclipse.jdt.ui.javaNoTypeProposalCategory";
    private static final String ASSIST_JDT_TEMPLATE = "org.eclipse.jdt.ui.templateProposalCategory";

    public static boolean isDefaultAssistActive(String computerId) {
        if (ASSIST_JDT_ALL.equals(computerId)) {
            CompletionProposalCategory category = JavaUiUtil.getProposalCategory(computerId);
            return category != null ? category.isEnabled() && category.isIncluded() : false;
        }
        Set<String> disabledIds = JavaUiUtil.getDisabledIds(JavaPlugin.getDefault().getPreferenceStore());
        return !disabledIds.contains(computerId);
    }

    public static CompletionProposalCategory getProposalCategory(String computerId) {
        List computers = CompletionProposalComputerRegistry.getDefault().getProposalCategories();
        for (Object object : computers) {
            CompletionProposalCategory proposalCategory = (CompletionProposalCategory)object;
            if (!computerId.equals(proposalCategory.getId())) continue;
            return proposalCategory;
        }
        return null;
    }

    public static void installContentAssist(IPreferenceStore javaPrefs, boolean mylynContentAssist) {
        Set<String> disabledIds = JavaUiUtil.getDisabledIds(javaPrefs);
        if (!mylynContentAssist) {
            disabledIds.remove(ASSIST_JDT_ALL);
            disabledIds.remove(ASSIST_JDT_TYPE);
            disabledIds.remove(ASSIST_JDT_NOTYPE);
            disabledIds.add(ASSIST_MYLYN_ALL);
        } else {
            disabledIds.add(ASSIST_JDT_ALL);
            disabledIds.add(ASSIST_JDT_TYPE);
            disabledIds.add(ASSIST_JDT_NOTYPE);
            disabledIds.remove(ASSIST_JDT_TEMPLATE);
            disabledIds.remove(ASSIST_MYLYN_ALL);
        }
        StringBuilder sb = new StringBuilder();
        for (String id : disabledIds) {
            sb.append(id);
            sb.append(SEPARATOR_CODEASSIST);
        }
        javaPrefs.setValue("content_assist_disabled_computers", sb.toString());
        CompletionProposalComputerRegistry.getDefault().reload();
    }

    public static Set<String> getDisabledIds(IPreferenceStore javaPrefs) {
        String oldValue = javaPrefs.getString("content_assist_disabled_computers");
        StringTokenizer tokenizer = new StringTokenizer(oldValue, SEPARATOR_CODEASSIST);
        HashSet<String> disabledIds = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            disabledIds.add((String)tokenizer.nextElement());
        }
        return disabledIds;
    }
}

