/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.mpowerplayer;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.launching.LaunchEnvironment;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDevice;
import org.eclipse.mtj.internal.core.sdk.device.LaunchTemplateProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;

public class MpowerplayerDevice
extends JavaEmulatorDevice {
    private static final String MPP_ROOT_PERSISTENCE_KEY = "mppRoot";
    private File mppRoot;

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor iProgressMonitor) throws CoreException {
        File file;
        IMidletSuiteProject iMidletSuiteProject;
        File file2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ILaunchConfiguration iLaunchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean bl = this.shouldDirectLaunchJAD(iLaunchConfiguration);
        hashMap.put(LaunchTemplateProperties.EXECUTABLE.toString(), this.getJavaExecutable().toString());
        hashMap.put("mpproot", this.mppRoot.toString());
        if (launchEnvironment.isDebugLaunch()) {
            hashMap.put(LaunchTemplateProperties.DEBUGPORT.toString(), new Integer(launchEnvironment.getDebugListenerPort()).toString());
        }
        String string = iLaunchConfiguration.getAttribute("mtj.launch_params", "");
        hashMap.put(LaunchTemplateProperties.USERSPECIFIEDARGUMENTS.toString(), string);
        if (bl) {
            hashMap.put(LaunchTemplateProperties.JADFILE.toString(), this.getSpecifiedJadURL(iLaunchConfiguration));
        } else if (launchEnvironment.getProject() instanceof IMidletSuiteProject && (file2 = this.getJadForLaunch(iMidletSuiteProject = (IMidletSuiteProject)launchEnvironment.getProject(), file = this.copyForLaunch(iMidletSuiteProject, iProgressMonitor, bl), iProgressMonitor)).exists()) {
            hashMap.put(LaunchTemplateProperties.JADFILE.toString(), file2.toString());
        }
        return ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, hashMap);
    }

    public File getMppRoot() {
        return this.mppRoot;
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.loadUsing(iPersistenceProvider);
        String string = iPersistenceProvider.loadString(MPP_ROOT_PERSISTENCE_KEY);
        this.mppRoot = new File(string);
    }

    public void setMppRoot(File file) {
        this.mppRoot = file;
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.storeUsing(iPersistenceProvider);
        iPersistenceProvider.storeString(MPP_ROOT_PERSISTENCE_KEY, this.mppRoot.toString());
    }

    public File getWorkingDirectory() {
        return null;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MpowerplayerDevice) {
            bl = super.equals((AbstractMIDPDevice)((MpowerplayerDevice)((Object)object)));
        }
        return bl;
    }
}

