/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.uei;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mtj.core.launching.LaunchEnvironment;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.LaunchTemplateProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;

public class UEIDevice
extends AbstractMIDPDevice
implements IMIDPDevice {
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof UEIDevice) {
            bl = this.equals((UEIDevice)((Object)object));
        }
        return bl;
    }

    public boolean equals(UEIDevice uEIDevice) {
        return super.equals((AbstractMIDPDevice)uEIDevice) && this.launchCommandTemplate.equals(uEIDevice.launchCommandTemplate);
    }

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = Platform.getOS().equals("win32");
        String string = "";
        ILaunchConfiguration iLaunchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean bl2 = this.shouldDirectLaunchJAD(iLaunchConfiguration);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = bl ? this.executable.getName() : this.executable.getAbsolutePath();
        string2 = "\"" + string2 + "\"";
        hashMap.put(LaunchTemplateProperties.EXECUTABLE.toString(), string2);
        hashMap.put(LaunchTemplateProperties.DEVICE.toString(), this.getName());
        if (launchEnvironment.isDebugLaunch()) {
            hashMap.put(LaunchTemplateProperties.DEBUGPORT.toString(), Integer.toString(launchEnvironment.getDebugListenerPort()));
        }
        this.addLaunchConfigurationValue(hashMap, LaunchTemplateProperties.VERBOSE.toString(), iLaunchConfiguration, "mtj.verbosity_options");
        this.addLaunchConfigurationValue(hashMap, LaunchTemplateProperties.HEAPSIZE.toString(), iLaunchConfiguration, "mtj.heap_size");
        String string3 = iLaunchConfiguration.getAttribute("mtj.security_domain", "None");
        if (!string3.equals("None")) {
            hashMap.put(LaunchTemplateProperties.SECURITYDOMAIN.toString(), string3);
        }
        String string4 = iLaunchConfiguration.getAttribute("mtj.launch_params", "");
        hashMap.put(LaunchTemplateProperties.USERSPECIFIEDARGUMENTS.toString(), string4);
        if (bl2) {
            hashMap.put(LaunchTemplateProperties.JADFILE.toString(), this.getSpecifiedJadURL(iLaunchConfiguration));
        } else if (launchEnvironment.getProject() instanceof IMidletSuiteProject) {
            IMidletSuiteProject iMidletSuiteProject = (IMidletSuiteProject)launchEnvironment.getProject();
            File file = this.copyForLaunch(iMidletSuiteProject, iProgressMonitor, bl2);
            String string5 = this.getProjectClasspathString(launchEnvironment.getProject(), file, iProgressMonitor);
            hashMap.put(LaunchTemplateProperties.CLASSPATH.toString(), string5);
            if (this.shouldDoOTA(iLaunchConfiguration)) {
                String string6 = this.getOTAURL(iLaunchConfiguration, iMidletSuiteProject);
                hashMap.put(LaunchTemplateProperties.OTAURL.toString(), string6);
            } else {
                File file2 = this.getJadForLaunch(iMidletSuiteProject, file, iProgressMonitor);
                if (file2.exists()) {
                    hashMap.put(LaunchTemplateProperties.JADFILE.toString(), file2.toString());
                }
                this.addLaunchConfigurationValue(hashMap, LaunchTemplateProperties.TARGET.toString(), iLaunchConfiguration, IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME);
            }
        }
        string = ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, hashMap);
        return bl ? "cmd /c " + string : string;
    }

    public File getWorkingDirectory() {
        return this.executable.getParentFile();
    }

    public int hashCode() {
        return this.deviceClasspath.hashCode() ^ this.executable.hashCode() ^ this.name.hashCode() ^ this.launchCommandTemplate.hashCode() ^ this.groupName.hashCode();
    }
}

