/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.devices;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceFinder;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.DeviceFinder;
import org.eclipse.mtj.internal.core.sdk.device.IFoundDevicesList;
import org.eclipse.mtj.internal.core.sdk.device.SimpleFoundDevicesList;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.devices.DeviceTableLabelProvider;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.internal.ui.viewers.TableViewerConfiguration;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class DeviceImportWizardPage
extends WizardPage {
    public static final String NAME = "deviceImportPage";
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.DeviceImportWizardPage_import_columnInfo, 10.0f, null), new TableColumnInfo(MTJUIMessages.DeviceImportWizardPage_group_columnInfo, 22.5f, null), new TableColumnInfo(MTJUIMessages.DeviceImportWizardPage_name_columnInfo, 22.5f, null), new TableColumnInfo(MTJUIMessages.DeviceImportWizardPage_canfiguration_columnInfo, 22.5f, null), new TableColumnInfo(MTJUIMessages.DeviceImportWizardPage_profile_columnInfo, 22.5f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 550;
    private static final String KEY_HEIGHT = "dialogHeight";
    private static final String KEY_WIDTH = "dialogWidth";
    private static final Object[] NO_ELEMENTS = new Object[0];
    private Button browseButton;
    private Button deselectAllButton;
    private UpdatingFoundDevicesList deviceList;
    private CheckboxTableViewer deviceViewer;
    private String lastRootText;
    private Button refreshButton;
    private Text rootText;
    private Button selectAllButton;
    private IDeviceFinder deviceFinder = DeviceFinder.getInstance();

    public DeviceImportWizardPage() {
        super(NAME, MTJUIMessages.DeviceImportWizardPage_title, null);
        this.setDescription(MTJUIMessages.DeviceImportWizardPage_SelectDirectoryMessage);
        this.setImageDescriptor(MTJUIPluginImages.DESC_IMPORT_DEV);
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        composite.setLayoutData((Object)new GridData(1808));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                DeviceImportWizardPage.this.storeSize();
            }
        });
        this.setControl((Control)composite2);
        this.addRootDirectoryControls(composite2);
        this.addDeviceSelectorControls(composite2);
        Point point = this.retrieveSize();
        if (point != null) {
            composite2.setSize(point);
        }
    }

    public IDevice[] getSelectedDevices() {
        Object[] objectArray = this.deviceViewer.getCheckedElements();
        IDevice[] iDeviceArray = new IDevice[objectArray.length];
        System.arraycopy(objectArray, 0, iDeviceArray, 0, objectArray.length);
        return iDeviceArray;
    }

    public void searchRoots(String[] stringArray) {
        File[] fileArray;
        this.rootText.setEnabled(false);
        this.browseButton.setEnabled(false);
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            fileArray = stringArray2[n2];
            File file = new File((String)fileArray);
            if (file.exists()) {
                arrayList.add(file);
            }
            ++n2;
        }
        fileArray = arrayList.toArray(new File[arrayList.size()]);
        this.updateDevices(fileArray);
    }

    private void addDeviceSelectorControls(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(MTJUIMessages.DeviceImportWizardPage_deviceSelector_label_text);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData(1808);
        gridData2.minimumWidth = 550;
        this.deviceViewer = this.createTableViewer(composite);
        this.deviceViewer.getTable().setLayoutData((Object)gridData2);
        this.addDeviceTableButtons(composite);
    }

    private void addDeviceTableButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.selectAllButton = new Button(composite2, 8);
        this.selectAllButton.setText(MTJUIMessages.DeviceImportWizardPage_selectAllButton_label_text);
        this.selectAllButton.setLayoutData((Object)new GridData(768));
        this.selectAllButton.setEnabled(false);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceImportWizardPage.this.deviceViewer.setAllChecked(true);
                DeviceImportWizardPage.this.updateFinishButton();
            }
        });
        this.deselectAllButton = new Button(composite2, 8);
        this.deselectAllButton.setText(MTJUIMessages.DeviceImportWizardPage_deselectAllButton_label_text);
        this.deselectAllButton.setLayoutData((Object)new GridData(768));
        this.deselectAllButton.setEnabled(false);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceImportWizardPage.this.deviceViewer.setAllChecked(false);
                DeviceImportWizardPage.this.updateFinishButton();
            }
        });
        this.refreshButton = new Button(composite2, 8);
        this.refreshButton.setText(MTJUIMessages.DeviceImportWizardPage_refreshButton_label_text);
        this.refreshButton.setLayoutData((Object)new GridData(768));
        this.refreshButton.setEnabled(false);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceImportWizardPage.this.updateDevices(true);
            }
        });
    }

    private void addRootDirectoryControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(MTJUIMessages.DeviceImportWizardPage_search_directory_label_text);
        this.rootText = new Text(composite2, 2048);
        this.rootText.setLayoutData((Object)new GridData(768));
        DirectoryFocusListener directoryFocusListener = new DirectoryFocusListener();
        this.rootText.addFocusListener((FocusListener)directoryFocusListener);
        this.rootText.addTraverseListener((TraverseListener)directoryFocusListener);
        this.rootText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                DeviceImportWizardPage.this.updateRefreshButton();
            }
        });
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(MTJUIMessages.DeviceImportWizardPage_browseButton_label_text);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceImportWizardPage.this.handleBrowseButton();
            }
        });
    }

    private CheckboxTableViewer createTableViewer(Composite composite) {
        int n = 68132;
        Table table = new Table(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        CheckboxTableViewer checkboxTableViewer = new CheckboxTableViewer(table);
        checkboxTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new DeviceTableLabelProvider());
        this.deviceList = new UpdatingFoundDevicesList();
        checkboxTableViewer.setInput((Object)this.deviceList);
        checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                DeviceImportWizardPage.this.updateFinishButton();
            }
        });
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings(this.getDialogSettings(), "viewerSettings");
        TableViewerConfiguration tableViewerConfiguration = new TableViewerConfiguration(iDialogSettings, 550, COLUMN_INFO, 1);
        tableViewerConfiguration.configure((TableViewer)checkboxTableViewer);
        return checkboxTableViewer;
    }

    private IRunnableWithProgress getDeviceSearchRunnable(final File[] fileArray) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    DeviceImportWizardPage.this.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            DeviceImportWizardPage.this.deviceList.clear();
                        }
                    });
                    File[] fileArray2 = fileArray;
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray2[n2];
                        DeviceImportWizardPage.this.deviceList.addDevices(DeviceImportWizardPage.this.deviceFinder.findDevices(file, iProgressMonitor));
                        ++n2;
                    }
                    DeviceImportWizardPage.this.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            DeviceImportWizardPage.this.deviceViewer.refresh();
                            DeviceImportWizardPage.this.deviceViewer.setAllChecked(true);
                        }
                    });
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
    }

    private void handleBrowseButton() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setMessage(MTJUIMessages.DeviceImportWizardPage_handleBrowseButton_message);
        String string = directoryDialog.open();
        if (string != null) {
            this.rootText.setText(string);
            this.updateDevices(true);
        }
    }

    private void handleDeviceSearchException(Throwable throwable) {
        MTJUIPlugin.displayError(this.getShell(), 4, -999, MTJUIMessages.DeviceImportWizardPage_handleDeviceSearchException_title, MTJUIMessages.DeviceImportWizardPage_handleDeviceSearchException_message, throwable);
        MTJLogger.log((int)4, (String)throwable.getMessage(), (Throwable)throwable);
    }

    private Point retrieveSize() {
        Point point = null;
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings.get(KEY_WIDTH) != null) {
            point = new Point(iDialogSettings.getInt(KEY_WIDTH), iDialogSettings.getInt(KEY_HEIGHT));
        }
        return point;
    }

    private void storeSize() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        Point point = this.getControl().getSize();
        iDialogSettings.put(KEY_WIDTH, point.x);
        iDialogSettings.put(KEY_HEIGHT, point.y);
    }

    private void updateDevices(boolean bl) {
        String string = this.rootText.getText().trim();
        if (bl || !string.equals(this.lastRootText)) {
            this.lastRootText = string;
            File file = new File(string);
            if (file.exists()) {
                this.updateDevices(file);
            }
        }
        this.updateSelectButtons();
        this.updateFinishButton();
    }

    private void updateDevices(File file) {
        this.updateDevices(new File[]{file});
    }

    private void updateDevices(File[] fileArray) {
        IRunnableWithProgress iRunnableWithProgress = this.getDeviceSearchRunnable(fileArray);
        try {
            this.getContainer().run(true, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleDeviceSearchException(invocationTargetException.getCause());
        }
        catch (InterruptedException interruptedException) {}
    }

    private void updateFinishButton() {
        this.setPageComplete(this.deviceViewer.getCheckedElements().length > 0);
    }

    private void updateRefreshButton() {
        String string = this.rootText.getText().trim();
        File file = new File(string);
        if (file.exists()) {
            this.refreshButton.setEnabled(true);
        } else {
            this.refreshButton.setEnabled(false);
        }
    }

    private void updateSelectButtons() {
        UpdatingFoundDevicesList updatingFoundDevicesList = (UpdatingFoundDevicesList)((Object)this.deviceViewer.getInput());
        int n = updatingFoundDevicesList.getDevices().size();
        if (n > 0) {
            this.selectAllButton.setEnabled(true);
            this.deselectAllButton.setEnabled(true);
        } else {
            this.selectAllButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
        }
    }

    private void updateStatusMessage(IStatus[] iStatusArray) {
        if (iStatusArray == null || iStatusArray.length < 1) {
            this.setMessage(this.getDescription());
        } else {
            this.setMessage(iStatusArray[0].getMessage(), iStatusArray[0].getSeverity());
        }
    }

    private class DirectoryFocusListener
    implements FocusListener,
    TraverseListener {
        private DirectoryFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            DeviceImportWizardPage.this.updateDevices(false);
        }

        public void keyTraversed(TraverseEvent traverseEvent) {
            if (traverseEvent.detail == 4) {
                traverseEvent.doit = false;
                DeviceImportWizardPage.this.updateDevices(false);
            }
        }
    }

    private static class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return object == null ? NO_ELEMENTS : ((IFoundDevicesList)object).getDevices().toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdatingFoundDevicesList
    extends SimpleFoundDevicesList {
        private UpdatingFoundDevicesList() {
        }

        public void addDevices(List<IDevice> list) {
            super.addDevices(list);
            this.refreshViewer();
        }

        public void clear() {
            super.clear();
            this.refreshViewer();
        }

        private void refreshViewer() {
            final IStatus[] iStatusArray = this.validateDevices();
            DeviceImportWizardPage.this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    DeviceImportWizardPage.this.deviceViewer.refresh();
                    DeviceImportWizardPage.this.updateStatusMessage(iStatusArray);
                }
            });
        }

        private IStatus[] validateDevices() {
            for (IDevice iDevice : DeviceImportWizardPage.this.deviceList.getDevices()) {
                if (((IMIDPDevice)iDevice).getPreverifier() != null || MTJCore.getDeviceRegistry().getDefaultPreferifier() != null) continue;
                return new Status[]{new Status(2, "org.eclipse.mtj.ui", MTJUIMessages.DeviceImportWizardPage_InvalidPreverifierMessage)};
            }
            return null;
        }
    }
}

