/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.dialog;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.core.sign.PermissionsGroup;
import org.eclipse.mtj.internal.core.sign.PermissionsGroupsRegistry;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class SecurityPermissionsDialog {
    public static CheckedTreeSelectionDialog createDialog(Shell shell) {
        SecurityPermissionsDialog securityPermissionsDialog;
        SecurityPermissionsDialog securityPermissionsDialog2 = securityPermissionsDialog = new SecurityPermissionsDialog();
        securityPermissionsDialog2.getClass();
        SecurityPermissionsDialogLabelProvider securityPermissionsDialogLabelProvider = securityPermissionsDialog2.new SecurityPermissionsDialogLabelProvider();
        SecurityPermissionsDialog securityPermissionsDialog3 = securityPermissionsDialog;
        securityPermissionsDialog3.getClass();
        CheckedTreeSelectionDialog checkedTreeSelectionDialog = new CheckedTreeSelectionDialog(shell, (ILabelProvider)securityPermissionsDialogLabelProvider, (ITreeContentProvider)securityPermissionsDialog3.new SecurityPermissionsDialogContentProvider());
        checkedTreeSelectionDialog.setTitle(MTJUIMessages.SecurityPermissionsDialog_title);
        checkedTreeSelectionDialog.setMessage(MTJUIMessages.SecurityPermissionsDialog_message);
        checkedTreeSelectionDialog.setContainerMode(true);
        checkedTreeSelectionDialog.setInput((Object)PermissionsGroupsRegistry.getInstance());
        return checkedTreeSelectionDialog;
    }

    private SecurityPermissionsDialog() {
    }

    public class PermissionNode {
        private PermissionsGroup parent;
        private String permission;

        public PermissionNode(String string, PermissionsGroup permissionsGroup) {
            this.permission = string;
            this.parent = permissionsGroup;
        }

        public PermissionsGroup getParent() {
            return this.parent;
        }

        public String getPermission() {
            return this.permission;
        }
    }

    private class SecurityPermissionsDialogContentProvider
    implements ITreeContentProvider {
        private SecurityPermissionsDialogContentProvider() {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof PermissionsGroup) {
                PermissionsGroup permissionsGroup = (PermissionsGroup)object;
                ArrayList<PermissionNode> arrayList = new ArrayList<PermissionNode>();
                for (String string : permissionsGroup.getPermissions()) {
                    arrayList.add(new PermissionNode(string, permissionsGroup));
                }
                return arrayList.toArray();
            }
            return null;
        }

        public Object getParent(Object object) {
            if (object instanceof PermissionNode) {
                return ((PermissionNode)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            return object instanceof PermissionsGroup;
        }

        public Object[] getElements(Object object) {
            if (object instanceof PermissionsGroupsRegistry) {
                PermissionsGroupsRegistry permissionsGroupsRegistry = (PermissionsGroupsRegistry)object;
                return permissionsGroupsRegistry.getPermissions().toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    private class SecurityPermissionsDialogLabelProvider
    extends LabelProvider {
        private SecurityPermissionsDialogLabelProvider() {
        }

        public String getText(Object object) {
            String string = null;
            if (object instanceof PermissionsGroup) {
                string = ((PermissionsGroup)object).getClassName();
            } else if (object instanceof PermissionNode) {
                string = ((PermissionNode)object).getPermission();
            }
            return string;
        }

        public Image getImage(Object object) {
            Image image = null;
            if (object instanceof PermissionsGroup) {
                image = MTJUIPluginImages.DESC_CLASS_OBJ.createImage();
            } else if (object instanceof PermissionNode) {
                image = MTJUIPluginImages.DESC_PERMISSION_OBJ.createImage();
            }
            return image;
        }
    }
}

