/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.outline;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.actions.SortAction;
import org.eclipse.mtj.internal.ui.editor.outline.IOutlineContentCreator;
import org.eclipse.mtj.internal.ui.editor.outline.IOutlineSelectionHandler;
import org.eclipse.mtj.internal.ui.editor.outline.QuickOutlineMouseMoveListener;
import org.eclipse.mtj.internal.ui.editor.outline.QuickOutlineNamePatternFilter;
import org.eclipse.mtj.internal.ui.util.StringMatcher;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class QuickOutlinePopupDialog
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private Text fFilterText;
    private QuickOutlineNamePatternFilter fNamePatternFilter;
    private IOutlineContentCreator fOutlineContentCreator;
    private IOutlineSelectionHandler fOutlineSelectionHandler;
    private SortAction fSortAction;
    private StringMatcher fStringMatcher;
    private ITreeContentProvider fTreeContentProvider;
    private ILabelProvider fTreeLabelProvider;
    private TreeViewer fTreeViewer;
    private ViewerComparator fTreeViewerComparator;
    private ViewerComparator fTreeViewerDefaultComparator;

    public QuickOutlinePopupDialog(Shell shell, int n, IOutlineContentCreator iOutlineContentCreator, IOutlineSelectionHandler iOutlineSelectionHandler) {
        super(shell, n, true, true, true, true, null, null);
        this.fOutlineContentCreator = iOutlineContentCreator;
        this.fOutlineSelectionHandler = iOutlineSelectionHandler;
        this.initialize();
        this.create();
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.getShell().addDisposeListener(disposeListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.getShell().addFocusListener(focusListener);
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void dispose() {
        this.close();
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && this.fTreeViewer.getInput() != null;
    }

    public boolean isFocusControl() {
        return this.fTreeViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.getShell().removeDisposeListener(disposeListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.getShell().removeFocusListener(focusListener);
    }

    public void setBackgroundColor(Color color) {
        this.applyBackgroundColor(color, this.getContents());
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fFilterText.setFocus();
    }

    public void setForegroundColor(Color color) {
        this.applyForegroundColor(color, this.getContents());
    }

    public void setInformation(String string) {
    }

    public void setInput(Object object) {
        if (object != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object));
        }
    }

    public void setLocation(Point point) {
        if (!this.getPersistBounds() || this.getDialogSettings() == null) {
            this.getShell().setLocation(point);
        }
    }

    public void setSize(int n, int n2) {
        this.getShell().setSize(n, n2);
    }

    public void setSizeConstraints(int n, int n2) {
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.fTreeViewer = null;
        this.fFilterText = null;
    }

    private void createUIActions() {
        this.fSortAction = new SortAction((StructuredViewer)this.fTreeViewer, MTJUIMessages.QuickOutlinePopupDialog_sortActionText, this.fTreeViewerComparator, this.fTreeViewerDefaultComparator, null);
    }

    private void createUIListenersFilterText() {
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13) {
                    QuickOutlinePopupDialog.this.gotoSelectedElement();
                } else if (keyEvent.keyCode == 0x1000002) {
                    QuickOutlinePopupDialog.this.fTreeViewer.getTree().setFocus();
                } else if (keyEvent.keyCode == 0x1000001) {
                    QuickOutlinePopupDialog.this.fTreeViewer.getTree().setFocus();
                } else if (keyEvent.character == '\u001b') {
                    QuickOutlinePopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = ((Text)modifyEvent.widget).getText();
                int n = string.length();
                if (n > 0) {
                    if (string.charAt(n - 1) != '*') {
                        string = String.valueOf(string) + '*';
                    }
                    if (string.charAt(0) != '*') {
                        string = String.valueOf('*') + string;
                    }
                }
                QuickOutlinePopupDialog.this.setMatcherString(string, true);
            }
        });
    }

    private void createUIListenersTreeViewer() {
        final Tree tree = this.fTreeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    QuickOutlinePopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                QuickOutlinePopupDialog.this.handleTreeViewerMouseUp(tree, mouseEvent);
            }
        });
        tree.addMouseMoveListener((MouseMoveListener)new QuickOutlineMouseMoveListener(this.fTreeViewer));
        tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                QuickOutlinePopupDialog.this.gotoSelectedElement();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    private void createUIWidgetFilterText(Composite composite) {
        this.fFilterText = new Text(composite, 0);
        GC gC = new GC((Drawable)composite);
        gC.setFont(composite.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        GridData gridData = new GridData(768);
        gridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)gridData);
    }

    private void createUIWidgetTreeViewer(Composite composite) {
        int n = 768;
        Tree tree = new Tree(composite, n);
        GridData gridData = new GridData(1808);
        gridData.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gridData);
        this.fTreeViewer = new TreeViewer(tree);
        this.fNamePatternFilter = new QuickOutlineNamePatternFilter();
        this.fTreeViewer.addFilter((ViewerFilter)this.fNamePatternFilter);
        this.fTreeContentProvider = this.fOutlineContentCreator.createOutlineContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeLabelProvider = this.fOutlineContentCreator.createOutlineLabelProvider();
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeLabelProvider);
        this.fTreeViewerComparator = this.fOutlineContentCreator.createOutlineComparator();
        this.fTreeViewerDefaultComparator = this.fOutlineContentCreator.createDefaultOutlineComparator();
        this.fTreeViewer.setComparator(this.fTreeViewerDefaultComparator);
        this.fTreeViewer.setAutoExpandLevel(-1);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setInput(this.fOutlineContentCreator.getOutlineInput());
    }

    private Object findFirstMatchToPattern(TreeItem[] treeItemArray) {
        ILabelProvider iLabelProvider = (ILabelProvider)this.fTreeViewer.getLabelProvider();
        TreeItem[] treeItemArray2 = treeItemArray;
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            TreeItem treeItem = treeItemArray2[n2];
            Object object = treeItem.getData();
            if (this.fStringMatcher == null) {
                return object;
            }
            if (object != null && this.fStringMatcher.match(string = iLabelProvider.getText(object))) {
                return object;
            }
            object = this.findFirstMatchToPattern(treeItem.getItems());
            if (object != null) {
                return object;
            }
            ++n2;
        }
        return null;
    }

    private Object getSelectedElement() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
    }

    private void gotoSelectedElement() {
        Object object = this.getSelectedElement();
        if (object == null) {
            return;
        }
        this.dispose();
        this.fOutlineSelectionHandler.getContentOutline().setSelection((ISelection)new StructuredSelection(object));
    }

    private void handleTreeViewerMouseUp(Tree tree, MouseEvent mouseEvent) {
        if (tree.getSelectionCount() < 1 || mouseEvent.button != 1 || !tree.equals(mouseEvent.getSource())) {
            return;
        }
        TreeItem treeItem = tree.getItem(new Point(mouseEvent.x, mouseEvent.y));
        TreeItem treeItem2 = tree.getSelection()[0];
        if (treeItem2.equals(treeItem)) {
            this.gotoSelectedElement();
        }
    }

    private void initialize() {
        this.setInfoText(MTJUIMessages.QuickOutlinePopupDialog_infoText);
        this.fFilterText = null;
        this.fTreeViewer = null;
        this.fStringMatcher = null;
        this.fNamePatternFilter = null;
        this.fSortAction = null;
        this.fTreeContentProvider = null;
        this.fTreeLabelProvider = null;
        this.fTreeViewerComparator = null;
        this.fTreeViewerDefaultComparator = null;
    }

    private void selectFirstMatch() {
        Tree tree = this.fTreeViewer.getTree();
        Object object = this.findFirstMatchToPattern(tree.getItems());
        if (object != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object), true);
        } else {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void setMatcherString(String string, boolean bl) {
        this.fStringMatcher = string.length() == 0 ? null : new StringMatcher(string, true, false);
        this.fNamePatternFilter.setStringMatcher(this.fStringMatcher);
        if (bl) {
            this.stringMatcherUpdated();
        }
    }

    private void stringMatcherUpdated() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
        this.selectFirstMatch();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    protected Control createDialogArea(Composite composite) {
        if (this.fOutlineContentCreator == null || this.fOutlineSelectionHandler == null) {
            return super.createDialogArea(composite);
        }
        this.createUIWidgetTreeViewer(composite);
        this.createUIListenersTreeViewer();
        this.createUIActions();
        this.addDisposeListener(this);
        return this.fTreeViewer.getControl();
    }

    protected Control createTitleControl(Composite composite) {
        this.createUIWidgetFilterText(composite);
        this.createUIListenersFilterText();
        return this.fFilterText;
    }

    protected void fillDialogMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.fSortAction);
        iMenuManager.add((IContributionItem)new Separator());
        super.fillDialogMenu(iMenuManager);
    }
}

