/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ResourceMarkerAnnotationModel
extends AbstractMarkerAnnotationModel {
    private IResource fResource;
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    private IWorkspace fWorkspace;

    public ResourceMarkerAnnotationModel(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        this.fResource = iResource;
        this.fWorkspace = iResource.getWorkspace();
    }

    private void batchedUpdate(IMarkerDelta[] iMarker) {
        Object object;
        HashSet<IMarker> hashSet = new HashSet<IMarker>(((IMarkerDelta[])iMarker).length);
        HashSet<IMarker> hashSet2 = new HashSet<IMarker>(((IMarkerDelta[])iMarker).length);
        IMarker iMarker2 = iMarker;
        int n = ((IMarkerDelta[])iMarker2).length;
        int n2 = 0;
        while (n2 < n) {
            object = iMarker2[n2];
            switch (object.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(object.getMarker());
                    break;
                }
                case 2: {
                    hashSet.add(object.getMarker());
                    break;
                }
                case 4: {
                    hashSet2.add(object.getMarker());
                }
            }
            ++n2;
        }
        if (hashSet2.isEmpty() && hashSet.isEmpty()) {
            return;
        }
        object = this.getAnnotationIterator(false);
        while (object.hasNext()) {
            Position position;
            Object e = object.next();
            if (!(e instanceof MarkerAnnotation)) continue;
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)e;
            iMarker2 = markerAnnotation.getMarker();
            if (hashSet.remove(iMarker2)) {
                this.removeAnnotation((Annotation)markerAnnotation, false);
            }
            if (hashSet2.remove(iMarker2) && (position = this.createPositionFromMarker(iMarker2)) != null) {
                markerAnnotation.update();
                this.modifyAnnotationPosition((Annotation)markerAnnotation, position, false);
            }
            if (!hashSet2.isEmpty() || !hashSet.isEmpty()) continue;
            return;
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            this.addMarkerAnnotation((IMarker)iterator.next());
        }
    }

    protected void deleteMarkers(final IMarker[] iMarkerArray) throws CoreException {
        this.fWorkspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                int n = 0;
                while (n < iMarkerArray.length) {
                    iMarkerArray[n].delete();
                    ++n;
                }
            }
        }, null, 1, null);
    }

    protected IResource getResource() {
        return this.fResource;
    }

    protected boolean isAcceptable(IMarker iMarker) {
        return iMarker != null && this.fResource.equals((Object)iMarker.getResource());
    }

    protected void listenToMarkerChanges(boolean bl) {
        if (bl) {
            this.fWorkspace.addResourceChangeListener(this.fResourceChangeListener);
        } else {
            this.fWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
        }
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        return this.fResource.findMarkers("org.eclipse.core.resources.marker", true, 0);
    }

    protected void update(IMarkerDelta[] iMarkerDeltaArray) {
        if (iMarkerDeltaArray.length == 0) {
            return;
        }
        if (iMarkerDeltaArray.length == 1) {
            IMarkerDelta iMarkerDelta = iMarkerDeltaArray[0];
            switch (iMarkerDelta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(iMarkerDelta.getMarker());
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(iMarkerDelta.getMarker());
                    break;
                }
                case 4: {
                    this.modifyMarkerAnnotation(iMarkerDelta.getMarker());
                }
            }
        } else {
            this.batchedUpdate(iMarkerDeltaArray);
        }
        this.fireModelChanged();
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta;
            IResourceDelta iResourceDelta2 = iResourceChangeEvent.getDelta();
            if (iResourceDelta2 != null && ResourceMarkerAnnotationModel.this.fResource != null && (iResourceDelta = iResourceDelta2.findMember(ResourceMarkerAnnotationModel.this.fResource.getFullPath())) != null) {
                ResourceMarkerAnnotationModel.this.update(iResourceDelta.getMarkerDeltas());
            }
        }
    }
}

