/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.project.midp.DescriptorPropertyDescription;
import org.eclipse.mtj.internal.core.project.midp.JADAttributesRegistry;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.util.MidletSelectionDialogCreator;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.mtj.ui.editors.jad.JADPropertiesEditorPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class JADOptionalPropertiesEditorPage
extends JADPropertiesEditorPage {
    public static final String ID = "optional";
    public static final String PUSH_REGISTRY_PREFIX = "MIDlet-Push-";
    private static final String PROP_CLASS = "class";
    private static final String PROP_CONNSTR = "connection string";
    private static final String PROP_SENDER = "allowed sender";
    private static final String[] PROPERTIES = new String[]{"connection string", "class", "allowed sender"};
    private static final List<String> PROPERTY_LIST = Arrays.asList(PROPERTIES);
    private Button addButton;
    private ArrayList<PushRegEntry> pushRegEntries = new ArrayList();
    private Button removeButton;
    private int storedEntriesCount;
    private TableViewer tableViewer;

    public JADOptionalPropertiesEditorPage() {
        super(ID, MTJUIMessages.JADOptionalPropertiesEditorPage_title);
    }

    public JADOptionalPropertiesEditorPage(JADFormEditor jADFormEditor) {
        super(jADFormEditor, ID, MTJUIMessages.JADOptionalPropertiesEditorPage_title);
    }

    public String getTitle() {
        return MTJUIMessages.JADOptionalPropertiesEditorPage_title;
    }

    protected void addContextHelp(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_JADOptionalPropertiesEditorPage");
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/jad_editor/optional.html";
    }

    protected String getSectionDescription() {
        return null;
    }

    protected String getSectionTitle() {
        return null;
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        scrolledForm.setText(this.getTitle());
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        this.createErrorMessageHandler(iManagedForm);
        final String string = this.getHelpResource();
        if (string != null) {
            IToolBarManager iToolBarManager = scrolledForm.getToolBarManager();
            Action action = new Action("help"){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string);
                }
            };
            action.setImageDescriptor(MTJUIPluginImages.DESC_LINKTOHELP);
            iToolBarManager.add((IAction)action);
        }
        scrolledForm.updateToolBar();
        this.createSectionContent(iManagedForm, iManagedForm.getForm().getBody(), this);
    }

    protected void createSectionContent(IManagedForm iManagedForm, Composite composite, IPropertyChangeListener iPropertyChangeListener) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite2 = iManagedForm.getForm().getBody();
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new GridLayout(2, true));
        new Label(composite2, 0);
        new Label(composite2, 0);
        Section section = this.createStaticBasicSection(formToolkit, composite2, MTJUIMessages.JADOptionalPropertiesEditorPage_SectionTitle, MTJUIMessages.JADOptionalPropertiesEditorPage_description);
        Composite composite3 = this.createStaticSectionClient(formToolkit, (Composite)section, ID);
        section.setLayoutData((Object)new GridData(770));
        section.setLayout((Layout)new GridLayout());
        Section section2 = this.createStaticBasicSection(formToolkit, composite2, MTJUIMessages.JADOTAPropertiesEditorPage_SectionTitle, MTJUIMessages.JADOTAPropertiesEditorPage_SectionDescription);
        Composite composite4 = this.createStaticSectionClient(formToolkit, (Composite)section2, "ota");
        section2.setLayoutData((Object)new GridData(770));
        section2.setLayout((Layout)new GridLayout());
        Composite[] compositeArray = new Composite[]{composite3, composite4};
        this.createSectionsContent(iManagedForm, compositeArray, this);
        section.setClient((Control)composite3);
        section2.setClient((Control)composite4);
        new Label(composite2, 0);
        new Label(composite2, 0);
        Section section3 = formToolkit.createSection(composite2, 384);
        section3.setText(MTJUIMessages.JADPushRegistryEditorPage_sectionTitle);
        section3.setDescription(MTJUIMessages.JADPushRegistryEditorPage_sectionDescription);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        section3.setLayoutData((Object)gridData);
        section3.setLayout((Layout)new GridLayout());
        Composite composite5 = formToolkit.createComposite((Composite)section3, 0);
        composite5.setLayout((Layout)new GridLayout(2, false));
        section3.setClient((Control)composite5);
        this.createTableViewer(formToolkit, composite5);
        this.createButtons(formToolkit, composite5);
        this.addContextHelp(composite);
    }

    private void createSectionsContent(IManagedForm iManagedForm, Composite[] compositeArray, IPropertyChangeListener iPropertyChangeListener) {
        Label label;
        int n = 0;
        while (n < compositeArray.length) {
            compositeArray[n].setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
            new Label(compositeArray[n], 0);
            new Label(compositeArray[n], 0);
            ++n;
        }
        DescriptorPropertyDescription[] descriptorPropertyDescriptionArray = this.getDescriptors();
        if (this.fieldEditors == null) {
            this.fieldEditors = new FieldEditor[descriptorPropertyDescriptionArray.length];
        }
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = null;
        int n2 = 0;
        while (n2 < descriptorPropertyDescriptionArray.length) {
            int n3 = 0;
            while (n3 < compositeArray.length) {
                if (descriptorPropertyDescriptionArray[n2].getSectionId().equals((String)compositeArray[n3].getData())) {
                    composite = compositeArray[n3];
                    break;
                }
                ++n3;
            }
            if (composite == null) {
                throw new Error("sectionComp should not be null");
            }
            switch (descriptorPropertyDescriptionArray[n2].getDataType()) {
                case 3: {
                    this.fieldEditors[n2] = this.createIntegerFieldEditor(formToolkit, composite, descriptorPropertyDescriptionArray[n2]);
                    break;
                }
                case 4: {
                    this.fieldEditors[n2] = this.createComboFieldEditor(formToolkit, composite, descriptorPropertyDescriptionArray[n2]);
                    break;
                }
                default: {
                    this.fieldEditors[n2] = this.createStringFieldEditor(formToolkit, composite, descriptorPropertyDescriptionArray[n2]);
                }
            }
            label = this.fieldEditors[n2].getLabelControl(composite);
            formToolkit.adapt((Control)label, false, false);
            this.fieldEditors[n2].setPropertyChangeListener(iPropertyChangeListener);
            ++n2;
        }
        n2 = 0;
        while (n2 < compositeArray.length) {
            Label label2 = label = compositeArray[n2].getChildren();
            int n4 = ((Control[])label2).length;
            int n5 = 0;
            while (n5 < n4) {
                Control control = label2[n5];
                if (control instanceof Combo) {
                    formToolkit.adapt(control, false, false);
                }
                ++n5;
            }
            ++n2;
        }
        this.updateEditComponents();
    }

    protected DescriptorPropertyDescription[] doGetDescriptors() {
        DescriptorPropertyDescription[] descriptorPropertyDescriptionArray = JADAttributesRegistry.getJADAttrDescriptorsByPage((String)(String.valueOf(this.getId()) + ".optional"));
        DescriptorPropertyDescription[] descriptorPropertyDescriptionArray2 = JADAttributesRegistry.getJADAttrDescriptorsByPage((String)(String.valueOf(this.getId()) + ".ota"));
        DescriptorPropertyDescription[] descriptorPropertyDescriptionArray3 = new DescriptorPropertyDescription[descriptorPropertyDescriptionArray.length + descriptorPropertyDescriptionArray2.length];
        System.arraycopy(descriptorPropertyDescriptionArray, 0, descriptorPropertyDescriptionArray3, 0, descriptorPropertyDescriptionArray.length);
        System.arraycopy(descriptorPropertyDescriptionArray2, 0, descriptorPropertyDescriptionArray3, descriptorPropertyDescriptionArray.length, descriptorPropertyDescriptionArray2.length);
        return descriptorPropertyDescriptionArray3;
    }

    public boolean isManagingProperty(String string) {
        boolean bl = string.startsWith(PUSH_REGISTRY_PREFIX);
        if (bl) {
            String string2 = string.substring(PUSH_REGISTRY_PREFIX.length());
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    private void addItem() {
        PushRegEntry pushRegEntry = new PushRegEntry(MTJUIMessages.JADPushRegistryEditorPage_new_pushReg, "", "*");
        this.pushRegEntries.add(pushRegEntry);
        this.tableViewer.refresh();
        this.setDirty(true);
    }

    private void createButtons(FormToolkit formToolkit, Composite composite) {
        Composite composite2 = formToolkit.createComposite(composite);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        composite2.setLayout((Layout)fillLayout);
        this.addButton = formToolkit.createButton(composite2, MTJUIMessages.JADPushRegistryEditorPage_add_btn_label, 8);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JADOptionalPropertiesEditorPage.this.addItem();
            }
        });
        formToolkit.createLabel(composite2, "");
        this.removeButton = formToolkit.createButton(composite2, MTJUIMessages.JADPushRegistryEditorPage_remove_btn_label, 8);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JADOptionalPropertiesEditorPage.this.removeSelectedItems();
            }
        });
    }

    private void createTableViewer(FormToolkit formToolkit, Composite composite) {
        String[] stringArray = new String[]{MTJUIMessages.JADPushRegistryEditorPage_connection_column, MTJUIMessages.JADPushRegistryEditorPage_class_column, MTJUIMessages.JADPushRegistryEditorPage_sender_column};
        int n = 68356;
        Table table = formToolkit.createTable(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = (TableItem)selectionEvent.item;
                JADOptionalPropertiesEditorPage.this.removeButton.setEnabled(tableItem.getParent().getSelectionCount() > 0);
            }
        });
        this.tableViewer = new TableViewer(table);
        TableLayout tableLayout = new TableLayout();
        int n2 = 100 / stringArray.length;
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string = stringArray2[n4];
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(string);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(n2));
            ++n4;
        }
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.tableViewer.setColumnProperties(PROPERTIES);
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new MidletCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.tableViewer.setInput((Object)this.getEditorInput());
        this.tableViewer.refresh();
    }

    private void loadPushRegistryEntries() {
        this.pushRegEntries.clear();
        IManifestPreferenceStore iManifestPreferenceStore = this.getPreferenceStore();
        int n = 1;
        while (n < 1000) {
            String string = PUSH_REGISTRY_PREFIX + n;
            if (!iManifestPreferenceStore.contains(string)) break;
            String string2 = iManifestPreferenceStore.getString(string);
            this.pushRegEntries.add(new PushRegEntry(string2));
            ++n;
        }
        this.storedEntriesCount = this.pushRegEntries.size();
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    private void removeSelectedItems() {
        int[] nArray = this.tableViewer.getTable().getSelectionIndices();
        int n = nArray.length;
        while (n > 0) {
            int n2 = nArray[n - 1];
            this.pushRegEntries.remove(n2);
            --n;
        }
        this.setDirty(true);
        this.tableViewer.refresh();
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)iEditorInput);
        }
        this.setDirty(false);
        this.loadPushRegistryEntries();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.setTaskName(this.getTitle());
        IManifestPreferenceStore iManifestPreferenceStore = this.getPreferenceStore();
        int n = this.pushRegEntries.size();
        int n2 = 0;
        while (n2 < n) {
            PushRegEntry pushRegEntry = this.pushRegEntries.get(n2);
            iManifestPreferenceStore.setValue(PUSH_REGISTRY_PREFIX + (n2 + 1), pushRegEntry.toString());
            ++n2;
        }
        while (n2 < this.storedEntriesCount) {
            iManifestPreferenceStore.setToDefault(PUSH_REGISTRY_PREFIX + (n2 + 1));
            ++n2;
        }
        this.storedEntriesCount = n;
        super.doSave(iProgressMonitor);
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            String string2 = null;
            if (object instanceof PushRegEntry) {
                PushRegEntry pushRegEntry = (PushRegEntry)object;
                int n = this.getFieldIndex(string);
                if (n != -1) {
                    string2 = pushRegEntry.fields[n];
                }
            }
            return string2;
        }

        public void modify(Object object, String string, Object object2) {
            if (object instanceof TableItem) {
                Object object3 = ((TableItem)object).getData();
                String string2 = (String)object2;
                if (object3 instanceof PushRegEntry) {
                    int n = this.getFieldIndex(string);
                    PushRegEntry pushRegEntry = (PushRegEntry)object3;
                    if (n != -1) {
                        this.updateField(pushRegEntry, string, n, string2);
                    }
                }
            }
        }

        private int getFieldIndex(String string) {
            return PROPERTY_LIST.indexOf(string);
        }

        private void updateField(PushRegEntry pushRegEntry, String string, int n, String string2) {
            if (!pushRegEntry.fields[n].equals(string2)) {
                pushRegEntry.fields[n] = string2;
                JADOptionalPropertiesEditorPage.this.setDirty(true);
                JADOptionalPropertiesEditorPage.this.tableViewer.update((Object)pushRegEntry, new String[]{string});
            }
        }
    }

    private class MidletCellEditor
    extends DialogCellEditor {
        MidletCellEditor(Composite composite) {
            super(composite);
        }

        protected Object openDialogBox(Control control) {
            String string = null;
            try {
                IType iType;
                Object[] objectArray;
                IJavaProject iJavaProject = JADOptionalPropertiesEditorPage.this.getJavaProject();
                SelectionDialog selectionDialog = MidletSelectionDialogCreator.createMidletSelectionDialog(control.getShell(), (IRunnableContext)JADOptionalPropertiesEditorPage.this.getSite().getPage().getWorkbenchWindow(), iJavaProject, false, MTJUIMessages.JADPushRegistryEditorPage_choose_MIDlet);
                if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()) != null && objectArray.length > 0 && (iType = (IType)objectArray[0]) != null) {
                    string = iType.getFullyQualifiedName();
                }
            }
            catch (JavaModelException javaModelException) {
                MTJLogger.log((int)4, (String)"openDialogBox", (Throwable)javaModelException);
            }
            return string;
        }
    }

    static class PushRegEntry {
        public String[] fields = new String[3];

        PushRegEntry(String string) {
            String[] stringArray = string.split(",");
            int n = 0;
            while (n < 3) {
                this.fields[n] = n > stringArray.length ? "" : stringArray[n];
                ++n;
            }
        }

        PushRegEntry(String string, String string2, String string3) {
            this.fields[0] = string;
            this.fields[1] = string2;
            this.fields[2] = string3;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.fields != null) {
                int n = 0;
                while (n < this.fields.length) {
                    if (n != 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.fields[n]);
                    ++n;
                }
            }
            return stringBuffer.toString();
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return JADOptionalPropertiesEditorPage.this.pushRegEntries.toArray(new Object[JADOptionalPropertiesEditorPage.this.pushRegEntries.size()]);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            return ((PushRegEntry)object).fields[n];
        }
    }
}

