/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.FormEntryAdapter;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalesTreeSection;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalizationDataEditor;
import org.eclipse.mtj.internal.ui.editors.l10n.details.L10nAbstractDetails;
import org.eclipse.mtj.internal.ui.forms.parts.FormEntry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;

public class L10nEntryDetails
extends L10nAbstractDetails {
    private FormEntry keyEntry = null;
    private L10nEntry localeEntry = null;
    private FormEntry valueEntry = null;

    public L10nEntryDetails(LocalesTreeSection localesTreeSection) {
        super(localesTreeSection, "l10n-context");
    }

    public void commit(boolean bl) {
        super.commit(bl);
        this.keyEntry.commit();
        this.valueEntry.commit();
    }

    public void createFields(Composite composite) {
        this.createKeyWidget(composite);
        this.createSpace(composite);
        this.createValueWidget(composite);
    }

    public void hookListeners() {
        this.createLocaleEntryListeners();
        this.createPageEntryListeners();
    }

    public void selectionChanged(IFormPart iFormPart, ISelection iSelection) {
        Object object = this.getFirstSelectedObject(iSelection);
        if (object != null && object instanceof L10nEntry) {
            this.setData((L10nEntry)object);
            this.updateFields();
        }
    }

    public void setData(L10nEntry l10nEntry) {
        this.localeEntry = l10nEntry;
    }

    public void updateFields() {
        if (this.localeEntry != null) {
            this.updateKeyEntry(this.isEditableElement());
            this.updateValueEntry(this.isEditableElement());
        }
    }

    private void createLocaleEntryListeners() {
        this.keyEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry formEntry) {
                if (L10nEntryDetails.this.localeEntry != null) {
                    L10nEntryDetails.this.localeEntry.setKey(L10nEntryDetails.this.keyEntry.getValue());
                    L10nEntryDetails.this.localeEntry.getParent().validate();
                    FormEditor formEditor = L10nEntryDetails.this.getPage().getEditor();
                    if (formEditor instanceof LocalizationDataEditor) {
                        ((LocalizationDataEditor)formEditor).updateMessageManager(L10nEntryDetails.this.localeEntry.getLocales());
                    }
                }
            }
        });
    }

    private void createKeyWidget(Composite composite) {
        this.createLabel(composite, this.getManagedForm().getToolkit(), MTJUIMessages.L10nEntryDetails_keyWidgetLabel);
        this.keyEntry = new FormEntry(composite, this.getManagedForm().getToolkit(), MTJUIMessages.L10nEntryDetails_keyEntry_label, 0);
    }

    private void createPageEntryListeners() {
        this.valueEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry formEntry) {
            }

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
            }

            public void textValueChanged(FormEntry formEntry) {
                if (L10nEntryDetails.this.localeEntry != null) {
                    L10nEntryDetails.this.localeEntry.setValue(L10nEntryDetails.this.valueEntry.getValue());
                }
            }
        });
    }

    private void createValueWidget(Composite composite) {
        this.createLabel(composite, this.getManagedForm().getToolkit(), MTJUIMessages.L10nEntryDetails_valueWidget_label);
        this.valueEntry = new FormEntry(composite, this.getManagedForm().getToolkit(), MTJUIMessages.L10nEntryDetails_valueEntry_label, 0);
    }

    private void updateKeyEntry(boolean bl) {
        this.keyEntry.setValue(this.localeEntry.getKey(), true);
        this.keyEntry.setEditable(bl);
    }

    private void updateValueEntry(boolean bl) {
        this.valueEntry.setValue(this.localeEntry.getValue(), true);
        this.valueEntry.setEditable(bl);
    }

    protected String getDetailsDescription() {
        return MTJUIMessages.L10nEntryDetails_detailsDescription;
    }

    protected String getDetailsTitle() {
        return MTJUIMessages.L10nEntryDetails_detailsTitle;
    }
}

