/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.details;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.dialog.SrcFolderFilter;
import org.eclipse.mtj.internal.ui.editor.FormEntryAdapter;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalesTreeSection;
import org.eclipse.mtj.internal.ui.editors.l10n.details.L10nAbstractDetails;
import org.eclipse.mtj.internal.ui.forms.parts.FormEntry;
import org.eclipse.mtj.internal.ui.util.FolderValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class L10nLocalesDetails
extends L10nAbstractDetails {
    private L10nLocales locales = null;
    private FormEntry locationEntry = null;
    private FormEntry packageEntry = null;

    public L10nLocalesDetails(LocalesTreeSection localesTreeSection) {
        super(localesTreeSection, "l10n-context");
    }

    public void commit(boolean bl) {
        super.commit(bl);
        this.packageEntry.commit();
        this.locationEntry.commit();
    }

    public void createFields(Composite composite) {
        this.createPackageWidget(composite);
        this.createSpace(composite);
        this.createLocationWidget(composite);
    }

    public void hookListeners() {
        this.createPackageEntryListeners();
        this.createLocationEntryListeners();
    }

    public void selectionChanged(IFormPart iFormPart, ISelection iSelection) {
        Object object = this.getFirstSelectedObject(iSelection);
        if (object != null && object instanceof L10nLocales) {
            this.setData((L10nLocales)object);
            this.updateFields();
        }
    }

    public void setData(L10nLocales l10nLocales) {
        this.locales = l10nLocales;
    }

    public void updateFields() {
        if (this.locales != null) {
            this.updatePackageEntry(this.isEditableElement());
            this.updateDestinationEntry(this.isEditableElement());
        }
    }

    private void createLocationEntryListeners() {
        this.locationEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry formEntry) {
                L10nLocalesDetails.this.handleLocationEntryBrowse();
            }

            public void textValueChanged(FormEntry formEntry) {
                if (L10nLocalesDetails.this.locales != null) {
                    L10nLocalesDetails.this.locales.setDestination(L10nLocalesDetails.this.locationEntry.getValue());
                }
            }
        });
    }

    private void createLocationWidget(Composite composite) {
        this.createLabel(composite, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocalesDetails_locationWidget_label);
        this.locationEntry = new FormEntry(composite, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocalesDetails_locationEntry_label, MTJUIMessages.L10nLocalesDetails_browse_label, false);
    }

    private void createPackageEntryListeners() {
        this.packageEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry formEntry) {
                L10nLocalesDetails.this.handlePackageEntryBrowse();
            }

            public void textValueChanged(FormEntry formEntry) {
                if (L10nLocalesDetails.this.locales != null) {
                    L10nLocalesDetails.this.locales.setPackage(L10nLocalesDetails.this.packageEntry.getValue());
                }
            }
        });
    }

    private void handlePackageEntryBrowse() {
        try {
            Object[] objectArray;
            IResource iResource = this.locales.getModel().getUnderlyingResource();
            IJavaProject iJavaProject = JavaCore.create((IProject)iResource.getProject());
            SelectionDialog selectionDialog = JavaUI.createPackageDialog((Shell)this.getPage().getSite().getShell(), (IJavaProject)iJavaProject, (int)0);
            selectionDialog.setMessage(MTJUIMessages.L10nLocalesDetails_packageEntryBrowseDialog_message);
            selectionDialog.setTitle(MTJUIMessages.L10nLocalesDetails_packageEntryBrowseDialog_title);
            if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()).length > 0 && this.locales != null) {
                this.packageEntry.setValue(((IPackageFragment)selectionDialog.getResult()[0]).getElementName());
            }
        }
        catch (JavaModelException javaModelException) {
            MTJLogger.log((int)4, (Throwable)javaModelException);
        }
    }

    private void createPackageWidget(Composite composite) {
        this.createLabel(composite, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocalesDetails_packageWidget_label);
        this.packageEntry = new FormEntry(composite, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocalesDetails_packageEntry_label, MTJUIMessages.L10nLocalesDetails_browse_label, false);
    }

    private void handleLocationEntryBrowse() {
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        IResource iResource = this.locales.getModel().getUnderlyingResource();
        IJavaProject iJavaProject = JavaCore.create((IProject)iResource.getProject());
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)new FolderValidator());
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setTitle(MTJUIMessages.L10nLocalesDetails_locationEntryBrowseDialog_title);
        elementTreeSelectionDialog.setMessage(MTJUIMessages.L10nLocalesDetails_locationEntryBrowseDialog_message);
        try {
            elementTreeSelectionDialog.addFilter((ViewerFilter)new SrcFolderFilter(iJavaProject.getProject(), Utils.getJavaProjectSourceDirectories((IJavaProject)iJavaProject)));
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)4, (Throwable)coreException);
        }
        elementTreeSelectionDialog.setInput((Object)MTJUIPlugin.getWorkspace().getRoot());
        if (elementTreeSelectionDialog.open() == 0) {
            IFolder iFolder = (IFolder)elementTreeSelectionDialog.getFirstResult();
            this.locationEntry.setValue(iFolder.getProjectRelativePath().toString());
        }
    }

    private void updateDestinationEntry(boolean bl) {
        this.locationEntry.setValue(this.locales.getDestination(), true);
        this.locationEntry.setEditable(bl);
    }

    private void updatePackageEntry(boolean bl) {
        this.packageEntry.setValue(this.locales.getPackage(), true);
        this.packageEntry.setEditable(bl);
    }

    protected String getDetailsDescription() {
        return null;
    }

    protected String getDetailsTitle() {
        return MTJUIMessages.L10nLocalesDetails_detailsTitle;
    }
}

