/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.util.TestCaseSelectionDialogCreator;
import org.eclipse.mtj.internal.ui.util.TestSuiteSelectionDialogCreator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class JMUnitTab
extends JavaLaunchTab {
    private Button projectButton;
    private Label projectLabel;
    private Text projectText;
    Group groupExecutable;
    private Button testSuiteRadio;
    private Text testSuiteText;
    private Button testSuiteSearchButton;
    private Button testCaseRadio;
    private Text testCaseText;
    private Button testCaseSearchButton;

    public String getName() {
        return null;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(composite2, 3);
        this.createProjectComponents(composite2);
        this.createVerticalSpacer(composite2, 3);
        this.createExecutableComponents(composite2);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        String string;
        this.updateProjectFromConfig(iLaunchConfiguration);
        boolean bl = false;
        try {
            bl = iLaunchConfiguration.getAttribute("mtj.do_test_case_launch", false);
        }
        catch (CoreException coreException) {}
        this.testSuiteRadio.setSelection(!bl);
        this.testCaseRadio.setSelection(bl);
        if (!bl) {
            string = this.getStringOrDefault(iLaunchConfiguration, IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            this.testSuiteText.setText(string);
        }
        if (bl) {
            string = this.getStringOrDefault(iLaunchConfiguration, IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            this.testCaseText.setText(string);
        }
        this.updateEnablement();
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        String string = null;
        String string2 = this.projectText.getText().trim();
        if (string2.length() > 0) {
            IProject iProject = MTJCore.getWorkspace().getRoot().getProject(string2);
            if (!iProject.exists()) {
                string = MTJUIMessages.JMUnitTab_project_does_not_exist_error;
            } else {
                try {
                    if (string == null && !iProject.hasNature("org.eclipse.mtj.jmunit.jmunitNature")) {
                        string = MTJUIMessages.JMUnitTab_project_isnt_JMUnit_enabled_error;
                        this.testSuiteSearchButton.setEnabled(false);
                        this.testSuiteText.setEnabled(false);
                        this.testCaseSearchButton.setEnabled(false);
                        this.testCaseText.setEnabled(false);
                    } else {
                        this.updateEnablement();
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
        }
        if (string == null && this.testCaseRadio.getSelection() && (string2 = this.testCaseText.getText().trim()).length() == 0) {
            string = MTJUIMessages.JMUnit_test_case_not_specified_error;
        }
        if (string == null && this.testSuiteRadio.getSelection() && (string2 = this.testSuiteText.getText().trim()).length() == 0) {
            string = MTJUIMessages.JMUnit_test_suite_not_specified_error;
        }
        this.setErrorMessage(string);
        return string == null;
    }

    private void createExecutableComponents(Composite composite) {
        Font font = composite.getFont();
        this.groupExecutable = new Group(composite, 0);
        this.groupExecutable.setText(MTJUIMessages.JMUnitTab_testType_text);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.groupExecutable.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        this.groupExecutable.setLayoutData((Object)gridData);
        this.groupExecutable.setFont(font);
        this.createSuiteComponents(this.groupExecutable);
        this.createTestCaseComponents(this.groupExecutable);
    }

    private void createProjectComponents(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(font);
        this.projectLabel = new Label(composite2, 0);
        this.projectLabel.setText(MTJUIMessages.JMUnitTab_project_text);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.projectLabel.setLayoutData((Object)gridData);
        this.projectLabel.setFont(font);
        this.projectText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.projectText.setLayoutData((Object)gridData);
        this.projectText.setFont(font);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JMUnitTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.projectButton = this.createPushButton(composite2, MTJUIMessages.JMUnitTab_browse_btn, null);
        this.projectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IJavaProject iJavaProject = JMUnitTab.this.chooseJavaProject();
                if (iJavaProject != null) {
                    String string = iJavaProject.getElementName();
                    JMUnitTab.this.projectText.setText(string);
                }
            }
        });
    }

    private void createSuiteComponents(Group group) {
        Font font = group.getFont();
        this.testSuiteRadio = new Button((Composite)group, 16);
        this.testSuiteRadio.setText(MTJUIMessages.JMUnitTab_Suite_text);
        this.testSuiteRadio.setSelection(true);
        this.testSuiteRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JMUnitTab.this.updateEnablement();
                JMUnitTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.testSuiteText = new Text((Composite)group, 2052);
        GridData gridData = new GridData(768);
        this.testSuiteText.setLayoutData((Object)gridData);
        this.testSuiteText.setFont(font);
        this.testSuiteText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JMUnitTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.testSuiteSearchButton = this.createPushButton((Composite)group, MTJUIMessages.JMUnitTab_browse_btn, null);
        this.testSuiteSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JMUnitTab.this.handleSuiteSearchButtonSelected();
            }
        });
    }

    private void createTestCaseComponents(Group group) {
        Font font = group.getFont();
        this.testCaseRadio = new Button((Composite)group, 16);
        this.testCaseRadio.setText(MTJUIMessages.JMUnitTab_TestCase_text);
        this.testCaseRadio.setSelection(true);
        this.testCaseRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JMUnitTab.this.updateEnablement();
                JMUnitTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.testCaseText = new Text((Composite)group, 2052);
        GridData gridData = new GridData(768);
        this.testCaseText.setLayoutData((Object)gridData);
        this.testCaseText.setFont(font);
        this.testCaseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JMUnitTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.testCaseSearchButton = this.createPushButton((Composite)group, MTJUIMessages.JMUnitTab_browse_btn, null);
        this.testCaseSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JMUnitTab.this.handleTestCaseSearchButtonSelected();
            }
        });
    }

    private IJavaProject chooseJavaProject() {
        IWorkspaceRoot iWorkspaceRoot;
        IJavaProject iJavaProject = null;
        JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)javaElementLabelProvider);
        elementListSelectionDialog.setTitle(MTJUIMessages.JMUnitTab_chooseJavaProject_title);
        elementListSelectionDialog.setMessage(MTJUIMessages.JMUnitTab_chooseJavaProject_message);
        try {
            iWorkspaceRoot = MTJCore.getWorkspace().getRoot();
            elementListSelectionDialog.setElements((Object[])JavaCore.create((IWorkspaceRoot)iWorkspaceRoot).getJavaProjects());
        }
        catch (JavaModelException javaModelException) {
            MTJLogger.log((int)2, (Throwable)javaModelException);
        }
        iWorkspaceRoot = this.getJavaProject();
        if (iWorkspaceRoot != null) {
            elementListSelectionDialog.setInitialSelections(new Object[]{iWorkspaceRoot});
        }
        if (elementListSelectionDialog.open() == 0) {
            iJavaProject = (IJavaProject)elementListSelectionDialog.getFirstResult();
        }
        return iJavaProject;
    }

    protected IJavaProject getJavaProject() {
        IJavaProject iJavaProject = null;
        String string = this.projectText.getText().trim();
        if (string.length() > 0) {
            IProject iProject = MTJCore.getWorkspace().getRoot().getProject(string);
            iJavaProject = JavaCore.create((IProject)iProject);
        }
        return iJavaProject;
    }

    private void updateEnablement() {
        boolean bl = this.testSuiteRadio.getSelection();
        this.testSuiteText.setEnabled(bl);
        this.testSuiteSearchButton.setEnabled(bl);
        boolean bl2 = this.testCaseRadio.getSelection();
        this.testCaseText.setEnabled(bl2);
        this.testCaseSearchButton.setEnabled(bl2);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        try {
            string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)2, (String)MTJUIMessages.JMUnitTab_updateProjectFromConfig_error, (Throwable)coreException);
        }
        this.projectText.setText(string);
    }

    private String getStringOrDefault(ILaunchConfiguration iLaunchConfiguration, String string, String string2) {
        String string3 = null;
        try {
            string3 = iLaunchConfiguration.getAttribute(string, string2);
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)2, (Throwable)coreException);
            string3 = string2;
        }
        return string3;
    }

    protected void handleSuiteSearchButtonSelected() {
        try {
            IType iType;
            Object[] objectArray;
            IJavaProject iJavaProject = this.getJavaProject();
            SelectionDialog selectionDialog = TestSuiteSelectionDialogCreator.createTestSuiteSelectionDialog(this.getShell(), (IRunnableContext)this.getLaunchConfigurationDialog(), iJavaProject, false);
            if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()) != null && objectArray.length > 0 && (iType = (IType)objectArray[0]) != null) {
                this.testSuiteText.setText(iType.getFullyQualifiedName());
                iJavaProject = iType.getJavaProject();
                this.projectText.setText(iJavaProject.getElementName());
            }
        }
        catch (JavaModelException javaModelException) {
            MTJLogger.log((int)4, (String)MTJUIMessages.JMUnitTab_handleSearchTestSuiteButtonSelected_error, (Throwable)javaModelException);
        }
    }

    protected void handleTestCaseSearchButtonSelected() {
        try {
            IType iType;
            Object[] objectArray;
            IJavaProject iJavaProject = this.getJavaProject();
            SelectionDialog selectionDialog = TestCaseSelectionDialogCreator.createTestCaseSelectionDialog(this.getShell(), (IRunnableContext)this.getLaunchConfigurationDialog(), iJavaProject, false);
            if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()) != null && objectArray.length > 0 && (iType = (IType)objectArray[0]) != null) {
                this.testCaseText.setText(iType.getFullyQualifiedName());
                iJavaProject = iType.getJavaProject();
                this.projectText.setText(iJavaProject.getElementName());
            }
        }
        catch (JavaModelException javaModelException) {
            MTJLogger.log((int)4, (String)MTJUIMessages.JMUnitTab_handleSearchTestCaseButtonSelected_error, (Throwable)javaModelException);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.projectText.getText().trim());
        if (this.testCaseRadio.getSelection()) {
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_test_case_launch", true);
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_test_suite_launch", false);
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.testCaseText.getText());
        } else if (this.testSuiteRadio.getSelection()) {
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_test_suite_launch", true);
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_test_case_launch", false);
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.testSuiteText.getText());
        }
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_ota", false);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IJavaElement iJavaElement = this.getContext();
        if (iJavaElement != null) {
            this.initializeJavaProject(iJavaElement, iLaunchConfigurationWorkingCopy);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
    }
}

