/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.internal.core.build.sign.PreferencesSignatureProperties;
import org.eclipse.mtj.internal.core.sign.DefaultKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.IKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.KeyStoreManagerException;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.IMTJUIConstants;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.dialog.SigningPasswordDialog;
import org.eclipse.mtj.internal.ui.forms.blocks.SigningBlock;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SigningPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private PreferencesSignatureProperties sigProps;
    private SigningBlock signingBlock;
    private IKeyStoreManager keyStoreManager;
    private Text keystoreTxt;
    private Button externalBtn;
    private Button passwordBtn;
    private Button ksPasswordBtn1;
    private Text keystorePasswordTxt;
    private Button ksPasswordBtn2;

    public SigningPreferencePage() {
        try {
            this.sigProps = new PreferencesSignatureProperties();
        }
        catch (CoreException coreException) {
            this.setErrorMessage(coreException.getMessage());
        }
    }

    protected Control createContents(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)MTJUIPlugin.buildGridData(16384, 0x1000000, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createKeyStoreSection(composite2);
        this.signingBlock = new SigningBlock();
        this.signingBlock.createBlock(composite2);
        this.loadSigningData();
        return composite2;
    }

    private void loadSigningData() {
        this.keystoreTxt.setText(this.convertNullToEmpty(this.sigProps.getKeyStoreDisplayPath()));
        this.keystorePasswordTxt.setText(this.convertNullToEmpty(this.sigProps.getKeyStorePassword()));
        int n = this.sigProps.getPasswordStorageMethod();
        switch (n) {
            case 1: {
                this.ksPasswordBtn1.setSelection(false);
                this.ksPasswordBtn2.setSelection(true);
                this.keystorePasswordTxt.setEnabled(true);
                break;
            }
            case 0: {
                this.ksPasswordBtn2.setSelection(false);
                this.ksPasswordBtn1.setSelection(true);
                this.keystorePasswordTxt.setEnabled(false);
            }
        }
        this.signingBlock.setProvider(this.sigProps.getKeyStoreProvider());
        this.signingBlock.setKeystoreType(this.sigProps.getKeyStoreType());
        this.loadAliases();
    }

    private String convertNullToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public boolean performOk() {
        if (this.sigProps.getPasswordStorageMethod() != 0) {
            this.sigProps.setKeyStorePassword(this.keystorePasswordTxt.getText());
        }
        this.sigProps.setKeyStoreProvider(this.signingBlock.getProvider());
        this.sigProps.setKeyStoreType(this.signingBlock.getKeystoreType());
        return this.sigProps.save();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.signingBlock.setInput(null);
        this.passwordBtn.setEnabled(false);
        this.sigProps.clear();
        this.loadSigningData();
    }

    private void createKeyStoreSection(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.verticalSpacing = 0;
        group.setLayout((Layout)gridLayout);
        group.setText(MTJUIMessages.SigningPreferencePage_keyStore);
        Label label = new Label((Composite)group, 0);
        label.setText(MTJUIMessages.SigningPreferencePage_location);
        GridData gridData = MTJUIPlugin.buildGridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.keystoreTxt = new Text((Composite)group, 2048);
        this.keystoreTxt.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
        this.externalBtn = new Button((Composite)group, 0);
        this.externalBtn.setText(MTJUIMessages.SigningPreferencePage_external);
        this.externalBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.externalBtn.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                SigningPreferencePage.this.browseExternalForKeystore();
            }
        });
        this.passwordBtn = new Button((Composite)group, 0);
        this.passwordBtn.setText(MTJUIMessages.SigningPreferencePage_changePassword);
        this.passwordBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.passwordBtn.setEnabled(false);
        this.passwordBtn.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (SigningPreferencePage.this.keyStoreManager == null) {
                    return;
                }
                SigningPasswordDialog signingPasswordDialog = new SigningPasswordDialog(SigningPreferencePage.this.getShell(), false);
                signingPasswordDialog.setTitle("Change Keystore Password");
                signingPasswordDialog.setDescription("Enter the new keystore password");
                if (signingPasswordDialog.open() != 0) {
                    return;
                }
                String string = signingPasswordDialog.getPassword();
                try {
                    SigningPreferencePage.this.keyStoreManager.changeKeystorePassword(string);
                    SigningPreferencePage.this.sigProps.setKeyStorePassword(string);
                    SigningPreferencePage.this.sigProps.save();
                    if (SigningPreferencePage.this.sigProps.getPasswordStorageMethod() != 0) {
                        SigningPreferencePage.this.keystorePasswordTxt.setText(SigningPreferencePage.this.sigProps.getKeyStorePassword());
                    }
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    MessageDialog.openError((Shell)SigningPreferencePage.this.getShell(), (String)"Keystore Manager Error", (String)keyStoreManagerException.getMessage());
                    MTJLogger.log((int)4, (String)keyStoreManagerException.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }
        });
        Composite composite2 = new Composite((Composite)group, 0);
        gridData = MTJUIPlugin.buildGridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout(3, true));
        this.ksPasswordBtn1 = new Button(composite2, 16);
        this.ksPasswordBtn1.setText(MTJUIMessages.SigningPreferencePage_promptPassword);
        this.ksPasswordBtn1.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.ksPasswordBtn1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SigningPreferencePage.this.keystorePasswordTxt.setEnabled(!SigningPreferencePage.this.ksPasswordBtn1.getSelection());
                SigningPreferencePage.this.keystorePasswordTxt.setText("");
                SigningPreferencePage.this.sigProps.setPasswordStorageMethod(0);
                SigningPreferencePage.this.sigProps.setKeyStorePassword("");
            }
        });
        this.ksPasswordBtn2 = new Button(composite2, 16);
        this.ksPasswordBtn2.setText(MTJUIMessages.SigningPreferencePage_savePasswordInWorkspace);
        this.ksPasswordBtn2.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.ksPasswordBtn2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SigningPreferencePage.this.keystorePasswordTxt.setEnabled(SigningPreferencePage.this.ksPasswordBtn2.getSelection());
                SigningPreferencePage.this.sigProps.setPasswordStorageMethod(1);
            }
        });
        Composite composite3 = new Composite((Composite)group, 0);
        gridData = MTJUIPlugin.buildGridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        composite3.setLayoutData((Object)gridData);
        composite3.setLayout((Layout)new GridLayout(2, false));
        Label label2 = new Label(composite3, 0);
        label2.setText(MTJUIMessages.SigningPreferencePage_keystorePassword);
        label2.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.keystorePasswordTxt = new Text(composite3, 2048);
        this.keystorePasswordTxt.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
    }

    private void loadAliases() {
        String string = this.sigProps.getKeyStoreDisplayPath();
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            return;
        }
        if (this.sigProps.getPasswordStorageMethod() != 0) {
            String string2 = this.keystorePasswordTxt.getText();
            this.keyStoreManager = new DefaultKeyStoreManager(file, string2);
            this.keyStoreManager.setProvider(this.signingBlock.getProvider());
            this.keyStoreManager.setKeystoreType(this.signingBlock.getKeystoreType());
            this.signingBlock.setInput(this.keyStoreManager);
            this.passwordBtn.setEnabled(true);
            String string3 = this.sigProps.getKeyAlias();
            if (string3 != null) {
                this.signingBlock.setCurrentAlias(string3);
            }
        } else {
            this.openKeyStorePasswordDialog(file);
        }
    }

    private void openKeyStorePasswordDialog(final File file) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SigningPasswordDialog signingPasswordDialog = new SigningPasswordDialog(SigningPreferencePage.this.getShell(), true);
                signingPasswordDialog.setTitle(MTJUIMessages.SigningPreferencePage_enterPassword);
                signingPasswordDialog.setDescription(MTJUIMessages.SigningPreferencePage_dialogTitle);
                if (signingPasswordDialog.open() != 0) {
                    return;
                }
                String string = signingPasswordDialog.getPassword();
                SigningPreferencePage.this.sigProps.setPasswordStorageMethod(0);
                if (signingPasswordDialog.isSavingInWorkspace()) {
                    SigningPreferencePage.this.sigProps.setPasswordStorageMethod(1);
                    SigningPreferencePage.this.keystorePasswordTxt.setText(string);
                    SigningPreferencePage.this.keystorePasswordTxt.setEnabled(true);
                    SigningPreferencePage.this.ksPasswordBtn2.setSelection(true);
                    SigningPreferencePage.this.ksPasswordBtn1.setSelection(false);
                }
                SigningPreferencePage.this.keyStoreManager = (IKeyStoreManager)new DefaultKeyStoreManager(file, string);
                SigningPreferencePage.this.keyStoreManager.setProvider(SigningPreferencePage.this.signingBlock.getProvider());
                SigningPreferencePage.this.keyStoreManager.setKeystoreType(SigningPreferencePage.this.signingBlock.getKeystoreType());
                SigningPreferencePage.this.signingBlock.setInput(SigningPreferencePage.this.keyStoreManager);
                SigningPreferencePage.this.passwordBtn.setEnabled(true);
            }
        });
    }

    private void browseExternalForKeystore() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText(MTJUIMessages.J2MESigningPropertiesPage_browse_dialog_title);
        fileDialog.setFilterNames(IMTJUIConstants.BROWSE_FILTER_NAMES);
        fileDialog.setFilterExtensions(IMTJUIConstants.BROWSE_FILTER_EXTENSIONS);
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        this.resetPasswords();
        this.sigProps.setKeyStoreDisplayPath(string);
        this.keystoreTxt.setText(string);
        this.loadAliases();
    }

    private void resetPasswords() {
        this.keystorePasswordTxt.setEnabled(false);
        this.keystorePasswordTxt.setText("");
        this.ksPasswordBtn1.setSelection(true);
        this.ksPasswordBtn2.setSelection(false);
        this.sigProps.setPasswordStorageMethod(0);
        this.sigProps.setKeyStorePassword("");
    }

    public void init(IWorkbench iWorkbench) {
    }
}

