/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WorkspaceAndExternalFileFieldEditor
extends FieldEditor {
    private static final IStatus ERROR_STATUS = MTJStatusHandler.newStatus((int)4, (int)1, (String)MTJUIMessages.WorkspaceAndExternalFileFieldEditor_error_status_message);
    private static final IStatus OK_STATUS = MTJStatusHandler.newStatus((int)0, (int)0, (String)"");
    private Button browseExternalButton;
    private Button browseWorkspaceButton;
    private Text fileText;
    private String[] filterExtensions;
    private Group group;

    public WorkspaceAndExternalFileFieldEditor(String string, String string2, String[] stringArray, Composite composite) {
        super(string, string2, composite);
        this.filterExtensions = stringArray;
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected void adjustForNumColumns(int n) {
        ((GridData)this.group.getLayoutData()).horizontalSpan = n;
    }

    protected void browseExternal() {
        FileDialog fileDialog = new FileDialog(this.fileText.getShell());
        fileDialog.setText(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseExternal_dialog_text);
        fileDialog.setFilterExtensions(this.filterExtensions);
        String string = fileDialog.open();
        if (string != null) {
            this.fileText.setText(string);
        }
    }

    protected void browseWorkspace() {
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.fileText.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        ISelectionStatusValidator iSelectionStatusValidator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                IFile iFile;
                IStatus iStatus = ERROR_STATUS;
                if (objectArray.length == 1 && objectArray[0] instanceof IFile && (iFile = (IFile)objectArray[0]).getFullPath().getFileExtension().equals("xml")) {
                    iStatus = OK_STATUS;
                }
                return iStatus;
            }
        };
        elementTreeSelectionDialog.setTitle(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseWorkspace_dialog_text);
        elementTreeSelectionDialog.setMessage(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseWorkspace_dialog_message);
        elementTreeSelectionDialog.setInput((Object)MTJCore.getWorkspace().getRoot());
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setEmptyListMessage(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseWorkspace_dialog_emptyListMessage);
        elementTreeSelectionDialog.setStatusLineAboveButtons(true);
        elementTreeSelectionDialog.setValidator(iSelectionStatusValidator);
        if (elementTreeSelectionDialog.open() == 0) {
            Object[] objectArray = elementTreeSelectionDialog.getResult();
            IFile iFile = (IFile)objectArray[0];
            IPath iPath = iFile.getFullPath();
            this.fileText.setText(iPath.toString());
        }
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        this.group = new Group(composite, 0);
        this.group.setText(this.getLabelText());
        this.group.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        this.group.setLayoutData((Object)gridData);
        this.fileText = new Text((Composite)this.group, 2048);
        gridData = new GridData(768);
        gridData.minimumWidth = 350;
        this.fileText.setLayoutData((Object)gridData);
        this.browseWorkspaceButton = new Button((Composite)this.group, 8);
        this.browseWorkspaceButton.setText(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseWorkspaceButton_text);
        this.browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkspaceAndExternalFileFieldEditor.this.browseWorkspace();
            }
        });
        this.browseExternalButton = new Button((Composite)this.group, 8);
        this.browseExternalButton.setText(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseExternalButton_text);
        this.browseExternalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkspaceAndExternalFileFieldEditor.this.browseExternal();
            }
        });
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }
}

