/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.IPreprocessContentAssistModel;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContentAssistMessages;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessJavaDocProvider;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessSymbolProviderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessSymbol
implements IPreprocessContentAssistModel {
    private static final int DEFAULTSYMBOLTYPE = 0;
    private String name;
    private int symbolType;
    private List<PreprocessSymbolProviderInfo> providerInfos;

    public PreprocessSymbol(String string) {
        this(string, 0);
    }

    public PreprocessSymbol(String string, int n) {
        this.name = string;
        this.symbolType = n;
    }

    public boolean addProvider(PreprocessSymbolProviderInfo preprocessSymbolProviderInfo) {
        return this.getProviderInfos().add(preprocessSymbolProviderInfo);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PreprocessSymbol preprocessSymbol = (PreprocessSymbol)object;
        return !(this.name == null ? preprocessSymbol.name != null : !this.name.equals(preprocessSymbol.name));
    }

    @Override
    public String getDescription() {
        if (this.symbolType == 1) {
            return this.getConfigurationSymbolDesc();
        }
        return this.getAbilitySymbolDesc();
    }

    private String getConfigurationSymbolDesc() {
        return PreprocessContentAssistMessages.symbol_configuration;
    }

    private String getAbilitySymbolDesc() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isActive()) {
            stringBuffer.append(PreprocessContentAssistMessages.symbol_active);
        } else {
            stringBuffer.append(PreprocessContentAssistMessages.symbol_inactive);
        }
        stringBuffer.append("(");
        Iterator<String> iterator = this.getPossibleValues().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String getJavaDoc() {
        return PreprocessJavaDocProvider.getDefault().getSymbolJavaDoc(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private HashSet<String> getPossibleValues() {
        HashSet<String> hashSet = new HashSet<String>();
        for (PreprocessSymbolProviderInfo preprocessSymbolProviderInfo : this.getProviderInfos()) {
            hashSet.add(preprocessSymbolProviderInfo.getProvidedSymbolValue());
        }
        return hashSet;
    }

    public List<PreprocessSymbolProviderInfo> getProviderInfos() {
        if (this.providerInfos == null) {
            this.providerInfos = new ArrayList<PreprocessSymbolProviderInfo>();
        }
        return this.providerInfos;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean isActive() {
        for (PreprocessSymbolProviderInfo preprocessSymbolProviderInfo : this.getProviderInfos()) {
            if (!preprocessSymbolProviderInfo.isActive) continue;
            return true;
        }
        return false;
    }
}

