/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContext;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateAccess;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateContext;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateContextType;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateInformationControlCreator;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessTemplateEngine {
    private static final int DEFAULT_TEMPLATE_PROPOSAL_SERVERITY = 1;
    private PreprocessTemplateContextType ppTemplateContextType;

    public PreprocessTemplateEngine(PreprocessTemplateContextType preprocessTemplateContextType) {
        this.ppTemplateContextType = preprocessTemplateContextType;
    }

    public List<PreprocessTemplateProposal> complete(PreprocessContext preprocessContext) {
        ArrayList<PreprocessTemplateProposal> arrayList = new ArrayList<PreprocessTemplateProposal>();
        Template[] templateArray = PreprocessTemplateAccess.getDefault().getTemplateStore().getTemplates();
        Position position = this.getReplacePosition(preprocessContext);
        PreprocessTemplateContext preprocessTemplateContext = this.ppTemplateContextType.createContext(preprocessContext.getDocument(), position, preprocessContext);
        Region region = new Region(position.offset, position.length);
        Template[] templateArray2 = templateArray;
        int n = templateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray2[n2];
            if (preprocessTemplateContext.canEvaluate(template)) {
                PreprocessTemplateProposal preprocessTemplateProposal = this.constructTemplateProposal(template, preprocessTemplateContext, (IRegion)region);
                arrayList.add(preprocessTemplateProposal);
            }
            ++n2;
        }
        return arrayList;
    }

    private PreprocessTemplateProposal constructTemplateProposal(Template template, PreprocessTemplateContext preprocessTemplateContext, IRegion iRegion) {
        PreprocessTemplateProposal preprocessTemplateProposal = new PreprocessTemplateProposal(template, (TemplateContext)preprocessTemplateContext, iRegion, MTJUIPluginImages.DESC_PREPROCESS_TEMPLATE_PROPOSAL.createImage(), 1);
        preprocessTemplateProposal.setInformationControlCreator(new PreprocessTemplateInformationControlCreator());
        return preprocessTemplateProposal;
    }

    private Position getReplacePosition(PreprocessContext preprocessContext) {
        int n = preprocessContext.getOffset();
        IDocument iDocument = preprocessContext.getDocument();
        int n2 = preprocessContext.getLineStartOffset();
        String string = "";
        try {
            string = iDocument.get(n2, n - n2).trim();
        }
        catch (BadLocationException badLocationException) {}
        Position position = new Position(n - string.length(), string.length());
        return position;
    }
}

