/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.properties;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.midp.J2MENature;
import org.eclipse.mtj.internal.core.build.sign.PreferencesSignatureProperties;
import org.eclipse.mtj.internal.core.build.sign.SignatureProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sign.DefaultKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.IKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.KeyStoreManagerException;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.IMTJUIConstants;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.dialog.SigningPasswordDialog;
import org.eclipse.mtj.internal.ui.forms.blocks.SigningBlock;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SigningPropertiesPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private ISignatureProperties sigProps;
    private SigningBlock signingBlock;
    private Text keystoreTxt;
    private Text keystorePasswordTxt;
    private Button ksPasswordBtn3;
    private Button ksPasswordBtn2;
    private Button ksPasswordBtn1;
    private Button passwordBtn;
    private Button externalBtn;
    private Button projectBtn;
    private Text keyPasswordTxt;
    private Button projectSpecificBtn;
    private DefaultKeyStoreManager keyStoreManager;

    public String convertEmptyToNull(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public boolean isValid() {
        boolean bl = true;
        if (this.projectSpecificBtn.getSelection()) {
            try {
                String string = this.sigProps.getAbsoluteKeyStorePath(this.getProject());
                bl &= string != null && string.length() > 0;
                if (this.sigProps.getPasswordStorageMethod() != 0) {
                    String string2 = this.keystorePasswordTxt.getText();
                    bl &= string2 != null && string2.length() > 0;
                }
            }
            catch (CoreException coreException) {
                bl = false;
            }
        }
        return true;
    }

    public boolean performOk() {
        IProject iProject = this.getProject();
        boolean bl = false;
        try {
            bl = J2MENature.hasMtjCoreNature((IProject)iProject);
        }
        catch (CoreException coreException) {}
        if (!bl) {
            return true;
        }
        boolean bl2 = false;
        if (this.sigProps.getPasswordStorageMethod() != 0) {
            this.sigProps.setKeyStorePassword(this.keystorePasswordTxt.getText());
            this.sigProps.setKeyPassword(this.keyPasswordTxt.getText());
        }
        this.sigProps.setKeyStoreProvider(this.signingBlock.getProvider());
        this.sigProps.setKeyStoreType(this.signingBlock.getKeystoreType());
        try {
            IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject();
            iMidletSuiteProject.setSignatureProperties(this.sigProps);
            iMidletSuiteProject.saveMetaData();
            bl2 = true;
        }
        catch (CoreException coreException) {
            String string = NLS.bind((String)MTJUIMessages.SigningPropertiesPage_unableToSaveSuiteMetadata, (Object)coreException.getMessage());
            MTJLogger.log((int)4, (String)string);
        }
        return bl2;
    }

    private void browseExternalForKeystore() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText(MTJUIMessages.J2MESigningPropertiesPage_browse_dialog_title);
        fileDialog.setFilterNames(IMTJUIConstants.BROWSE_FILTER_NAMES);
        fileDialog.setFilterExtensions(IMTJUIConstants.BROWSE_FILTER_EXTENSIONS);
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        this.resetPasswords();
        this.sigProps.setKeyStoreDisplayPath(string);
        this.keystoreTxt.setText(string);
        this.loadAliases();
    }

    private void resetPasswords() {
        this.keystorePasswordTxt.setEnabled(false);
        this.keystorePasswordTxt.setText("");
        this.keyPasswordTxt.setEnabled(false);
        this.keyPasswordTxt.setText("");
        this.ksPasswordBtn1.setSelection(true);
        this.ksPasswordBtn2.setSelection(false);
        this.ksPasswordBtn3.setSelection(false);
        this.sigProps.setPasswordStorageMethod(0);
        this.sigProps.setKeyStorePassword("");
        this.sigProps.setKeyPassword("");
    }

    private void browseProjectForKeystore() {
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        elementTreeSelectionDialog.setTitle(MTJUIMessages.J2MESigningPropertiesPage_browse_dialog_title);
        elementTreeSelectionDialog.setMessage(MTJUIMessages.J2MESigningPropertiesPage_browse_dialog_message);
        elementTreeSelectionDialog.setInput((Object)this.getProject());
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setEmptyListMessage(MTJUIMessages.J2MESigningPropertiesPage_browse_need_file);
        elementTreeSelectionDialog.setStatusLineAboveButtons(true);
        elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                if (objectArray.length == 0) {
                    return new Status(4, "org.eclipse.mtj.ui", 1, MTJUIMessages.J2MESigningPropertiesPage_browse_need_file, null);
                }
                if (!(objectArray[0] instanceof IFile)) {
                    return new Status(4, "org.eclipse.mtj.ui", 1, MTJUIMessages.J2MESigningPropertiesPage_browse_need_file, null);
                }
                return new Status(0, "org.eclipse.mtj.ui", 0, ((IFile)objectArray[0]).getName(), null);
            }
        });
        if (elementTreeSelectionDialog.open() != 0) {
            return;
        }
        Object[] objectArray = elementTreeSelectionDialog.getResult();
        if (objectArray.length == 0 || !(objectArray[0] instanceof IFile)) {
            return;
        }
        IFile iFile = (IFile)objectArray[0];
        IPath iPath = iFile.getFullPath();
        IPath iPath2 = iPath.removeFirstSegments(1);
        String string = iPath2.toString();
        this.resetPasswords();
        String string2 = SignatureProperties.toRelative((String)string);
        this.sigProps.setKeyStoreDisplayPath(string2);
        this.keystoreTxt.setText(string2);
        this.loadAliases();
    }

    private void loadAliases() {
        File file = null;
        try {
            String string = this.sigProps.getAbsoluteKeyStorePath(this.getProject());
            if (string == null) {
                return;
            }
            file = new File(string);
            if (!file.exists() || !file.isFile()) {
                return;
            }
            if (this.sigProps.getPasswordStorageMethod() != 0) {
                String string2 = this.keystorePasswordTxt.getText();
                this.keyStoreManager = new DefaultKeyStoreManager(file, string2);
                this.keyStoreManager.setProvider(this.signingBlock.getProvider());
                this.keyStoreManager.setKeystoreType(this.signingBlock.getKeystoreType());
                this.signingBlock.setInput((IKeyStoreManager)this.keyStoreManager);
                this.passwordBtn.setEnabled(true);
                String string3 = this.sigProps.getKeyAlias();
                if (string3 != null) {
                    this.signingBlock.setCurrentAlias(string3);
                }
            } else {
                this.openKeyStorePasswordDialog(file);
            }
        }
        catch (CoreException coreException) {
            String string = NLS.bind((String)MTJUIMessages.SigningPropertiesPage_unableToGetKeystoreAliases, (Object)coreException.getMessage());
            this.setErrorMessage(string);
            MTJLogger.log((int)4, (String)string);
        }
    }

    private void openKeyStorePasswordDialog(final File file) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SigningPasswordDialog signingPasswordDialog = new SigningPasswordDialog(SigningPropertiesPage.this.getShell(), true);
                signingPasswordDialog.setTitle(MTJUIMessages.SigningPropertiesPage_enterPassword);
                signingPasswordDialog.setDescription(MTJUIMessages.SigningPropertiesPage_enterKeystorePassword);
                if (signingPasswordDialog.open() != 0) {
                    return;
                }
                String string = signingPasswordDialog.getPassword();
                SigningPropertiesPage.this.sigProps.setPasswordStorageMethod(0);
                if (signingPasswordDialog.isSavingInWorkspace()) {
                    SigningPropertiesPage.this.sigProps.setPasswordStorageMethod(1);
                    SigningPropertiesPage.this.keystorePasswordTxt.setText(string);
                    SigningPropertiesPage.this.keystorePasswordTxt.setEnabled(true);
                    SigningPropertiesPage.this.keyPasswordTxt.setEnabled(true);
                    SigningPropertiesPage.this.ksPasswordBtn2.setSelection(true);
                    SigningPropertiesPage.this.ksPasswordBtn1.setSelection(false);
                    SigningPropertiesPage.this.ksPasswordBtn3.setSelection(false);
                }
                SigningPropertiesPage.this.keyStoreManager = new DefaultKeyStoreManager(file, string);
                SigningPropertiesPage.this.keyStoreManager.setProvider(SigningPropertiesPage.this.signingBlock.getProvider());
                SigningPropertiesPage.this.keyStoreManager.setKeystoreType(SigningPropertiesPage.this.signingBlock.getKeystoreType());
                SigningPropertiesPage.this.signingBlock.setInput((IKeyStoreManager)SigningPropertiesPage.this.keyStoreManager);
                SigningPropertiesPage.this.passwordBtn.setEnabled(true);
            }
        });
    }

    private String convertNullToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private IMidletSuiteProject getMidletSuiteProject() {
        IJavaProject iJavaProject = JavaCore.create((IProject)this.getProject());
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
        return iMidletSuiteProject;
    }

    private IProject getProject() {
        IProject iProject = null;
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable instanceof IProject) {
            iProject = (IProject)iAdaptable;
        } else if (iAdaptable instanceof IJavaProject) {
            iProject = ((IJavaProject)iAdaptable).getProject();
        }
        return iProject;
    }

    private boolean isJ2MEProject(IProject iProject) {
        boolean bl = false;
        if (iProject != null) {
            try {
                IProjectNature iProjectNature = iProject.getNature("org.eclipse.mtj.core.nature");
                bl = iProjectNature != null;
            }
            catch (CoreException coreException) {}
        }
        return bl;
    }

    private void loadSigningData() {
        boolean bl = this.sigProps.isProjectSpecific();
        this.projectSpecificBtn.setSelection(bl);
        this.setEnabled(bl);
        this.keystoreTxt.setText(this.convertNullToEmpty(this.sigProps.getKeyStoreDisplayPath()));
        this.keystorePasswordTxt.setText(this.convertNullToEmpty(this.sigProps.getKeyStorePassword()));
        this.keyPasswordTxt.setText(this.convertNullToEmpty(this.sigProps.getKeyPassword()));
        int n = this.sigProps.getPasswordStorageMethod();
        switch (n) {
            case 2: {
                this.ksPasswordBtn1.setSelection(false);
                this.ksPasswordBtn2.setSelection(false);
                this.ksPasswordBtn3.setSelection(true);
                break;
            }
            case 1: {
                this.ksPasswordBtn1.setSelection(false);
                this.ksPasswordBtn3.setSelection(false);
                this.ksPasswordBtn2.setSelection(true);
                break;
            }
            case 0: {
                this.ksPasswordBtn2.setSelection(false);
                this.ksPasswordBtn3.setSelection(false);
                this.ksPasswordBtn1.setSelection(true);
            }
        }
        this.signingBlock.setProvider(this.sigProps.getKeyStoreProvider());
        this.signingBlock.setKeystoreType(this.sigProps.getKeyStoreType());
        if (bl) {
            this.loadAliases();
        }
    }

    protected Control createContents(Composite composite) {
        this.loadSigningProperties();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_J2MEProjectPropertiesPage");
        IProject iProject = this.getProject();
        if (!this.isJ2MEProject(iProject)) {
            Label label = new Label(composite, 0);
            label.setText(MTJUIMessages.J2MESigningPropertiesPage_error_not_midlet_project);
            return label;
        }
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)MTJUIPlugin.buildGridData(16384, 0x1000000, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.projectSpecificBtn = new Button(composite2, 32);
        this.projectSpecificBtn.setText(MTJUIMessages.SigningPropertiesPage_enableProjectSpecific);
        this.projectSpecificBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(16384, 0x1000000, true, false));
        this.projectSpecificBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SigningPropertiesPage.this.loadSigningProperties();
                SigningPropertiesPage.this.sigProps.setProjectSpecific(SigningPropertiesPage.this.projectSpecificBtn.getSelection());
                SigningPropertiesPage.this.setEnabled(SigningPropertiesPage.this.sigProps.isProjectSpecific());
                if (SigningPropertiesPage.this.sigProps.isSignProject() && SigningPropertiesPage.this.sigProps.isProjectSpecific()) {
                    SigningPropertiesPage.this.loadAliases();
                }
            }
        });
        this.createKeyStoreSection(composite2);
        this.signingBlock = new SigningBlock();
        this.signingBlock.createBlock(composite2);
        this.loadSigningData();
        return composite2;
    }

    private void loadSigningProperties() {
        IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject();
        ISignatureProperties iSignatureProperties = null;
        try {
            iSignatureProperties = iMidletSuiteProject.getSignatureProperties();
        }
        catch (CoreException coreException) {}
        this.sigProps = new SignatureProperties();
        if (iSignatureProperties != null) {
            this.sigProps.copy(iSignatureProperties);
        } else {
            this.sigProps.clear();
        }
    }

    private void setEnabled(boolean bl) {
        this.keystoreTxt.setEnabled(bl);
        this.ksPasswordBtn3.setEnabled(bl);
        this.ksPasswordBtn2.setEnabled(bl);
        this.ksPasswordBtn1.setEnabled(bl);
        this.passwordBtn.setEnabled(bl);
        this.externalBtn.setEnabled(bl);
        this.projectBtn.setEnabled(bl);
        this.signingBlock.setEnabled(bl);
        boolean bl2 = this.sigProps.getPasswordStorageMethod() != 0;
        this.keystorePasswordTxt.setEnabled(bl2 && bl);
        this.keyPasswordTxt.setEnabled(bl2 && bl);
    }

    private void createKeyStoreSection(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.verticalSpacing = 0;
        group.setLayout((Layout)gridLayout);
        group.setText(MTJUIMessages.SigningPropertiesPage_keystore);
        Label label = new Label((Composite)group, 0);
        label.setText(MTJUIMessages.SigningPropertiesPage_location);
        GridData gridData = MTJUIPlugin.buildGridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.keystoreTxt = new Text((Composite)group, 2048);
        this.keystoreTxt.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
        this.projectBtn = new Button((Composite)group, 0);
        this.projectBtn.setText(MTJUIMessages.SigningPropertiesPage_project);
        this.projectBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.projectBtn.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                SigningPropertiesPage.this.browseProjectForKeystore();
            }
        });
        this.externalBtn = new Button((Composite)group, 0);
        this.externalBtn.setText(MTJUIMessages.SigningPropertiesPage_external);
        this.externalBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.externalBtn.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                SigningPropertiesPage.this.browseExternalForKeystore();
            }
        });
        this.passwordBtn = new Button((Composite)group, 0);
        this.passwordBtn.setText(MTJUIMessages.SigningPropertiesPage_changePassword);
        this.passwordBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.passwordBtn.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (SigningPropertiesPage.this.keyStoreManager == null) {
                    return;
                }
                SigningPasswordDialog signingPasswordDialog = new SigningPasswordDialog(SigningPropertiesPage.this.getShell(), false);
                signingPasswordDialog.setTitle("Change Keystore Password");
                signingPasswordDialog.setDescription("Enter the new keystore password");
                if (signingPasswordDialog.open() != 0) {
                    return;
                }
                String string = signingPasswordDialog.getPassword();
                try {
                    SigningPropertiesPage.this.keyStoreManager.changeKeystorePassword(string);
                    IMidletSuiteProject iMidletSuiteProject = SigningPropertiesPage.this.getMidletSuiteProject();
                    SigningPropertiesPage.this.sigProps.setKeyStorePassword(string);
                    iMidletSuiteProject.setSignatureProperties(SigningPropertiesPage.this.sigProps);
                    iMidletSuiteProject.saveMetaData();
                    if (SigningPropertiesPage.this.sigProps.getPasswordStorageMethod() != 0) {
                        SigningPropertiesPage.this.keystorePasswordTxt.setText(SigningPropertiesPage.this.sigProps.getKeyStorePassword());
                    }
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    MessageDialog.openError((Shell)SigningPropertiesPage.this.getShell(), (String)"Keystore Manager Error", (String)keyStoreManagerException.getMessage());
                    MTJLogger.log((int)4, (String)keyStoreManagerException.getMessage());
                }
                catch (CoreException coreException) {
                    String string2 = NLS.bind((String)MTJUIMessages.SigningPropertiesPage_unableToSaveSuiteMetadata, (Object)coreException.getMessage());
                    MTJLogger.log((int)4, (String)string2);
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }
        });
        Composite composite2 = new Composite((Composite)group, 0);
        gridData = MTJUIPlugin.buildGridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout(3, true));
        this.ksPasswordBtn1 = new Button(composite2, 16);
        this.ksPasswordBtn1.setText(MTJUIMessages.SigningPropertiesPage_prompForPassword);
        this.ksPasswordBtn1.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.ksPasswordBtn1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SigningPropertiesPage.this.keystorePasswordTxt.setEnabled(!SigningPropertiesPage.this.ksPasswordBtn1.getSelection());
                SigningPropertiesPage.this.keystorePasswordTxt.setText("");
                SigningPropertiesPage.this.keyPasswordTxt.setEnabled(!SigningPropertiesPage.this.ksPasswordBtn1.getSelection());
                SigningPropertiesPage.this.keyPasswordTxt.setText("");
                SigningPropertiesPage.this.sigProps.setPasswordStorageMethod(0);
                SigningPropertiesPage.this.sigProps.setKeyStorePassword("");
                SigningPropertiesPage.this.sigProps.setKeyPassword("");
            }
        });
        this.ksPasswordBtn2 = new Button(composite2, 16);
        this.ksPasswordBtn2.setText(MTJUIMessages.SigningPropertiesPage_savePasswordInWorkspace);
        this.ksPasswordBtn2.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.ksPasswordBtn2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SigningPropertiesPage.this.keystorePasswordTxt.setEnabled(SigningPropertiesPage.this.ksPasswordBtn2.getSelection());
                SigningPropertiesPage.this.keyPasswordTxt.setEnabled(SigningPropertiesPage.this.ksPasswordBtn2.getSelection());
                SigningPropertiesPage.this.sigProps.setPasswordStorageMethod(1);
            }
        });
        this.ksPasswordBtn3 = new Button(composite2, 16);
        this.ksPasswordBtn3.setText(MTJUIMessages.SigningPropertiesPage_savePasswordInProject);
        this.ksPasswordBtn3.setLayoutData((Object)MTJUIPlugin.buildGridData(true, false));
        this.ksPasswordBtn3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SigningPropertiesPage.this.keystorePasswordTxt.setEnabled(SigningPropertiesPage.this.ksPasswordBtn3.getSelection());
                SigningPropertiesPage.this.keyPasswordTxt.setEnabled(SigningPropertiesPage.this.ksPasswordBtn3.getSelection());
                SigningPropertiesPage.this.sigProps.setPasswordStorageMethod(2);
            }
        });
        Composite composite3 = new Composite((Composite)group, 0);
        gridData = MTJUIPlugin.buildGridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        composite3.setLayoutData((Object)gridData);
        composite3.setLayout((Layout)new GridLayout(2, false));
        Label label2 = new Label(composite3, 0);
        label2.setText(MTJUIMessages.SigningPropertiesPage_keyStorePassword);
        label2.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.keystorePasswordTxt = new Text(composite3, 2048);
        this.keystorePasswordTxt.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
        this.keystorePasswordTxt.setEnabled(false);
        Label label3 = new Label(composite3, 0);
        label3.setText(MTJUIMessages.SigningPropertiesPage_keyPassword);
        label3.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.keyPasswordTxt = new Text(composite3, 2048);
        this.keyPasswordTxt.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
        this.keyPasswordTxt.setEnabled(false);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setErrorMessage(null);
        boolean bl = this.sigProps.isSignProject();
        this.sigProps.clear();
        this.sigProps.setSignProject(bl);
        this.signingBlock.setInput(null);
        this.setEnabled(false);
        try {
            this.sigProps = new PreferencesSignatureProperties();
            this.loadSigningData();
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)4, (Throwable)coreException);
        }
    }
}

