/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.statusHandlers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.mtj.internal.core.build.sign.SignaturePasswords;
import org.eclipse.mtj.internal.ui.dialog.SigningPasswordsDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SignaturePasswordHandler
implements IStatusHandler {
    public Object handleStatus(IStatus iStatus, Object object) {
        Display display = Display.getCurrent();
        Object[] objectArray = (Object[])object;
        DialogRunner dialogRunner = new DialogRunner((IProject)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
        display.syncExec((Runnable)dialogRunner);
        return dialogRunner.getPasswords();
    }

    private static class DialogRunner
    implements Runnable {
        IProject project;
        SignaturePasswords passwords;

        public DialogRunner(IProject iProject, String string, String string2) {
            this.project = iProject;
            this.passwords = new SignaturePasswords();
            this.passwords.setKeystorePassword(string);
            this.passwords.setKeyPassword(string2);
        }

        public void run() {
            Display display = Display.getCurrent();
            Shell shell = display.getActiveShell();
            if (shell == null) {
                shell = new Shell(display, 0);
            }
            SigningPasswordsDialog signingPasswordsDialog = new SigningPasswordsDialog(shell, this.project);
            signingPasswordsDialog.setKeystorePassword(this.passwords.getKeystorePassword());
            signingPasswordsDialog.setKeyPassword(this.passwords.getKeyPassword());
            if (signingPasswordsDialog.open() != 0) {
                this.passwords = null;
            } else {
                this.passwords = new SignaturePasswords();
                this.passwords.setKeystorePassword(signingPasswordsDialog.getKeystorePassword());
                this.passwords.setKeyPassword(signingPasswordsDialog.getKeyPassword());
            }
        }

        public SignaturePasswords getPasswords() {
            return this.passwords;
        }
    }
}

