/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.mtj.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class NewElementWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;

    public NewElementWizard() {
        this.setNeedsProgressMonitor(true);
    }

    protected void openResource(final IFile iFile) {
        Display display;
        final IWorkbenchPage iWorkbenchPage = MTJUIPlugin.getActivePage();
        if (iWorkbenchPage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                    }
                    catch (PartInitException partInitException) {
                        MTJLogger.log((int)4, (Throwable)partInitException);
                    }
                }
            });
        }
    }

    protected abstract void finishPage(IProgressMonitor var1) throws InterruptedException, CoreException;

    protected ISchedulingRule getSchedulingRule() {
        return MTJCore.getWorkspace().getRoot();
    }

    protected boolean canRunForked() {
        return true;
    }

    public abstract IJavaElement getCreatedElement();

    protected void handleFinishException(Shell shell, InvocationTargetException invocationTargetException) {
        String string = "New";
        String string2 = "Creation of element failed.";
        ExceptionHandler.handle(invocationTargetException, shell, string, string2);
    }

    public boolean performFinish() {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
                try {
                    NewElementWizard.this.finishPage(iProgressMonitor);
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationCanceledException(interruptedException.getMessage());
                }
            }
        };
        try {
            ISchedulingRule iSchedulingRule = null;
            Job job = Job.getJobManager().currentJob();
            if (job != null) {
                iSchedulingRule = job.getRule();
            }
            WorkbenchRunnableAdapter workbenchRunnableAdapter = null;
            workbenchRunnableAdapter = iSchedulingRule != null ? new WorkbenchRunnableAdapter(iWorkspaceRunnable, iSchedulingRule, true) : new WorkbenchRunnableAdapter(iWorkspaceRunnable, this.getSchedulingRule());
            this.getContainer().run(this.canRunForked(), true, (IRunnableWithProgress)workbenchRunnableAdapter);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleFinishException(this.getShell(), invocationTargetException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    protected void selectAndReveal(IResource iResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)iResource, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
    }
}

