/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.dialogfields;

import org.eclipse.mtj.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.IComboButtonAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ComboButtonDialogField
extends ComboDialogField {
    private IComboButtonAdapter fComboButtonAdapter;
    private Button fSelectButton;
    private String fSelectButtonLabel;
    private boolean fButtonEnabled;

    protected static GridData gridDataForButton(Button button, int n) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        return gridData;
    }

    public ComboButtonDialogField(IComboButtonAdapter iComboButtonAdapter, int n) {
        super(n);
        this.fComboButtonAdapter = iComboButtonAdapter;
        this.fSelectButtonLabel = "!Select...!";
        this.fButtonEnabled = true;
    }

    public void changeControlPressed() {
        this.fComboButtonAdapter.changeControlPressed(this);
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)ComboButtonDialogField.gridDataForLabel(1));
        Combo combo = this.getComboControl(composite);
        combo.setLayoutData((Object)new GridData(768));
        Button button = this.getChangeControl(composite);
        button.setLayoutData((Object)ComboButtonDialogField.gridDataForButton(button, 1));
        return new Control[]{label, combo, button};
    }

    public void enableButton(boolean bl) {
        if (this.isOkToUse((Control)this.fSelectButton)) {
            this.fSelectButton.setEnabled(this.isEnabled() && bl);
        }
        this.fButtonEnabled = bl;
    }

    public Button getChangeControl(Composite composite) {
        if (this.fSelectButton == null) {
            this.assertCompositeNotNull(composite);
            this.fSelectButton = new Button(composite, 8);
            this.fSelectButton.setFont(composite.getFont());
            this.fSelectButton.setText(this.fSelectButtonLabel);
            this.fSelectButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
            this.fSelectButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ComboButtonDialogField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ComboButtonDialogField.this.changeControlPressed();
                }
            });
        }
        return this.fSelectButton;
    }

    public void setButtonLabel(String string) {
        this.fSelectButtonLabel = string;
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fSelectButton)) {
            this.fSelectButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
    }
}

