/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.dialogfields;

import org.eclipse.mtj.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class LayoutUtil {
    public static void doDefaultLayout(Composite composite, DialogField[] dialogFieldArray, boolean bl) {
        LayoutUtil.doDefaultLayout(composite, dialogFieldArray, bl, 0, 0);
    }

    public static void doDefaultLayout(Composite composite, DialogField[] dialogFieldArray, boolean bl, int n, int n2) {
        int n3 = LayoutUtil.getNumberOfColumns(dialogFieldArray);
        Control[][] controlArrayArray = new Control[dialogFieldArray.length][];
        int n4 = 0;
        while (n4 < dialogFieldArray.length) {
            controlArrayArray[n4] = dialogFieldArray[n4].doFillIntoGrid(composite, n3);
            ++n4;
        }
        if (bl) {
            LayoutUtil.modifyLabelSpans(controlArrayArray, --n3);
        }
        GridLayout gridLayout = null;
        gridLayout = composite.getLayout() instanceof GridLayout ? (GridLayout)composite.getLayout() : new GridLayout();
        if (n != -1) {
            gridLayout.marginWidth = n;
        }
        if (n2 != -1) {
            gridLayout.marginHeight = n2;
        }
        gridLayout.numColumns = n3;
        composite.setLayout((Layout)gridLayout);
    }

    public static int getNumberOfColumns(DialogField[] dialogFieldArray) {
        int n = 0;
        DialogField[] dialogFieldArray2 = dialogFieldArray;
        int n2 = dialogFieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DialogField dialogField = dialogFieldArray2[n3];
            n = Math.max(dialogField.getNumberOfControls(), n);
            ++n3;
        }
        return n;
    }

    public static void setHeightHint(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).heightHint = n;
        }
    }

    public static void setHorizontalGrabbing(Control control) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).grabExcessHorizontalSpace = true;
        }
    }

    public static void setHorizontalIndent(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).horizontalIndent = n;
        }
    }

    public static void setHorizontalSpan(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).horizontalSpan = n;
        } else if (n != 1) {
            GridData gridData = new GridData();
            gridData.horizontalSpan = n;
            control.setLayoutData((Object)gridData);
        }
    }

    public static void setWidthHint(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).widthHint = n;
        }
    }

    private static void modifyLabelSpans(Control[][] controlArray, int n) {
        Control[][] controlArray2 = controlArray;
        int n2 = controlArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Control[] controlArray3 = controlArray2[n3];
            LayoutUtil.setHorizontalSpan(controlArray3[0], n);
            ++n3;
        }
    }
}

