/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.dialogfields;

import org.eclipse.mtj.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.mtj.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringButtonDialogField
extends StringDialogField {
    private Button fBrowseButton;
    private String fBrowseButtonLabel;
    private boolean fButtonEnabled;
    private IStringButtonAdapter fStringButtonAdapter;

    protected static GridData gridDataForButton(Button button, int n) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        return gridData;
    }

    public StringButtonDialogField(IStringButtonAdapter iStringButtonAdapter) {
        this.fStringButtonAdapter = iStringButtonAdapter;
        this.fBrowseButtonLabel = "!Browse...!";
        this.fButtonEnabled = true;
    }

    public void changeControlPressed() {
        this.fStringButtonAdapter.changeControlPressed(this);
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)StringButtonDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(composite);
        text.setLayoutData((Object)StringButtonDialogField.gridDataForText(n - 2));
        Button button = this.getChangeControl(composite);
        button.setLayoutData((Object)StringButtonDialogField.gridDataForButton(button, 1));
        return new Control[]{label, text, button};
    }

    public void enableButton(boolean bl) {
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && bl);
        }
        this.fButtonEnabled = bl;
    }

    public Button getChangeControl(Composite composite) {
        if (this.fBrowseButton == null) {
            this.assertCompositeNotNull(composite);
            this.fBrowseButton = new Button(composite, 8);
            this.fBrowseButton.setFont(composite.getFont());
            this.fBrowseButton.setText(this.fBrowseButtonLabel);
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
            this.fBrowseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    StringButtonDialogField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    StringButtonDialogField.this.changeControlPressed();
                }
            });
        }
        return this.fBrowseButton;
    }

    public int getNumberOfControls() {
        return 3;
    }

    public void setButtonLabel(String string) {
        this.fBrowseButtonLabel = string;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
    }
}

