/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.resource.ResourceFactoryDescriptor;
import org.eclipse.wst.common.internal.emf.resource.StaticResourceFactoryDescriptor;
import org.eclipse.wst.common.internal.emf.utilities.DefaultOverridableResourceFactoryRegistry;

public abstract class FileNameResourceFactoryRegistry
extends DefaultOverridableResourceFactoryRegistry {
    private Map descriptors = new HashMap();
    private Map factories = new HashMap();

    protected Object getFileNameFactory(URI uri) {
        ResourceFactoryDescriptor descriptor;
        if (uri != null && (descriptor = this.getDescriptor(uri)) != null) {
            return this.getFactory(descriptor);
        }
        return null;
    }

    public synchronized Resource.Factory getFactory(URI uri) {
        return this.getFactory(uri, null);
    }

    public Resource.Factory getFactory(URI uri, String contentType) {
        ResourceFactoryDescriptor descriptor;
        Resource.Factory resourceFactory = null;
        if (uri != null && uri.lastSegment() != null && (descriptor = this.getDescriptor(uri)) != null) {
            resourceFactory = this.getFactory(descriptor);
        }
        if (resourceFactory == null) {
            resourceFactory = super.getFactory(uri, contentType);
        }
        return resourceFactory;
    }

    public synchronized void registerLastFileSegment(String aSimpleFileName, Resource.Factory aFactory) {
        URI uri = URI.createURI((String)aSimpleFileName);
        String lastSegment = uri.lastSegment();
        this.addDescriptor(new StaticResourceFactoryDescriptor(lastSegment, aFactory));
    }

    protected synchronized ResourceFactoryDescriptor getDescriptor(URI uri) {
        return (ResourceFactoryDescriptor)this.descriptors.get(uri.lastSegment());
    }

    protected synchronized Map getDescriptors() {
        return this.descriptors;
    }

    protected final synchronized Resource.Factory getFactory(ResourceFactoryDescriptor descriptor) {
        Resource.Factory factory = (Resource.Factory)this.factories.get(descriptor);
        if (factory == null) {
            factory = descriptor.createFactory();
            this.factories.put(descriptor, factory);
        }
        return factory;
    }

    protected void addDescriptor(ResourceFactoryDescriptor descriptor) {
        this.descriptors.put(descriptor.getShortSegment(), descriptor);
    }
}

