/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.internal.corext.dom.Bindings;

public class TypeRules {
    public static boolean canAssignPrimitive(PrimitiveType.Code toAssignCode, PrimitiveType.Code definedTypeCode) {
        if (toAssignCode == definedTypeCode) {
            return true;
        }
        if (definedTypeCode == PrimitiveType.BOOLEAN || toAssignCode == PrimitiveType.BOOLEAN) {
            return false;
        }
        if (definedTypeCode == PrimitiveType.CHAR && toAssignCode == PrimitiveType.BYTE) {
            return false;
        }
        return TypeRules.getTypeOrder(definedTypeCode) > TypeRules.getTypeOrder(toAssignCode);
    }

    public static boolean canAssign(ITypeBinding typeToAssign, ITypeBinding definedType) {
        String voidName = PrimitiveType.VOID.toString();
        if (voidName.equals(typeToAssign.getName()) || voidName.equals(definedType.getName())) {
            return false;
        }
        if (typeToAssign.isNullType()) {
            return !definedType.isPrimitive();
        }
        if (definedType.isArray()) {
            int toAssignDim;
            if (!typeToAssign.isArray()) {
                return false;
            }
            int definedDim = definedType.getDimensions();
            if (definedDim == (toAssignDim = typeToAssign.getDimensions())) {
                definedType = definedType.getElementType();
                if ((typeToAssign = typeToAssign.getElementType()).isPrimitive() && typeToAssign != definedType) {
                    return false;
                }
            } else {
                if (definedDim < toAssignDim) {
                    return TypeRules.isArrayCompatible(definedType.getElementType());
                }
                return false;
            }
        }
        if (typeToAssign.isPrimitive()) {
            if (!definedType.isPrimitive()) {
                return false;
            }
            PrimitiveType.Code toAssignCode = PrimitiveType.toCode((String)typeToAssign.getName());
            PrimitiveType.Code definedTypeCode = PrimitiveType.toCode((String)definedType.getName());
            return TypeRules.canAssignPrimitive(toAssignCode, definedTypeCode);
        }
        if (definedType.isPrimitive()) {
            return false;
        }
        if (typeToAssign.isArray()) {
            return TypeRules.isArrayCompatible(definedType);
        }
        if (TypeRules.isJavaLangObject(definedType)) {
            return true;
        }
        return Bindings.isSuperType(definedType, typeToAssign);
    }

    private static int getTypeOrder(PrimitiveType.Code type) {
        if (type == PrimitiveType.BYTE) {
            return 2;
        }
        if (type == PrimitiveType.CHAR) {
            return 3;
        }
        if (type == PrimitiveType.SHORT) {
            return 3;
        }
        if (type == PrimitiveType.INT) {
            return 4;
        }
        if (type == PrimitiveType.LONG) {
            return 5;
        }
        if (type == PrimitiveType.FLOAT) {
            return 6;
        }
        if (type == PrimitiveType.DOUBLE) {
            return 7;
        }
        return 0;
    }

    public static boolean isArrayCompatible(ITypeBinding definedType) {
        if (definedType.isTopLevel()) {
            if (definedType.isClass()) {
                return "Object".equals(definedType.getName()) && "java.lang".equals(definedType.getPackage().getName());
            }
            String qualifiedName = definedType.getQualifiedName();
            return "java.io.Serializable".equals(qualifiedName) || "java.lang.Cloneable".equals(qualifiedName);
        }
        return false;
    }

    public static boolean isJavaLangObject(ITypeBinding definedType) {
        return definedType.isTopLevel() && definedType.isClass() && "Object".equals(definedType.getName()) && "java.lang".equals(definedType.getPackage().getName());
    }

    public static boolean canCast(ITypeBinding castType, ITypeBinding bindingToCast) {
        String voidName = PrimitiveType.VOID.toString();
        if (castType.isAnonymous() || castType.isNullType() || voidName.equals(castType.getName())) {
            throw new IllegalArgumentException();
        }
        if (castType == bindingToCast) {
            return true;
        }
        if (voidName.equals(bindingToCast.getName())) {
            return false;
        }
        if (bindingToCast.isArray()) {
            int castTypeDim;
            if (!castType.isArray()) {
                return TypeRules.isArrayCompatible(castType);
            }
            int toCastDim = bindingToCast.getDimensions();
            if (toCastDim == (castTypeDim = castType.getDimensions())) {
                bindingToCast = bindingToCast.getElementType();
                if ((castType = castType.getElementType()).isPrimitive() && castType != bindingToCast) {
                    return false;
                }
            } else {
                if (toCastDim < castTypeDim) {
                    return TypeRules.isArrayCompatible(bindingToCast.getElementType());
                }
                return TypeRules.isArrayCompatible(castType.getElementType());
            }
        }
        if (castType.isPrimitive()) {
            if (!bindingToCast.isPrimitive()) {
                return false;
            }
            String boolName = PrimitiveType.BOOLEAN.toString();
            return !boolName.equals(castType.getName()) && !boolName.equals(bindingToCast.getName());
        }
        if (bindingToCast.isPrimitive()) {
            return false;
        }
        if (castType.isArray()) {
            return TypeRules.isArrayCompatible(bindingToCast);
        }
        if (castType.isInterface()) {
            if ((bindingToCast.getModifiers() & 0x10) != 0) {
                return Bindings.isSuperType(castType, bindingToCast);
            }
            return true;
        }
        if (bindingToCast.isInterface()) {
            if ((castType.getModifiers() & 0x10) != 0) {
                return Bindings.isSuperType(bindingToCast, castType);
            }
            return true;
        }
        if (TypeRules.isJavaLangObject(castType)) {
            return true;
        }
        return Bindings.isSuperType(bindingToCast, castType) || Bindings.isSuperType(castType, bindingToCast);
    }
}

