/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.engine;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;
import org.eclipse.jdt.internal.debug.eval.ast.engine.BinaryBasedSourceGenerator;
import org.eclipse.jdt.internal.debug.eval.ast.engine.SourceBasedSourceGenerator;

public class EvaluationSourceGenerator {
    private String fCodeSnippet;
    private String[] fLocalVariableTypeNames;
    private String[] fLocalVariableNames;
    private String fSource;
    private String fCompilationUnitName;
    private int fSnippetStartPosition;
    private int fRunMethodStartPosition;
    private int fRunMethodLength;

    public EvaluationSourceGenerator(String[] localVariableTypesNames, String[] localVariableNames, String codeSnippet) {
        this.fLocalVariableTypeNames = localVariableTypesNames;
        this.fLocalVariableNames = localVariableNames;
        this.fCodeSnippet = this.getCompleteSnippet(codeSnippet);
    }

    public EvaluationSourceGenerator(String codeSnippet) {
        this(new String[0], new String[0], codeSnippet);
    }

    protected String getCompleteSnippet(String codeSnippet) {
        if (this.isExpression(codeSnippet)) {
            codeSnippet = "return " + codeSnippet + ';';
        }
        return codeSnippet;
    }

    protected boolean isExpression(String codeSnippet) {
        boolean inString = false;
        byte[] chars = codeSnippet.getBytes();
        int i = 0;
        int numChars = chars.length;
        while (i < numChars) {
            switch (chars[i]) {
                case 92: {
                    if (!inString) break;
                    ++i;
                    break;
                }
                case 34: 
                case 39: {
                    inString = !inString;
                    break;
                }
                case 59: {
                    if (inString) break;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public String getCompilationUnitName() {
        return this.fCompilationUnitName;
    }

    public int getSnippetStart() {
        return this.fSnippetStartPosition;
    }

    public int getRunMethodStart() {
        return this.fRunMethodStartPosition;
    }

    public int getRunMethodLength() {
        return this.fRunMethodLength;
    }

    protected void setSnippetStart(int position) {
        this.fSnippetStartPosition = position;
    }

    protected void setRunMethodStart(int position) {
        this.fRunMethodStartPosition = position;
    }

    protected void setRunMethodLength(int length) {
        this.fRunMethodLength = length;
    }

    public String getSnippet() {
        return this.fCodeSnippet;
    }

    private void createEvaluationSourceFromSource(String source, String typeName, int position, boolean createInAStaticMethod, IJavaProject project) throws DebugException {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source.toCharArray());
        Map options = EvaluationSourceGenerator.getCompilerOptions(project);
        String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        parser.setCompilerOptions(options);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        SourceBasedSourceGenerator visitor = new SourceBasedSourceGenerator(unit, typeName, position, createInAStaticMethod, this.fLocalVariableTypeNames, this.fLocalVariableNames, this.fCodeSnippet, sourceLevel);
        unit.accept((ASTVisitor)visitor);
        if (visitor.hasError()) {
            throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, visitor.getError(), null));
        }
        String sourceRes = visitor.getSource();
        if (sourceRes == null) {
            return;
        }
        this.setSource(sourceRes);
        this.setCompilationUnitName(visitor.getCompilationUnitName());
        this.setSnippetStart(visitor.getSnippetStart());
        this.setRunMethodStart(visitor.getRunMethodStart());
        this.setRunMethodLength(visitor.getRunMethodLength());
    }

    public static Map getCompilerOptions(IJavaProject project) {
        Map options = project.getOptions(true);
        Iterator iter = options.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)options.get(key);
            if (!"error".equals(value) && !"warning".equals(value)) continue;
            options.put(key, "ignore");
        }
        options.put("org.eclipse.jdt.core.compiler.taskTags", "");
        return options;
    }

    private void createEvaluationSourceFromJDIObject(BinaryBasedSourceGenerator objectToEvaluationSourceMapper) {
        this.setCompilationUnitName(objectToEvaluationSourceMapper.getCompilationUnitName());
        this.setSnippetStart(objectToEvaluationSourceMapper.getSnippetStart());
        this.setRunMethodStart(objectToEvaluationSourceMapper.getRunMethodStart());
        this.setRunMethodLength(this.fCodeSnippet.length() + objectToEvaluationSourceMapper.getRunMethodLength());
        this.setSource(objectToEvaluationSourceMapper.getSource().insert(objectToEvaluationSourceMapper.getCodeSnippetPosition(), this.fCodeSnippet).toString());
    }

    private BinaryBasedSourceGenerator getInstanceSourceMapper(JDIReferenceType referenceType, boolean isInStaticMethod, IJavaProject project) {
        String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        BinaryBasedSourceGenerator objectToEvaluationSourceMapper = new BinaryBasedSourceGenerator(this.fLocalVariableTypeNames, this.fLocalVariableNames, isInStaticMethod, sourceLevel);
        objectToEvaluationSourceMapper.buildSource(referenceType);
        return objectToEvaluationSourceMapper;
    }

    public String getSource(IJavaReferenceType type, IJavaProject javaProject, boolean isStatic) throws CoreException {
        if (this.fSource == null) {
            String baseSource = this.getTypeSourceFromProject(type, javaProject);
            int lineNumber = this.getLineNumber((JDIReferenceType)type);
            if (baseSource != null && lineNumber != -1) {
                this.createEvaluationSourceFromSource(baseSource, type.getName(), lineNumber, isStatic, javaProject);
            }
            if (this.fSource == null) {
                BinaryBasedSourceGenerator mapper = this.getInstanceSourceMapper((JDIReferenceType)type, isStatic, javaProject);
                this.createEvaluationSourceFromJDIObject(mapper);
            }
        }
        return this.fSource;
    }

    private int getLineNumber(JDIReferenceType type) {
        ReferenceType referenceType = (ReferenceType)type.getUnderlyingType();
        try {
            List<Location> allLineLocations = referenceType.allLineLocations();
            if (!allLineLocations.isEmpty()) {
                return allLineLocations.get(0).lineNumber();
            }
        }
        catch (AbsentInformationException absentInformationException) {}
        return -1;
    }

    protected void setCompilationUnitName(String name) {
        this.fCompilationUnitName = name;
    }

    protected void setSource(String source) {
        this.fSource = source;
    }

    private String getTypeSourceFromProject(IJavaReferenceType type, IJavaProject javaProject) throws CoreException {
        String[] sourcePaths = type.getSourcePaths(null);
        IJavaElement element = null;
        element = sourcePaths != null && sourcePaths.length > 0 ? javaProject.findElement((IPath)new Path(sourcePaths[0])) : JavaDebugUtils.findElement(type.getName(), javaProject);
        return this.resolveSource(element);
    }

    private String resolveSource(IJavaElement element) throws DebugException {
        String source = null;
        try {
            if (element instanceof IClassFile) {
                source = ((IClassFile)element).getSource();
            } else if (element instanceof ICompilationUnit) {
                source = ((ICompilationUnit)element).getSource();
            }
        }
        catch (JavaModelException e) {
            throw new DebugException(e.getStatus());
        }
        return source;
    }
}

