/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.PropertyChangeNotifier;
import org.eclipse.debug.internal.ui.views.memory.SynchronizeInfo;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class MemoryViewSynchronizationService
implements IMemoryRenderingSynchronizationService,
IMemoryBlockListener,
IPropertyChangeListener {
    private static final int ENABLED = 0;
    private static final int ENABLING = 1;
    private static final int DISABLED = 2;
    private Hashtable fSynchronizeInfo = new Hashtable();
    private int fEnableState = 0;
    private Hashtable fPropertyListeners = new Hashtable();
    private IMemoryRendering fLastChangedRendering;
    private IMemoryRendering fSyncServiceProvider;
    private static final boolean DEBUG_SYNC_SERVICE = false;

    public MemoryViewSynchronizationService() {
        MemoryViewUtil.getMemoryBlockManager().addListener((IMemoryBlockListener)this);
    }

    public Object getSynchronizedProperty(IMemoryBlock memoryBlock, String propertyId) {
        SynchronizeInfo info = (SynchronizeInfo)this.fSynchronizeInfo.get(memoryBlock);
        if (info != null) {
            Object value = info.getProperty(propertyId);
            return value;
        }
        return null;
    }

    public void memoryBlocksAdded(IMemoryBlock[] memoryBlocks) {
    }

    public void memoryBlocksRemoved(IMemoryBlock[] memoryBlocks) {
        if (this.fSynchronizeInfo == null) {
            return;
        }
        int i = 0;
        while (i < memoryBlocks.length) {
            SynchronizeInfo info;
            IMemoryBlock memory = memoryBlocks[i];
            if (this.fLastChangedRendering != null && this.fLastChangedRendering.getMemoryBlock() == memory) {
                this.fLastChangedRendering = null;
            }
            if (this.fSyncServiceProvider != null && this.fSyncServiceProvider.getMemoryBlock() == memory) {
                this.fSyncServiceProvider = null;
            }
            if ((info = (SynchronizeInfo)this.fSynchronizeInfo.get(memory)) != null) {
                info.delete();
                this.fSynchronizeInfo.remove(memory);
            }
            ++i;
        }
    }

    public void shutdown() {
        if (this.fSynchronizeInfo != null) {
            Enumeration enumeration = this.fSynchronizeInfo.elements();
            while (enumeration.hasMoreElements()) {
                SynchronizeInfo info = (SynchronizeInfo)enumeration.nextElement();
                info.delete();
            }
            this.fSynchronizeInfo.clear();
            this.fSynchronizeInfo = null;
        }
        MemoryViewUtil.getMemoryBlockManager().removeListener((IMemoryBlockListener)this);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener, String[] properties) {
        PropertyListener propertylistener = new PropertyListener(listener, properties);
        if (!this.fPropertyListeners.contains(propertylistener)) {
            this.fPropertyListeners.put(listener, propertylistener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fPropertyListeners.containsKey(listener)) {
            this.fPropertyListeners.remove(listener);
        }
    }

    public void firePropertyChanged(final PropertyChangeEvent evt) {
        if (this.fEnableState == 2) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Object value;
                if (MemoryViewSynchronizationService.this.fSynchronizeInfo == null) {
                    return;
                }
                IMemoryRendering rendering = (IMemoryRendering)evt.getSource();
                String propertyId = evt.getProperty();
                SynchronizeInfo info = (SynchronizeInfo)MemoryViewSynchronizationService.this.fSynchronizeInfo.get(rendering.getMemoryBlock());
                if (info != null && (value = info.getProperty(propertyId)) != null) {
                    Enumeration enumeration = MemoryViewSynchronizationService.this.fPropertyListeners.elements();
                    while (enumeration.hasMoreElements()) {
                        PropertyListener listener = (PropertyListener)enumeration.nextElement();
                        IPropertyChangeListener origListener = listener.getListener();
                        if (!listener.isValidProperty(propertyId)) continue;
                        PropertyChangeNotifier notifier = new PropertyChangeNotifier(origListener, evt);
                        SafeRunner.run((ISafeRunnable)notifier);
                    }
                }
            }
        });
    }

    public Object getProperty(IMemoryBlock block, String property) {
        if (!this.isEnabled()) {
            return null;
        }
        SynchronizeInfo info = (SynchronizeInfo)this.fSynchronizeInfo.get(block);
        if (info != null) {
            return info.getProperty(property);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object oldValue;
        if (event == null || !(event.getSource() instanceof IMemoryRendering)) {
            return;
        }
        if (this.fEnableState == 1) {
            return;
        }
        IMemoryRendering rendering = (IMemoryRendering)event.getSource();
        IMemoryBlock memoryBlock = rendering.getMemoryBlock();
        String propertyId = event.getProperty();
        Object value = event.getNewValue();
        if (memoryBlock == null) {
            return;
        }
        if (propertyId == null) {
            return;
        }
        SynchronizeInfo info = (SynchronizeInfo)this.fSynchronizeInfo.get(memoryBlock);
        if (info == null) {
            info = new SynchronizeInfo(memoryBlock);
            this.fSynchronizeInfo.put(memoryBlock, info);
        }
        if ((oldValue = info.getProperty(propertyId)) == null) {
            info.setProperty(propertyId, value);
            this.fLastChangedRendering = rendering;
            this.firePropertyChanged(event);
            return;
        }
        if (!oldValue.equals(value)) {
            info.setProperty(propertyId, value);
            this.fLastChangedRendering = rendering;
            this.firePropertyChanged(event);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled && this.fEnableState == 0) {
            return;
        }
        if (!enabled && this.fEnableState == 2) {
            return;
        }
        try {
            if (enabled) {
                this.fEnableState = 1;
                if (this.fLastChangedRendering != null) {
                    IMemoryBlock memBlock = this.fLastChangedRendering.getMemoryBlock();
                    SynchronizeInfo info = (SynchronizeInfo)this.fSynchronizeInfo.get(memBlock);
                    String[] ids = info.getPropertyIds();
                    int i = 0;
                    while (i < ids.length) {
                        PropertyChangeEvent evt = new PropertyChangeEvent((Object)this.fLastChangedRendering, ids[i], null, info.getProperty(ids[i]));
                        this.firePropertyChanged(evt);
                        ++i;
                    }
                }
            }
        }
        finally {
            this.fEnableState = enabled ? 0 : 2;
        }
    }

    public boolean isEnabled() {
        return this.fEnableState == 0;
    }

    public void setSynchronizationProvider(IMemoryRendering rendering) {
        if (this.fSyncServiceProvider != null) {
            this.fSyncServiceProvider.removePropertyChangeListener(this);
        }
        if (rendering != null) {
            rendering.addPropertyChangeListener(this);
        }
        this.fSyncServiceProvider = rendering;
    }

    public IMemoryRendering getSynchronizationProvider() {
        return this.fSyncServiceProvider;
    }

    class PropertyListener {
        IPropertyChangeListener fListener;
        String[] fFilters;

        public PropertyListener(IPropertyChangeListener listener, String[] properties) {
            this.fListener = listener;
            if (properties != null) {
                this.fFilters = properties;
            }
        }

        public boolean isValidProperty(String property) {
            if (this.fFilters == null) {
                return true;
            }
            int i = 0;
            while (i < this.fFilters.length) {
                if (this.fFilters[i].equals(property)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void setPropertyFilters(String[] filters) {
            this.fFilters = filters;
        }

        public IPropertyChangeListener getListener() {
            return this.fListener;
        }
    }
}

