/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.buildpath.BuildPathSupport;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class JUnitContainerInitializer
extends ClasspathContainerInitializer {
    public static final String JUNIT_CONTAINER_ID = "org.eclipse.jdt.junit.JUNIT_CONTAINER";
    private static final IStatus NOT_SUPPORTED = new Status(4, "org.eclipse.jdt.junit", 1, new String(), null);
    private static final IStatus READ_ONLY = new Status(4, "org.eclipse.jdt.junit", 2, new String(), null);
    private static final String JUNIT3_8_1 = "3.8.1";
    private static final String JUNIT3 = "3";
    private static final String JUNIT4 = "4";
    public static final IPath JUNIT3_PATH = new Path("org.eclipse.jdt.junit.JUNIT_CONTAINER").append("3");
    public static final IPath JUNIT4_PATH = new Path("org.eclipse.jdt.junit.JUNIT_CONTAINER").append("4");

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (JUnitContainerInitializer.isValidJUnitContainerPath(containerPath)) {
            JUnitContainer container = JUnitContainerInitializer.getNewContainer(containerPath);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    private static JUnitContainer getNewContainer(IPath containerPath) {
        IClasspathEntry entry = null;
        IClasspathEntry entry2 = null;
        String version = containerPath.segment(1);
        if (JUNIT3_8_1.equals(version) || JUNIT3.equals(version)) {
            entry = BuildPathSupport.getJUnit3LibraryEntry();
        } else if (JUNIT4.equals(version)) {
            entry = BuildPathSupport.getJUnit4LibraryEntry();
            entry2 = BuildPathSupport.getHamcrestCoreLibraryEntry();
        }
        IClasspathEntry[] entries = entry == null ? new IClasspathEntry[]{} : (entry2 == null ? new IClasspathEntry[]{entry} : new IClasspathEntry[]{entry, entry2});
        return new JUnitContainer(containerPath, entries);
    }

    private static boolean isValidJUnitContainerPath(IPath path) {
        return path != null && path.segmentCount() == 2 && JUNIT_CONTAINER_ID.equals(path.segment(0));
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public IStatus getAccessRulesStatus(IPath containerPath, IJavaProject project) {
        return NOT_SUPPORTED;
    }

    public IStatus getSourceAttachmentStatus(IPath containerPath, IJavaProject project) {
        return READ_ONLY;
    }

    public IStatus getAttributeStatus(IPath containerPath, IJavaProject project, String attributeKey) {
        if (attributeKey.equals("javadoc_location")) {
            return Status.OK_STATUS;
        }
        return NOT_SUPPORTED;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        IPreferenceStore preferenceStore = JUnitPlugin.getDefault().getPreferenceStore();
        IClasspathEntry[] entries = containerSuggestion.getClasspathEntries();
        if (entries.length >= 1 && JUnitContainerInitializer.isValidJUnitContainerPath(containerPath)) {
            String version = containerPath.segment(1);
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                String preferenceKey = this.getPreferenceKey(entry, version);
                IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
                if (extraAttributes.length == 0) {
                    if (!preferenceStore.isDefault(preferenceKey)) {
                        preferenceStore.setToDefault(preferenceKey);
                    }
                } else {
                    int j = 0;
                    while (j < extraAttributes.length) {
                        IClasspathAttribute attrib = extraAttributes[j];
                        if (attrib.getName().equals("javadoc_location")) {
                            if (preferenceKey == null) break;
                            preferenceStore.setValue(preferenceKey, attrib.getValue());
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            JUnitContainerInitializer.rebindClasspathEntries(project.getJavaModel(), containerPath);
        }
    }

    private String getPreferenceKey(IClasspathEntry entry, String version) {
        if (JUNIT3.equals(version)) {
            return "org.eclipse.jdt.junit.junit3.javadoclocation";
        }
        if (JUNIT4.equals(version)) {
            if (entry.getPath().lastSegment().indexOf("junit") != -1) {
                return "org.eclipse.jdt.junit.junit4.javadoclocation";
            }
            return "org.eclipse.jdt.junit.junit4.hamcrest.core.javadoclocation";
        }
        return null;
    }

    private static void rebindClasspathEntries(IJavaModel model, IPath containerPath) throws JavaModelException {
        ArrayList<IJavaProject> affectedProjects = new ArrayList<IJavaProject>();
        IJavaProject[] projects = model.getJavaProjects();
        int i = 0;
        while (i < projects.length) {
            IJavaProject project = projects[i];
            IClasspathEntry[] entries = project.getRawClasspath();
            int k = 0;
            while (k < entries.length) {
                IClasspathEntry curr = entries[k];
                if (curr.getEntryKind() == 5 && containerPath.equals((Object)curr.getPath())) {
                    affectedProjects.add(project);
                }
                ++k;
            }
            ++i;
        }
        if (!affectedProjects.isEmpty()) {
            IJavaProject[] affected = affectedProjects.toArray(new IJavaProject[affectedProjects.size()]);
            IClasspathContainer[] containers = new IClasspathContainer[affected.length];
            int i2 = 0;
            while (i2 < containers.length) {
                containers[i2] = JUnitContainerInitializer.getNewContainer(containerPath);
                ++i2;
            }
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])affected, (IClasspathContainer[])containers, null);
        }
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        if (JUnitContainerInitializer.isValidJUnitContainerPath(containerPath)) {
            String version = containerPath.segment(1);
            if (JUNIT3_8_1.equals(version) || JUNIT3.equals(version)) {
                return JUnitMessages.JUnitContainerInitializer_description_initializer_junit3;
            }
            if (JUNIT4.equals(version)) {
                return JUnitMessages.JUnitContainerInitializer_description_initializer_junit4;
            }
        }
        return JUnitMessages.JUnitContainerInitializer_description_initializer_unresolved;
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }

    private static class JUnitContainer
    implements IClasspathContainer {
        private final IClasspathEntry[] fEntries;
        private final IPath fPath;

        public JUnitContainer(IPath path, IClasspathEntry[] entries) {
            this.fPath = path;
            this.fEntries = entries;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fEntries;
        }

        public String getDescription() {
            if (JUNIT4_PATH.equals((Object)this.fPath)) {
                return JUnitMessages.JUnitContainerInitializer_description_junit4;
            }
            return JUnitMessages.JUnitContainerInitializer_description_junit3;
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.fPath;
        }
    }
}

