/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;

public class BuildState {
    private static final IDelta[] EMPTY_DELTAS = new IDelta[0];
    private static final String[] NO_REEXPORTED_COMPONENTS = new String[0];
    private static final int VERSION = 16;
    private Map compatibleChanges = new HashMap();
    private Map breakingChanges = new HashMap();
    private String[] reexportedComponents;
    private Set apiToolingDependentProjects;

    BuildState() {
    }

    public static BuildState read(DataInputStream in) throws IOException {
        String pluginID = in.readUTF();
        if (!pluginID.equals("org.eclipse.pde.api.tools")) {
            throw new IOException(BuilderMessages.build_wrongFileFormat);
        }
        String kind = in.readUTF();
        if (!kind.equals("STATE")) {
            throw new IOException(BuilderMessages.build_wrongFileFormat);
        }
        if (in.readInt() != 16) {
            return null;
        }
        if (in.readBoolean()) {
            BuildState state = new BuildState();
            int numberOfCompatibleDeltas = in.readInt();
            int i = 0;
            while (i < numberOfCompatibleDeltas) {
                state.addCompatibleChange(BuildState.readDelta(in));
                ++i;
            }
            int numberOfBreakingDeltas = in.readInt();
            int i2 = 0;
            while (i2 < numberOfBreakingDeltas) {
                state.addBreakingChange(BuildState.readDelta(in));
                ++i2;
            }
            int numberOfReexportedComponents = in.readInt();
            String[] components = new String[numberOfReexportedComponents];
            int i3 = 0;
            while (i3 < numberOfReexportedComponents) {
                components[i3] = in.readUTF();
                ++i3;
            }
            state.reexportedComponents = components;
            int numberOfApiToolingDependents = in.readInt();
            int i4 = 0;
            while (i4 < numberOfApiToolingDependents) {
                state.addApiToolingDependentProject(in.readUTF());
                ++i4;
            }
            return state;
        }
        return null;
    }

    public static void write(BuildState state, DataOutputStream out) throws IOException {
        out.writeUTF("org.eclipse.pde.api.tools");
        out.writeUTF("STATE");
        out.writeInt(16);
        out.writeBoolean(true);
        IDelta[] compatibleChangesDeltas = state.getCompatibleChanges();
        int length = compatibleChangesDeltas.length;
        out.writeInt(length);
        int i = 0;
        while (i < length) {
            BuildState.writeDelta(compatibleChangesDeltas[i], out);
            ++i;
        }
        IDelta[] breakingChangesDeltas = state.getBreakingChanges();
        length = breakingChangesDeltas.length;
        out.writeInt(length);
        int i2 = 0;
        while (i2 < length) {
            BuildState.writeDelta(breakingChangesDeltas[i2], out);
            ++i2;
        }
        String[] reexportedComponents = state.getReexportedComponents();
        length = reexportedComponents.length;
        out.writeInt(length);
        int i3 = 0;
        while (i3 < length) {
            out.writeUTF(reexportedComponents[i3]);
            ++i3;
        }
        Set apiToolingDependentsProjects = state.getApiToolingDependentProjects();
        length = apiToolingDependentsProjects.size();
        out.writeInt(length);
        Iterator iterator = apiToolingDependentsProjects.iterator();
        while (iterator.hasNext()) {
            out.writeUTF((String)iterator.next());
        }
    }

    private static IDelta readDelta(DataInputStream in) throws IOException {
        boolean hasComponentID = in.readBoolean();
        String componentID = null;
        if (hasComponentID) {
            in.readUTF();
        }
        int elementType = in.readInt();
        int kind = in.readInt();
        int flags = in.readInt();
        int restrictions = in.readInt();
        int modifiers = in.readInt();
        String typeName = in.readUTF();
        String key = in.readUTF();
        int length = in.readInt();
        String[] datas = null;
        if (length != 0) {
            ArrayList<String> arguments = new ArrayList<String>();
            int i = 0;
            while (i < length) {
                arguments.add(in.readUTF());
                ++i;
            }
            datas = new String[length];
            arguments.toArray(datas);
        } else {
            datas = new String[]{typeName.replace('$', '.')};
        }
        int oldModifiers = modifiers & 0xFFFF;
        int newModifiers = modifiers >>> 16;
        return new Delta(componentID, elementType, kind, flags, restrictions, oldModifiers, newModifiers, typeName, key, datas);
    }

    private static void writeDelta(IDelta delta, DataOutputStream out) throws IOException {
        String apiComponentID = delta.getComponentVersionId();
        boolean hasComponentID = apiComponentID != null;
        out.writeBoolean(hasComponentID);
        if (hasComponentID) {
            out.writeUTF(apiComponentID);
        }
        out.writeInt(delta.getElementType());
        out.writeInt(delta.getKind());
        out.writeInt(delta.getFlags());
        out.writeInt(delta.getRestrictions());
        int modifiers = delta.getNewModifiers() << 16 | delta.getOldModifiers();
        out.writeInt(modifiers);
        out.writeUTF(delta.getTypeName());
        out.writeUTF(delta.getKey());
        String[] arguments = delta.getArguments();
        int length = arguments.length;
        out.writeInt(length);
        int i = 0;
        while (i < length) {
            out.writeUTF(arguments[i]);
            ++i;
        }
    }

    public void addCompatibleChange(IDelta delta) {
        String typeName = delta.getTypeName();
        Set object = (Set)this.compatibleChanges.get(typeName);
        if (object == null) {
            HashSet<IDelta> changes = new HashSet<IDelta>();
            changes.add(delta);
            this.compatibleChanges.put(typeName, changes);
        } else {
            object.add(delta);
        }
    }

    public void addBreakingChange(IDelta delta) {
        String typeName = delta.getTypeName();
        Set object = (Set)this.breakingChanges.get(typeName);
        if (object == null) {
            HashSet<IDelta> changes = new HashSet<IDelta>();
            changes.add(delta);
            this.breakingChanges.put(typeName, changes);
        } else {
            object.add(delta);
        }
    }

    public IDelta[] getBreakingChanges() {
        if (this.breakingChanges == null || this.breakingChanges.size() == 0) {
            return EMPTY_DELTAS;
        }
        HashSet collector = new HashSet();
        Collection values = this.breakingChanges.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            collector.addAll((HashSet)iterator.next());
        }
        return collector.toArray(new IDelta[collector.size()]);
    }

    public IDelta[] getCompatibleChanges() {
        if (this.compatibleChanges == null || this.compatibleChanges.size() == 0) {
            return EMPTY_DELTAS;
        }
        HashSet collector = new HashSet();
        Collection values = this.compatibleChanges.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            collector.addAll((HashSet)iterator.next());
        }
        return collector.toArray(new IDelta[collector.size()]);
    }

    public String[] getReexportedComponents() {
        if (this.reexportedComponents == null) {
            return NO_REEXPORTED_COMPONENTS;
        }
        return this.reexportedComponents;
    }

    public void cleanup(String typeName) {
        this.breakingChanges.remove(typeName);
        this.compatibleChanges.remove(typeName);
        this.reexportedComponents = null;
    }

    public void setReexportedComponents(IApiComponent[] components) {
        if (components == null) {
            return;
        }
        try {
            if (this.reexportedComponents == null) {
                int length = components.length;
                String[] result = new String[length];
                int i = 0;
                while (i < length) {
                    result[i] = components[i].getId();
                    ++i;
                }
                this.reexportedComponents = result;
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
    }

    public void addApiToolingDependentProject(String projectName) {
        if (this.apiToolingDependentProjects == null) {
            this.apiToolingDependentProjects = new HashSet(3);
        }
        this.apiToolingDependentProjects.add(projectName);
    }

    public Set getApiToolingDependentProjects() {
        return this.apiToolingDependentProjects == null ? Collections.EMPTY_SET : this.apiToolingDependentProjects;
    }

    public static BuildState getLastBuiltState(IProject project) throws CoreException {
        if (!Util.isApiProject(project)) {
            return null;
        }
        return BuildState.readState(project);
    }

    static BuildState readState(IProject project) throws CoreException {
        File file = BuildState.getSerializationFile(project);
        if (file != null && file.exists()) {
            BuildState buildState;
            DataInputStream in;
            block10: {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                try {
                    buildState = BuildState.read(in);
                    if (!ApiAnalysisBuilder.DEBUG) break block10;
                    System.out.println("Saved state thinks last build failed for " + project.getName());
                }
                catch (Throwable throwable) {
                    try {
                        if (ApiAnalysisBuilder.DEBUG) {
                            System.out.println("Saved state thinks last build failed for " + project.getName());
                        }
                        in.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", 2, "Error reading last build state for project " + project.getName(), (Throwable)e));
                    }
                }
            }
            in.close();
            return buildState;
        }
        if (ApiAnalysisBuilder.DEBUG) {
            if (file == null) {
                System.out.println("Project does not exist: " + project);
            } else {
                System.out.println("Build state file " + file.getPath() + " does not exist");
            }
        }
        return null;
    }

    public static void setLastBuiltState(IProject project, BuildState state) throws CoreException {
        if (Util.isApiProject(project)) {
            if (state != null) {
                BuildState.saveBuiltState(project, state);
            } else {
                try {
                    File file = BuildState.getSerializationFile(project);
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    static File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.pde.api.tools");
        return workingLocation.append("state.dat").toFile();
    }

    static void saveBuiltState(IProject project, BuildState state) throws CoreException {
        File file;
        if (ApiAnalysisBuilder.DEBUG) {
            System.out.println("Saving build state for project: " + project.getName());
        }
        if ((file = BuildState.getSerializationFile(project)) == null) {
            return;
        }
        long t = 0L;
        if (ApiAnalysisBuilder.DEBUG) {
            t = System.currentTimeMillis();
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                BuildState.write(state, out);
            }
            finally {
                out.close();
            }
        }
        catch (RuntimeException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", 2, NLS.bind((String)BuilderMessages.build_cannotSaveState, (Object)project.getName()), (Throwable)e));
        }
        catch (IOException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", 2, NLS.bind((String)BuilderMessages.build_cannotSaveState, (Object)project.getName()), (Throwable)e));
        }
        if (ApiAnalysisBuilder.DEBUG) {
            t = System.currentTimeMillis() - t;
            System.out.println(NLS.bind((String)BuilderMessages.build_saveStateComplete, (Object)String.valueOf(t)));
        }
    }
}

