/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.build.BuildHookInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildHooksRegistry
implements IRegistryChangeListener {
    private static final String EXT_ID = "org.eclipse.mtj.core.mtjbuildhook";
    private static final String EXT_MTJ_BUILD_HOOK = "mtjbuildhook";
    private static BuildHooksRegistry instance;
    private List<BuildHookInfo> hooks;

    public static synchronized BuildHooksRegistry getInstance() {
        if (instance == null) {
            instance = new BuildHooksRegistry();
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)instance);
        }
        return instance;
    }

    private BuildHooksRegistry() {
        IExtensionRegistry iExtensionRegistry = null;
        IConfigurationElement[] iConfigurationElementArray = null;
        BuildHookInfo buildHookInfo = null;
        this.hooks = new ArrayList<BuildHookInfo>();
        iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(EXT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            buildHookInfo = new BuildHookInfo(iConfigurationElement);
            this.hooks.add(buildHookInfo);
            ++n2;
        }
    }

    public List<BuildHookInfo> getBuildHooks() {
        ArrayList<BuildHookInfo> arrayList = new ArrayList<BuildHookInfo>();
        arrayList.addAll(this.hooks);
        return arrayList;
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        String string = MTJCore.getMTJCore().getBundle().getSymbolicName();
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas(string, EXT_MTJ_BUILD_HOOK);
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            BuildHookInfo buildHookInfo;
            IConfigurationElement iConfigurationElement;
            int n2;
            int n3;
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2;
            if (iExtensionDeltaArray[n].getKind() == 1) {
                iConfigurationElementArray = iConfigurationElementArray2 = iExtensionDeltaArray[n].getExtension().getConfigurationElements();
                n3 = iConfigurationElementArray2.length;
                n2 = 0;
                while (n2 < n3) {
                    iConfigurationElement = iConfigurationElementArray[n2];
                    buildHookInfo = new BuildHookInfo(iConfigurationElement);
                    this.hooks.add(buildHookInfo);
                    ++n2;
                }
            } else {
                iConfigurationElementArray = iConfigurationElementArray2 = iExtensionDeltaArray[n].getExtension().getConfigurationElements();
                n3 = iConfigurationElementArray2.length;
                n2 = 0;
                while (n2 < n3) {
                    iConfigurationElement = iConfigurationElementArray[n2];
                    buildHookInfo = new BuildHookInfo(iConfigurationElement);
                    int n4 = 0;
                    while (n4 < this.hooks.size()) {
                        if (this.hooks.get(n4).getHookId().equals(buildHookInfo.getHookId())) {
                            this.hooks.remove(n4);
                            break;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }
}

