/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.BuildSpecManipulator;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MTJIncrementalProjectBuilder
extends IncrementalProjectBuilder {
    protected final IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        BuildStateMachine buildStateMachine = BuildStateMachine.getInstance(this.getMTJProject());
        IProject[] iProjectArray = null;
        BuildSpecManipulator buildSpecManipulator = new BuildSpecManipulator(this.getProject());
        if (buildSpecManipulator.isFirstBuilder(this.getBuilderId())) {
            buildStateMachine.start(iProgressMonitor);
        }
        this.onStateEnter(buildStateMachine, iProgressMonitor);
        if (n == 6) {
            this.doClean(6, iProgressMonitor);
        }
        iProjectArray = this.doBuild(n, map, iProgressMonitor);
        this.onStateExit(buildStateMachine, iProgressMonitor);
        if (buildSpecManipulator.isLastBuilder(this.getBuilderId())) {
            buildStateMachine.changeState(MTJBuildState.POST_BUILD, iProgressMonitor);
        }
        return iProjectArray;
    }

    protected final void clean(IProgressMonitor iProgressMonitor) throws CoreException {
        this.doClean(15, iProgressMonitor);
    }

    protected void onStateEnter(BuildStateMachine buildStateMachine, IProgressMonitor iProgressMonitor) throws CoreException {
        buildStateMachine.changeState(this.getEnterState(), iProgressMonitor);
    }

    protected void onStateExit(BuildStateMachine buildStateMachine, IProgressMonitor iProgressMonitor) throws CoreException {
        buildStateMachine.changeState(this.getExitState(), iProgressMonitor);
    }

    protected IMTJProject getMTJProject() {
        IJavaProject iJavaProject = JavaCore.create((IProject)this.getProject());
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
        return iMidletSuiteProject;
    }

    protected void assertCancelation(IProgressMonitor iProgressMonitor, boolean bl) {
        if (iProgressMonitor.isCanceled()) {
            if (bl) {
                this.forgetLastBuiltState();
            }
            throw new OperationCanceledException();
        }
    }

    protected abstract IProject[] doBuild(int var1, Map<?, ?> var2, IProgressMonitor var3) throws CoreException;

    protected abstract void doClean(int var1, IProgressMonitor var2) throws CoreException;

    protected abstract String getBuilderId();

    protected abstract MTJBuildState getEnterState();

    protected abstract MTJBuildState getExitState();
}

