/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.LibraryCollector;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateAntPackageTaskState
extends AbstractCreateAntTaskState {
    public CreateAntPackageTaskState(StateMachine stateMachine, IMidletSuiteProject iMidletSuiteProject, Document document) {
        super(stateMachine, iMidletSuiteProject, document);
    }

    protected void onEnter(MTJRuntime mTJRuntime) throws AntennaExportException {
        Document document = this.getDocument();
        Element element = document.getDocumentElement();
        String string = this.getFormatedName(mTJRuntime.getName());
        Element element2 = XMLUtils.createTargetElement(document, element, NLS.bind((String)"package-{0}", (Object)string), this.getDependencies(mTJRuntime));
        this.writePackageTask(element2, mTJRuntime);
    }

    private void writePackageTask(Element element, MTJRuntime mTJRuntime) throws AntennaExportException {
        String[] stringArray;
        Object object;
        IPath[] iPathArray;
        IProject iProject = this.getMidletSuiteProject().getProject();
        Document document = this.getDocument();
        String string = mTJRuntime.getName().replace(" ", "_");
        Element element2 = document.createElement("wtkpackage");
        String string2 = this.getFormatedName(iProject.getName());
        Object[] objectArray = new String[]{string, this.getMidletSuiteProject().getJadFileName()};
        element2.setAttribute("jadfile", NLS.bind((String)"deployed/{0}/{1}", (Object[])objectArray));
        objectArray = new String[]{string, this.getMidletSuiteProject().getJarFilename()};
        element2.setAttribute("jarfile", NLS.bind((String)"deployed/{0}/{1}", (Object[])objectArray));
        element2.setAttribute("autoversion", NLS.bind((String)"${0}{1}{2}", (Object[])new String[]{"{", "do-autoversion", "}"}));
        element2.setAttribute("obfuscate", NLS.bind((String)"${0}{1}{2}", (Object[])new String[]{"{", "do-obfuscate", "}"}));
        element2.setAttribute("preverify", "true");
        StringBuffer stringBuffer = new StringBuffer();
        IPath[] iPathArray2 = iPathArray = this.resolveLibraryPaths(this.getMidletSuiteProject(), false);
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iPathArray2[n2];
            stringBuffer.append(object.toOSString()).append(":");
            ++n2;
        }
        element2.setAttribute("bootclasspath", stringBuffer.toString());
        object = new StringBuffer();
        IPath[] iPathArray3 = iPathArray = this.resolveLibraryPaths(this.getMidletSuiteProject(), true);
        int n3 = iPathArray.length;
        n = 0;
        while (n < n3) {
            IPath iPath = iPathArray3[n];
            ((StringBuffer)object).append(iPath.toOSString()).append(":");
            ++n;
        }
        element2.setAttribute("libclasspath", ((StringBuffer)object).toString());
        element.appendChild(element2);
        String[] stringArray2 = stringArray = new String[]{"{0}/{1}/{2}/bin/", "{0}/{1}/{2}/resources/"};
        int n4 = stringArray.length;
        n3 = 0;
        while (n3 < n4) {
            String string3 = stringArray2[n3];
            Element element3 = document.createElement("fileset");
            element2.appendChild(element3);
            element3.setAttribute("dir", NLS.bind((String)string3, (Object[])new String[]{"mtj-build", string, this.getFormatedName(string2)}));
            ++n3;
        }
    }

    private IPath[] resolveLibraryPaths(IMidletSuiteProject iMidletSuiteProject, boolean bl) throws AntennaExportException {
        IJavaProject iJavaProject = this.getMidletSuiteProject().getJavaProject();
        LibraryCollector libraryCollector = new LibraryCollector();
        try {
            libraryCollector.getRunner().run(iJavaProject, libraryCollector, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            throw new AntennaExportException(coreException, "Unable to resolve library dependecies.");
        }
        return libraryCollector.getLibraryPaths(bl);
    }
}

