/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.packaging;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesCollector
implements IResourceVisitor {
    private IJavaProject javaProject;
    private List<IFile> resources;

    public ResourcesCollector(IJavaProject iJavaProject) {
        if (iJavaProject == null) {
            throw new IllegalArgumentException("project can not be null.");
        }
        this.javaProject = iJavaProject;
        this.resources = new ArrayList<IFile>();
    }

    public boolean visit(IResource iResource) throws CoreException {
        IPath iPath = this.javaProject.getOutputLocation();
        if (iPath.isPrefixOf(iResource.getFullPath()) && iResource.getType() == 1 && !iResource.getName().endsWith(".class")) {
            this.resources.add((IFile)iResource);
        }
        return true;
    }

    public List<IFile> getResources() {
        return this.resources;
    }
}

