/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.build.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.BuildSpecManipulator;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.build.MTJIncrementalProjectBuilder;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuildInfo;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuilderMessages;
import org.eclipse.mtj.internal.core.build.preverifier.builder.ResourceDeltaBuilder;
import org.eclipse.mtj.internal.core.util.RequiredProjectsCPEntryVisitor;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.osgi.util.NLS;

public class PreverificationBuilder
extends MTJIncrementalProjectBuilder {
    private static BuildLoggingConfiguration buildLoggingConfig = BuildLoggingConfiguration.getInstance();
    private static BuildConsoleProxy consoleProxy = BuildConsoleProxy.getInstance();

    public static void cleanProject(IProject iProject, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException, CoreException {
        IFolder iFolder;
        IFolder iFolder2;
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_0, (Object)iProject));
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        BuildInfo buildInfo = new BuildInfo(15, new HashMap(), iJavaProject);
        IFolder iFolder3 = iProject.getFolder(MTJCore.getVerifiedOutputDirectoryName());
        if (iFolder3.exists()) {
            Utils.clearContainer((IContainer)iFolder3, iProgressMonitor);
            iFolder3.delete(true, iProgressMonitor);
        }
        if ((iFolder2 = iProject.getFolder(".mtj.tmp").getFolder("runtime")).exists()) {
            Utils.clearContainer((IContainer)iFolder2, iProgressMonitor);
            iFolder2.delete(true, iProgressMonitor);
        }
        if ((iFolder = buildInfo.getMidletSuite().getVerifiedOutputFolder(iProgressMonitor)).exists()) {
            IResource[] iResourceArray;
            IResource[] iResourceArray2 = iResourceArray = iFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray2[n2];
                if (iResource.getType() == 2) {
                    Utils.clearContainer((IContainer)((IFolder)iResource), iProgressMonitor);
                } else {
                    iResource.delete(true, iProgressMonitor);
                }
                ++n2;
            }
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_1, (Object)iProject));
        }
    }

    private void clearPreprocessorMarkers() throws CoreException {
        this.getProject().deleteMarkers("org.eclipse.mtj.core.problem", false, 0);
    }

    private void createNoPreverifierFoundMarker() throws CoreException {
        final IProject iProject = this.getProject();
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IMarker iMarker = iProject.createMarker("org.eclipse.mtj.core.problem");
                iMarker.setAttribute("message", (Object)BuilderMessages.PreverificationBuilder_PreverifierNotFoundErrorMessage);
                iMarker.setAttribute("severity", 2);
            }
        };
        iProject.getWorkspace().run(iWorkspaceRunnable, null);
    }

    private IJavaProject[] getRequiredProjects(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        RequiredProjectsCPEntryVisitor requiredProjectsCPEntryVisitor = new RequiredProjectsCPEntryVisitor();
        requiredProjectsCPEntryVisitor.getRunner().run(iJavaProject, requiredProjectsCPEntryVisitor, iProgressMonitor);
        ArrayList<IJavaProject> arrayList = requiredProjectsCPEntryVisitor.getRequiredProjects();
        return arrayList.toArray(new IJavaProject[arrayList.size()]);
    }

    private void preverifyLibraries(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        IProject iProject = buildInfo.getCurrentJavaProject().getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_47) + iProject);
        }
        if (iProject != null && iProject.isAccessible()) {
            iProgressMonitor.setTaskName(String.valueOf(BuilderMessages.PreverificationBuilder_48) + iProject.getName());
            buildInfo.setCurrentResourceDelta(this.getDelta(iProject));
            ResourceDeltaBuilder resourceDeltaBuilder = new ResourceDeltaBuilder(buildInfo);
            resourceDeltaBuilder.preverifyLibraries(iProgressMonitor);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_49) + iProject);
        }
    }

    private void preverifyProject(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        IProject iProject = buildInfo.getCurrentJavaProject().getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_50) + iProject);
        }
        if (iProject != null && iProject.isAccessible()) {
            iProgressMonitor.setTaskName(String.valueOf(BuilderMessages.PreverificationBuilder_51) + iProject.getName());
            buildInfo.setCurrentResourceDelta(this.getDelta(iProject));
            ResourceDeltaBuilder resourceDeltaBuilder = new ResourceDeltaBuilder(buildInfo);
            resourceDeltaBuilder.build(iProgressMonitor);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_52) + iProject);
        }
    }

    private void setResourcesAsDerived(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        iFolder.refreshLocal(2, iProgressMonitor);
        Utils.setResourcesAsDerived((IContainer)iFolder);
    }

    protected IProject[] doBuild(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        IJavaProject iJavaProject;
        this.clearPreprocessorMarkers();
        IProject iProject = this.getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_61) + iProject);
        }
        IJavaProject iJavaProject2 = iJavaProject = JavaCore.create((IProject)iProject);
        IJavaProject[] iJavaProjectArray = this.getRequiredProjects(iJavaProject2, iProgressMonitor);
        iProgressMonitor.subTask(BuilderMessages.PreverificationBuilder_62);
        BuildInfo buildInfo = new BuildInfo(n, map, iJavaProject2);
        try {
            IJavaProject iJavaProject3;
            this.preverifyProject(buildInfo, iProgressMonitor);
            IJavaProject[] iJavaProjectArray2 = iJavaProjectArray;
            int n2 = iJavaProjectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                iJavaProject3 = iJavaProjectArray2[n3];
                iJavaProject2 = iJavaProject3;
                if (iJavaProject2 != null) {
                    buildInfo.setCurrentJavaProject(iJavaProject2);
                    this.preverifyProject(buildInfo, iProgressMonitor);
                }
                ++n3;
            }
            if (buildInfo.areLibrariesPreverified()) {
                buildInfo.setCurrentJavaProject(iJavaProject);
                this.preverifyLibraries(buildInfo, iProgressMonitor);
                iJavaProjectArray2 = iJavaProjectArray;
                n2 = iJavaProjectArray.length;
                n3 = 0;
                while (n3 < n2) {
                    iJavaProject2 = iJavaProject3 = iJavaProjectArray2[n3];
                    buildInfo.setCurrentJavaProject(iJavaProject2);
                    this.preverifyLibraries(buildInfo, iProgressMonitor);
                    ++n3;
                }
            }
            iJavaProject3 = new IProject[iJavaProjectArray.length];
            n3 = 0;
            while (n3 < iJavaProjectArray.length) {
                iJavaProject3[n3] = iJavaProjectArray[n3].getProject();
                ++n3;
            }
            if (buildInfo.isPackageDirty()) {
                this.setResourcesAsDerived(buildInfo.getVerifiedClassesFolder(iProgressMonitor), iProgressMonitor);
                this.setResourcesAsDerived(buildInfo.getVerifiedLibsFolder(iProgressMonitor), iProgressMonitor);
            }
            if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_63) + iProject);
            }
            iProgressMonitor.done();
            return iJavaProject3;
        }
        catch (PreverifierNotFoundException preverifierNotFoundException) {
            this.createNoPreverifierFoundMarker();
            return null;
        }
    }

    protected void doClean(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_64) + iProject);
        }
        PreverificationBuilder.cleanProject(iProject, false, iProgressMonitor);
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_65) + iProject);
        }
    }

    protected String getBuilderId() {
        return "org.eclipse.mtj.core.preverifier";
    }

    protected void onStateExit(BuildStateMachine buildStateMachine, IProgressMonitor iProgressMonitor) throws CoreException {
        super.onStateExit(buildStateMachine, iProgressMonitor);
        BuildSpecManipulator buildSpecManipulator = new BuildSpecManipulator(this.getMTJProject().getProject());
        if (!buildSpecManipulator.hasBuilder("org.eclipse.mtj.core.packageBuilder")) {
            buildSpecManipulator.addBuilderAfter("org.eclipse.mtj.core.preverifier", "org.eclipse.mtj.core.packageBuilder", null);
            buildSpecManipulator.commitChanges(iProgressMonitor);
        }
    }

    protected MTJBuildState getEnterState() {
        return MTJBuildState.PRE_PREVERIFICATION;
    }

    protected MTJBuildState getExitState() {
        return MTJBuildState.POST_PREVERIFICATION;
    }
}

