/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier.builder;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.core.build.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.preverifier.IClassErrorInformation;
import org.eclipse.mtj.internal.core.build.preverifier.IPreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationUtils;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuildInfo;
import org.eclipse.mtj.internal.core.util.AbstractClasspathEntryVisitor;
import org.eclipse.mtj.internal.core.util.FilteringClasspathEntryVisitor;
import org.eclipse.mtj.internal.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceDeltaBuilder {
    private BuildInfo buildInfo;
    private BuildLoggingConfiguration buildLoggingConfig;
    private BuildConsoleProxy consoleProxy = BuildConsoleProxy.getInstance();
    private IWorkspaceRoot workspaceRoot;

    public ResourceDeltaBuilder(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
        this.buildLoggingConfig = BuildLoggingConfiguration.getInstance();
        this.workspaceRoot = MTJCore.getWorkspace().getRoot();
    }

    private void attemptLibraryPreverification(IResource iResource, de.schlichtherle.io.File file, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        this.buildInfo.setPackageDirty(true);
        try {
            IPreverificationError[] iPreverificationErrorArray = this.buildInfo.getMidletSuite().preverifyJarFile((File)file, iFolder, iProgressMonitor);
            if (iPreverificationErrorArray.length > 0) {
                this.createJarErrorMarker(iResource, file, iPreverificationErrorArray);
            }
        }
        finally {
            iFolder.refreshLocal(2, iProgressMonitor);
        }
    }

    private void createErrorMarkerFor(IPreverificationError iPreverificationError) throws JavaModelException, CoreException {
        IResource iResource;
        IMarker iMarker = null;
        IClassErrorInformation iClassErrorInformation = ((IPreverificationErrorLocation)iPreverificationError.getLocation()).getClassInformation();
        String string = iClassErrorInformation == null ? "" : iClassErrorInformation.getName().replace('/', '.');
        String string2 = PreverificationUtils.getErrorText(iPreverificationError);
        IType iType = this.buildInfo.getCurrentJavaProject().findType(string);
        if (iType != null && (iResource = iType.getResource()) != null) {
            iMarker = iResource.createMarker("org.eclipse.jdt.core.problem");
            iMarker.setAttribute("message", (Object)string2);
            iMarker.setAttribute("severity", 2);
            int n = ((IPreverificationErrorLocation)iPreverificationError.getLocation()).getLineNumber();
            if (n != -1) {
                iMarker.setAttribute("lineNumber", n);
            }
            this.setMarkerRangeAttributes(iMarker, iPreverificationError, iType);
        }
        if (iMarker == null) {
            this.createProjectLevelPreverifyMarker(string, string2);
        }
    }

    private IPath[] getOutputLocations(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        OutputLocationsCollectionVisitor outputLocationsCollectionVisitor = new OutputLocationsCollectionVisitor();
        outputLocationsCollectionVisitor.getRunner().run(iJavaProject, outputLocationsCollectionVisitor, iProgressMonitor);
        Set<IPath> set = outputLocationsCollectionVisitor.getOutputLocations();
        return set.toArray(new IPath[set.size()]);
    }

    private void createJarErrorMarker(IResource iResource, de.schlichtherle.io.File file, IPreverificationError[] iPreverificationErrorArray) throws CoreException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("Preverification errors:\n");
        IPreverificationError[] iPreverificationErrorArray2 = iPreverificationErrorArray;
        int n = iPreverificationErrorArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iPreverificationErrorArray2[n2];
            stringBuffer.append(PreverificationUtils.getErrorText((IPreverificationError)object)).append("\n");
            ++n2;
        }
        object = iResource.createMarker("org.eclipse.jdt.core.problem");
        object.setAttribute("message", (Object)stringBuffer.toString());
        object.setAttribute("severity", 2);
    }

    private void createProjectLevelPreverifyMarker(String string, String string2) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer("Type ");
        stringBuffer.append(string).append(" ").append(string2);
        IProject iProject = this.buildInfo.getCurrentJavaProject().getProject();
        IMarker iMarker = iProject.createMarker("org.eclipse.jdt.core.problem");
        iMarker.setAttribute("message", (Object)stringBuffer.toString());
        iMarker.setAttribute("severity", 2);
    }

    private boolean doClassesRequirePreverification(de.schlichtherle.io.File file, de.schlichtherle.io.File file2) {
        boolean bl = false;
        if (file.isDirectory()) {
            if (!file2.exists()) {
                bl = true;
            } else {
                File[] fileArray;
                File[] fileArray2 = fileArray = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().endsWith(".class");
                    }
                });
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file3 = fileArray2[n2];
                    de.schlichtherle.io.File file4 = new de.schlichtherle.io.File(file3);
                    de.schlichtherle.io.File file5 = new de.schlichtherle.io.File((File)file2, file3.getName());
                    bl = this.doClassesRequirePreverification(file4, file5);
                    if (!bl) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            bl = this.isSourceNewerThanTarget(file, file2);
        }
        return bl;
    }

    private void preverifyClasses(List<IFile> list, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.handleClassAddsAndChanges; classFiles count = " + list.size());
        }
        this.buildInfo.setPackageDirty(true);
        IResource[] iResourceArray = list.toArray(new IResource[list.size()]);
        IFolder iFolder = this.buildInfo.getVerifiedClassesFolder(iProgressMonitor);
        try {
            IPreverificationError[] iPreverificationErrorArray = this.buildInfo.getMidletSuite().preverify(iResourceArray, iFolder, iProgressMonitor);
            iFolder.refreshLocal(2, iProgressMonitor);
            IPreverificationError[] iPreverificationErrorArray2 = iPreverificationErrorArray;
            int n = iPreverificationErrorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPreverificationError iPreverificationError = iPreverificationErrorArray2[n2];
                this.createErrorMarkerFor(iPreverificationError);
                ++n2;
            }
        }
        finally {
            iFolder.refreshLocal(2, iProgressMonitor);
        }
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.handleClassAddsAndChanges");
        }
    }

    private boolean isSourceNewerThanTarget(de.schlichtherle.io.File file, de.schlichtherle.io.File file2) {
        return !file2.exists() || file2.lastModified() < file.lastModified();
    }

    private void setMarkerRangeAttributes(IMarker iMarker, IPreverificationError iPreverificationError, IType iType) throws CoreException {
        int n = 1;
        int n2 = 1;
        switch (((IPreverificationErrorLocation)iPreverificationError.getLocation()).getLocationType().getTypeCode()) {
            case 0: {
                ISourceRange iSourceRange = iType.getNameRange();
                n = iSourceRange.getOffset();
                n2 = n + iSourceRange.getLength();
            }
        }
        iMarker.setAttribute("charStart", n);
        iMarker.setAttribute("charEnd", n2);
    }

    void build(IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.build");
        }
        ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor(iProgressMonitor);
        IResourceDelta iResourceDelta = this.buildInfo.getCurrentResourceDelta();
        if (iResourceDelta == null) {
            IPath[] iPathArray;
            IPath[] iPathArray2 = iPathArray = this.getOutputLocations(this.buildInfo.getCurrentJavaProject(), iProgressMonitor);
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath iPath = iPathArray2[n2];
                IResource iResource = this.workspaceRoot.findMember(iPath.makeAbsolute());
                if (iResource != null) {
                    iResource.accept((IResourceVisitor)resourceDeltaVisitor);
                }
                ++n2;
            }
        } else {
            iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
        }
        this.preverifyClasses(resourceDeltaVisitor.getClasses(), iProgressMonitor);
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.build");
        }
    }

    void preverifyLibraries(IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        IFolder iFolder = this.buildInfo.getVerifiedClassesFolder(iProgressMonitor);
        IFolder iFolder2 = this.buildInfo.getVerifiedLibsFolder(iProgressMonitor);
        LibraryCollectionVisitor libraryCollectionVisitor = new LibraryCollectionVisitor();
        libraryCollectionVisitor.getRunner().run(this.buildInfo.getCurrentJavaProject(), libraryCollectionVisitor, iProgressMonitor);
        ArrayList<IClasspathEntry> arrayList = libraryCollectionVisitor.getLibraryEntries();
        for (IClasspathEntry iClasspathEntry : arrayList) {
            Object object = Utils.getResolvedClasspathEntry(iClasspathEntry);
            IResource iResource = object instanceof IResource ? (IResource)object : this.buildInfo.getCurrentJavaProject().getProject();
            IPath iPath = iClasspathEntry.getPath().makeAbsolute();
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(Utils.getResolvedClasspathEntryFile(iClasspathEntry));
            if (file == null || this.buildInfo.hasLibraryBeenPreverified(file)) continue;
            this.buildInfo.addPreverifiedLibrary(file);
            IFolder iFolder3 = null;
            IFolder iFolder4 = null;
            if (file.isDirectory() && !file.isArchive()) {
                iFolder3 = iFolder;
                iFolder4 = iFolder;
            } else {
                iFolder3 = iFolder2.getFile(iPath.lastSegment());
                iFolder4 = iFolder2;
            }
            de.schlichtherle.io.File file2 = new de.schlichtherle.io.File(iFolder3.getLocation().toFile());
            boolean bl = false;
            bl = file.isDirectory() ? this.doClassesRequirePreverification(file, file2) : this.isSourceNewerThanTarget(file, file2);
            if (!bl) continue;
            this.attemptLibraryPreverification(iResource, file, iFolder4, iProgressMonitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryCollectionVisitor
    extends FilteringClasspathEntryVisitor {
        private ArrayList<IClasspathEntry> libraryEntries = new ArrayList();

        private LibraryCollectionVisitor() {
        }

        public ArrayList<IClasspathEntry> getLibraryEntries() {
            return this.libraryEntries;
        }

        @Override
        public void visitLibraryEntry(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
            if (this.isLibraryExported(iClasspathEntry)) {
                this.libraryEntries.add(iClasspathEntry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputLocationsCollectionVisitor
    extends AbstractClasspathEntryVisitor {
        private Set<IPath> outputLocations = new HashSet<IPath>();

        private OutputLocationsCollectionVisitor() {
        }

        public Set<IPath> getOutputLocations() {
            return this.outputLocations;
        }

        @Override
        public void visitSourceEntry(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
            IPath iPath = iClasspathEntry.getOutputLocation();
            if (iPath == null) {
                iPath = iJavaProject.getOutputLocation();
            }
            this.outputLocations.add(iPath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceDeltaVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        private List<IFile> classes;
        private IProgressMonitor monitor;

        public ResourceDeltaVisitor(IProgressMonitor iProgressMonitor) throws CoreException {
            this.monitor = iProgressMonitor;
            this.classes = new ArrayList<IFile>();
        }

        public List<IFile> getClasses() {
            ArrayList<IFile> arrayList = new ArrayList<IFile>();
            arrayList.addAll(this.classes);
            return arrayList;
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IResource iResource = iResourceDelta.getResource();
            if (this.isClassFile(iResource)) {
                switch (iResourceDelta.getKind()) {
                    case 1: 
                    case 4: {
                        this.visit(iResourceDelta.getResource());
                        break;
                    }
                    case 2: {
                        this.removeVerifiedResource(ResourceDeltaBuilder.this.buildInfo, iResource, this.monitor);
                    }
                }
            }
            return true;
        }

        public boolean visit(IResource iResource) throws CoreException {
            if (this.isClassFile(iResource)) {
                IFile iFile = (IFile)iResource;
                this.classes.add(iFile);
            }
            return true;
        }

        private void removeVerifiedResource(BuildInfo buildInfo, IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
            IFolder iFolder;
            IResource iResource2;
            IJavaProject iJavaProject = buildInfo.getCurrentJavaProject();
            IPath iPath = Utils.extractsSourceFolderRelativePath(iJavaProject, iResource);
            if (iPath != null && (iResource2 = (iFolder = buildInfo.getVerifiedClassesFolder(iProgressMonitor)).findMember(iPath)) != null) {
                iResource2.delete(true, iProgressMonitor);
            }
        }

        private boolean isClassFile(IResource iResource) {
            return iResource.getType() == 1 && iResource.getName().endsWith(".class") && ResourceDeltaBuilder.this.buildInfo.isOutputResource(iResource);
        }
    }
}

