/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaSourcePathComputer;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.build.preprocessor.PreprocessorBuilder;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class EmulationJavaSourcePathComputer
extends JavaSourcePathComputer {
    public static final String ID = "org.eclipse.mtj.core.launching.emulationSourcePathComputer";

    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) throws CoreException {
        ISourceContainer[] iSourceContainerArray = super.computeSourceContainers(iLaunchConfiguration, iProgressMonitor);
        if (this.isPreprocessingProject(iLaunchConfiguration)) {
            int n = 0;
            while (n < iSourceContainerArray.length) {
                IJavaProject iJavaProject;
                IJavaProject iJavaProject2;
                IProject iProject;
                IProject iProject2;
                if (iSourceContainerArray[n] instanceof JavaProjectSourceContainer && (iProject2 = PreprocessorBuilder.getOutputProject(iProject = (iJavaProject2 = ((JavaProjectSourceContainer)iSourceContainerArray[n]).getJavaProject()).getProject())).exists() && (iJavaProject = JavaCore.create((IProject)iProject2)).exists()) {
                    iSourceContainerArray[n] = new JavaProjectSourceContainer(iJavaProject);
                }
                ++n;
            }
        }
        return iSourceContainerArray;
    }

    public String getId() {
        return ID;
    }

    private boolean isPreprocessingProject(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl = false;
        try {
            String string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            IProject iProject = MTJCore.getWorkspace().getRoot().getProject(string);
            if (iProject.exists()) {
                bl = iProject.hasNature("org.eclipse.mtj.core.preprocessingNature");
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log(2, coreException);
        }
        return bl;
    }
}

