/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.refactoring.BuildPropertiesChange;
import org.eclipse.osgi.util.NLS;

public class BuildPropertiesMoveParticipant
extends MoveParticipant {
    private IType type;
    private IFile file;

    public RefactoringStatus checkConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws OperationCanceledException {
        ResourceChangeChecker resourceChangeChecker = (ResourceChangeChecker)checkConditionsContext.getChecker(ResourceChangeChecker.class);
        if (resourceChangeChecker != null && this.file.exists()) {
            IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = resourceChangeChecker.getDeltaFactory();
            iResourceChangeDescriptionFactory.change(this.file);
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(Messages.BuildPropertiesMoveParticipant_buildPropertiesChangeMessage);
        Object object = this.getArguments().getDestination();
        if (object instanceof IPackageFragment) {
            IPackageFragment iPackageFragment = (IPackageFragment)object;
            IPath iPath = this.type.getResource().getProjectRelativePath();
            IPath iPath2 = iPackageFragment.getResource().getProjectRelativePath();
            String string = NLS.bind((String)"{0}/{1}.java", (Object[])new String[]{iPath2.toString(), this.type.getElementName()});
            BuildPropertiesChange buildPropertiesChange = new BuildPropertiesChange(this.file, iPath.toString(), string);
            if (buildPropertiesChange.hasPropertiesChanges()) {
                compositeChange.add((Change)buildPropertiesChange);
            }
        }
        return compositeChange.getChildren().length > 0 ? compositeChange : null;
    }

    public String getName() {
        return Messages.BuildPropertiesMoveParticipant_buildPropertiesMoveParticipantName;
    }

    protected boolean initialize(Object object) {
        boolean bl = false;
        if (object instanceof IType) {
            this.type = (IType)object;
            IProject iProject = this.type.getJavaProject().getProject();
            this.file = iProject.getFile("build.properties");
            bl = true;
        }
        return bl;
    }
}

