/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class MidletJadTextFileMidletChange
extends TextFileChange {
    private static final String REGEX = "MIDlet-\\d+:.*?,.*?,(";
    private Matcher matcher;
    private Pattern matchPattern;
    private int mode;
    private String oldName;
    private String newName;

    public MidletJadTextFileMidletChange(int n, String string, IFile iFile, String string2, String string3) {
        super(string, iFile);
        this.mode = n;
        this.oldName = string2;
        this.newName = string3;
    }

    Matcher getMatcher(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.matcher == null) {
            iProgressMonitor.setTaskName("Initializing Regular Expression Matcher");
            String string = this.getCurrentContent(iProgressMonitor);
            this.matcher = this.getMatchPattern().matcher(string);
            iProgressMonitor.worked(1);
        }
        return this.matcher;
    }

    void initializeTextEdit(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.setTaskName("Initializing Text Edit");
        DeleteEdit deleteEdit = null;
        Matcher matcher = this.getMatcher(iProgressMonitor);
        if (this.mode == 1) {
            int n = matcher.start(1);
            int n2 = matcher.end(1);
            deleteEdit = new ReplaceEdit(n, n2 - n, this.newName);
        } else {
            int n = matcher.start();
            int n3 = matcher.end();
            deleteEdit = new DeleteEdit(n, n3 - n);
        }
        this.setEdit((TextEdit)deleteEdit);
        iProgressMonitor.worked(1);
    }

    private Pattern getMatchPattern() {
        if (this.matchPattern == null) {
            StringBuffer stringBuffer = new StringBuffer(REGEX).append(this.oldName).append(")");
            this.matchPattern = Pattern.compile(stringBuffer.toString());
        }
        return this.matchPattern;
    }
}

