/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistry;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistryListener;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.internal.core.persistence.XMLPersistenceProvider;
import org.eclipse.mtj.internal.core.util.migration.DeviceRegistryMigration;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceRegistry
implements IDeviceRegistry {
    private static IDeviceRegistry instance = null;
    private IDevice defaultDevice;
    private IPreverifier defaultPreverifier;
    private Map<String, Map<String, IDevice>> deviceGroupsMap;
    private Map<String, Map<String, IDevice>> invalidDeviceGroupsMap;
    private boolean fireDeviceAddedEvent = false;
    private ArrayList<IDeviceRegistryListener> listenerList = new ArrayList();

    public static IDeviceRegistry getInstance() {
        if (instance == null) {
            instance = new DeviceRegistry();
        }
        return instance;
    }

    private DeviceRegistry() {
        this.invalidDeviceGroupsMap = new HashMap<String, Map<String, IDevice>>();
        try {
            this.load();
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
        }
    }

    @Override
    public void addDevice(IDevice iDevice) throws IllegalArgumentException, PersistenceException {
        if (iDevice.getSDKName() == null || iDevice.getName() == null) {
            throw new IllegalArgumentException();
        }
        Map<String, IDevice> map = this.getDeviceGroupMap(iDevice.getSDKName(), true);
        map.put(iDevice.getName(), iDevice);
        if (this.fireDeviceAddedEvent) {
            this.fireDeviceAddedEvent(iDevice);
        }
    }

    @Override
    public void addRegistryListener(IDeviceRegistryListener iDeviceRegistryListener) {
        this.listenerList.add(iDeviceRegistryListener);
    }

    @Override
    public void clear() throws PersistenceException {
        this.getDeviceGroupsMap().clear();
    }

    @Override
    public void enableDeviceAddedEvent(boolean bl) {
        this.fireDeviceAddedEvent = bl;
    }

    @Override
    public List<IDevice> getAllDevices() throws PersistenceException {
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        for (Map<String, IDevice> map : this.getDeviceGroupsMap().values()) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    @Override
    public IDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public IPreverifier getDefaultPreferifier() {
        return this.defaultPreverifier;
    }

    @Override
    public IDevice getDevice(String string, String string2) throws PersistenceException {
        IDevice iDevice = null;
        Map<String, IDevice> map = this.getDeviceGroupMap(string, false);
        if (map != null) {
            iDevice = map.get(string2);
        }
        return iDevice;
    }

    @Override
    public int getDeviceCount() throws PersistenceException {
        int n = 0;
        for (Map<String, IDevice> map : this.getDeviceGroupsMap().values()) {
            n += map.size();
        }
        return n;
    }

    @Override
    public List<IDevice> getDevices(String string) throws PersistenceException {
        ArrayList<IDevice> arrayList = null;
        Map<String, IDevice> map = this.getDeviceGroupMap(string, false);
        if (map != null) {
            arrayList = new ArrayList<IDevice>(map.values());
        }
        return arrayList;
    }

    @Override
    public List<String> getSDKNames() throws PersistenceException {
        return new ArrayList<String>(this.getDeviceGroupsMap().keySet());
    }

    @Override
    public boolean isDeviceAddedEventEnabled() {
        return this.fireDeviceAddedEvent;
    }

    @Override
    public void load() throws PersistenceException {
        this.load(false);
    }

    private void load(boolean bl) throws PersistenceException {
        File file = this.getComponentStoreFile();
        if (file.exists()) {
            try {
                Document document = XMLUtils.readDocument(file);
                if (document == null) {
                    return;
                }
                Element element = document.getDocumentElement();
                if (!element.getNodeName().equals("deviceRegistry")) {
                    return;
                }
                DeviceRegistryMigration deviceRegistryMigration = new DeviceRegistryMigration();
                deviceRegistryMigration.migrate(document);
                if (deviceRegistryMigration.isMigrated()) {
                    try {
                        XMLUtils.writeDocument(file, document);
                    }
                    catch (TransformerException transformerException) {
                        transformerException.printStackTrace();
                    }
                    document = XMLUtils.readDocument(file);
                }
                XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider(document);
                this.loadUsing(xMLPersistenceProvider, bl);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new PersistenceException(parserConfigurationException.getMessage(), parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new PersistenceException(sAXException.getMessage(), sAXException);
            }
            catch (IOException iOException) {
                throw new PersistenceException(iOException.getMessage(), iOException);
            }
        }
    }

    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        this.loadUsing(iPersistenceProvider, false);
    }

    /*
     * WARNING - void declaration
     */
    private void loadUsing(IPersistenceProvider iPersistenceProvider, boolean bl) throws PersistenceException {
        this.enableDeviceAddedEvent(false);
        this.getDeviceGroupsMap().clear();
        this.invalidDeviceGroupsMap.clear();
        try {
            int n = iPersistenceProvider.loadInteger("deviceCount");
            int n2 = 0;
            while (n2 < n) {
                IDevice iDevice = (IDevice)iPersistenceProvider.loadPersistable("device" + n2);
                List<ILibrary> list = iDevice.getClasspath().getEntries();
                boolean bl2 = true;
                for (ILibrary iLibrary : list) {
                    File file = iLibrary.toFile();
                    if (file.exists()) continue;
                    bl2 = false;
                    break;
                }
                if (!bl) {
                    this.addDevice(iDevice);
                    if (!bl2) {
                        void var8_12;
                        Map<String, IDevice> map = this.invalidDeviceGroupsMap.get(iDevice.getSDKName());
                        if (map == null) {
                            HashMap hashMap = new HashMap();
                            this.invalidDeviceGroupsMap.put(iDevice.getSDKName(), hashMap);
                        }
                        if (!var8_12.containsKey(iDevice.getName())) {
                            var8_12.put(iDevice.getName(), iDevice);
                        }
                    }
                } else if (bl2) {
                    this.addDevice(iDevice);
                }
                ++n2;
            }
            this.defaultDevice = (IDevice)iPersistenceProvider.loadReference("defaultDevice");
            this.defaultPreverifier = (IPreverifier)iPersistenceProvider.loadPersistable("defaultPreverifier");
        }
        finally {
            this.enableDeviceAddedEvent(true);
        }
    }

    public void updateReferences() throws PersistenceException, TransformerException, IOException {
        this.load(true);
        this.store();
    }

    @Override
    public void removeDevice(IDevice iDevice) throws PersistenceException {
        Map<String, IDevice> map = this.getDeviceGroupMap(iDevice.getSDKName(), false);
        if (map != null) {
            String string = this.getDeviceKey(map, iDevice);
            if (string != null) {
                map.remove(string);
            }
            if (map.isEmpty()) {
                this.deviceGroupsMap.remove(iDevice.getSDKName());
            }
            if (iDevice.equals(this.defaultDevice)) {
                this.defaultDevice = null;
            }
        }
        this.fireDeviceRemovedEvent(iDevice);
    }

    private String getDeviceKey(Map<String, IDevice> map, IDevice iDevice) {
        String string = null;
        for (String string2 : map.keySet()) {
            IDevice iDevice2 = map.get(string2);
            if (iDevice2 != iDevice) continue;
            string = string2;
            break;
        }
        return string;
    }

    @Override
    public void removeRegistryListener(IDeviceRegistryListener iDeviceRegistryListener) {
        this.listenerList.remove(iDeviceRegistryListener);
    }

    @Override
    public void setDefaultDevice(IDevice iDevice) {
        this.defaultDevice = iDevice;
    }

    @Override
    public void setDefaultPreverifer(IPreverifier iPreverifier) {
        this.defaultPreverifier = iPreverifier;
    }

    @Override
    public void store() throws PersistenceException, TransformerException, IOException {
        XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider("deviceRegistry");
        this.storeUsing(xMLPersistenceProvider);
        XMLUtils.writeDocument(this.getComponentStoreFile(), xMLPersistenceProvider.getDocument());
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        List<IDevice> list = this.getAllDevices();
        iPersistenceProvider.storeInteger("deviceCount", list.size());
        int n = 0;
        for (IDevice iDevice : list) {
            iPersistenceProvider.storePersistable("device" + n++, iDevice);
        }
        if (this.defaultDevice != null) {
            iPersistenceProvider.storeReference("defaultDevice", this.defaultDevice);
        }
        if (this.defaultPreverifier != null) {
            iPersistenceProvider.storePersistable("defaultPreverifier", this.defaultPreverifier);
        }
    }

    private void createAndLoadDeviceGroups() throws PersistenceException {
        this.deviceGroupsMap = new HashMap<String, Map<String, IDevice>>();
        this.load();
    }

    private void fireDeviceAddedEvent(IDevice iDevice) {
        for (IDeviceRegistryListener iDeviceRegistryListener : this.listenerList) {
            iDeviceRegistryListener.deviceAdded(iDevice);
        }
    }

    private void fireDeviceRemovedEvent(IDevice iDevice) {
        for (IDeviceRegistryListener iDeviceRegistryListener : this.listenerList) {
            iDeviceRegistryListener.deviceRemoved(iDevice);
        }
    }

    private File getComponentStoreFile() {
        IPath iPath = MTJCore.getMTJCore().getStateLocation();
        IPath iPath2 = iPath.append("devices.xml");
        return iPath2.toFile();
    }

    private Map<String, IDevice> getDeviceGroupMap(String string, boolean bl) throws PersistenceException {
        Map<String, Map<String, IDevice>> map = this.getDeviceGroupsMap();
        Map<String, IDevice> map2 = map.get(string);
        if (map2 == null && bl) {
            map2 = new HashMap<String, IDevice>();
            map.put(string, map2);
        }
        return map2;
    }

    private synchronized Map<String, Map<String, IDevice>> getDeviceGroupsMap() throws PersistenceException {
        if (this.deviceGroupsMap == null) {
            this.createAndLoadDeviceGroups();
        }
        return this.deviceGroupsMap;
    }

    public List<String> getInvalidSDKNames() {
        return new ArrayList<String>(this.invalidDeviceGroupsMap.keySet());
    }
}

