/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.text.DocumentHandler;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentNodeFactory;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.text.IDocumentXMLNode;

public abstract class NodeDocumentHandler
extends DocumentHandler {
    private IDocumentNodeFactory fFactory;

    public NodeDocumentHandler(boolean bl, IDocumentNodeFactory iDocumentNodeFactory) {
        super(bl);
        this.fFactory = iDocumentNodeFactory;
    }

    protected abstract IDocument getDocument();

    protected IDocumentAttributeNode getDocumentAttribute(String string, String string2, IDocumentElementNode iDocumentElementNode) {
        IDocumentAttributeNode iDocumentAttributeNode = iDocumentElementNode.getDocumentAttribute(string);
        try {
            if (iDocumentAttributeNode == null) {
                iDocumentAttributeNode = this.fFactory.createAttribute(string, string2, iDocumentElementNode);
            } else {
                if (!string.equals(iDocumentAttributeNode.getAttributeName())) {
                    iDocumentAttributeNode.setAttributeName(string);
                }
                if (!string2.equals(iDocumentAttributeNode.getAttributeValue())) {
                    iDocumentAttributeNode.setAttributeValue(string2);
                }
            }
        }
        catch (CoreException coreException) {}
        return iDocumentAttributeNode;
    }

    protected IDocumentElementNode getDocumentNode(String string, IDocumentElementNode iDocumentElementNode) {
        IDocumentXMLNode iDocumentXMLNode;
        int n;
        int n2;
        IDocumentXMLNode[] iDocumentXMLNodeArray;
        IDocumentXMLNode[] iDocumentXMLNodeArray2;
        IDocumentXMLNode iDocumentXMLNode2 = null;
        if (iDocumentElementNode == null) {
            iDocumentXMLNode2 = this.getRootNode();
            if (iDocumentXMLNode2 != null) {
                iDocumentXMLNode2.setOffset(-1);
                iDocumentXMLNode2.setLength(-1);
            }
        } else {
            iDocumentXMLNodeArray2 = iDocumentElementNode.getChildNodes();
            iDocumentXMLNodeArray = iDocumentXMLNodeArray2;
            n2 = iDocumentXMLNodeArray2.length;
            n = 0;
            while (n < n2) {
                iDocumentXMLNode = iDocumentXMLNodeArray[n];
                if (iDocumentXMLNode.getOffset() < 0) {
                    if (!string.equals(iDocumentXMLNode.getXMLTagName())) break;
                    iDocumentXMLNode2 = iDocumentXMLNode;
                    break;
                }
                ++n;
            }
        }
        if (iDocumentXMLNode2 == null) {
            return this.fFactory.createDocumentNode(string, iDocumentElementNode);
        }
        iDocumentXMLNodeArray2 = iDocumentXMLNode2.getNodeAttributes();
        iDocumentXMLNodeArray = iDocumentXMLNodeArray2;
        n2 = iDocumentXMLNodeArray2.length;
        n = 0;
        while (n < n2) {
            iDocumentXMLNode = iDocumentXMLNodeArray[n];
            iDocumentXMLNode.setNameOffset(-1);
            iDocumentXMLNode.setNameLength(-1);
            iDocumentXMLNode.setValueOffset(-1);
            iDocumentXMLNode.setValueLength(-1);
            ++n;
        }
        int n3 = 0;
        while (n3 < iDocumentXMLNode2.getChildNodes().length) {
            IDocumentElementNode iDocumentElementNode2 = iDocumentXMLNode2.getChildAt(n3);
            iDocumentElementNode2.setOffset(-1);
            iDocumentElementNode2.setLength(-1);
            ++n3;
        }
        if (this.isReconciling()) {
            iDocumentXMLNode2.removeTextNode();
            iDocumentXMLNode2.setIsErrorNode(false);
        }
        return iDocumentXMLNode2;
    }

    protected IDocumentTextNode getDocumentTextNode(String string, IDocumentElementNode iDocumentElementNode) {
        IDocumentTextNode iDocumentTextNode = iDocumentElementNode.getTextNode();
        if (iDocumentTextNode == null) {
            if (string.trim().length() > 0) {
                iDocumentTextNode = this.fFactory.createDocumentTextNode(string, iDocumentElementNode);
            }
        } else {
            String string2 = String.valueOf(iDocumentTextNode.getText()) + string;
            iDocumentTextNode.setText(string2);
        }
        return iDocumentTextNode;
    }

    protected IDocumentNodeFactory getFactory() {
        return this.fFactory;
    }

    protected abstract IDocumentElementNode getRootNode();
}

